/*
 * Decompiled with CFR 0.152.
 */
package net.kenji.kenjiscombatforms.api.capabilities;

import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;

public class ExtraContainerCapability {
    public static final Capability<IExtraContainer> EXTRA_CONTAINER_CAP = CapabilityManager.get((CapabilityToken)new CapabilityToken<IExtraContainer>(){});
    public static String storedItem = "storedItem";
    public static String orignalSlot = "extraSlot";

    public static class Provider
    implements ICapabilityProvider,
    INBTSerializable<CompoundTag> {
        private final ExtraContainerImpl instance = new ExtraContainerImpl();
        private final LazyOptional<IExtraContainer> handler = LazyOptional.of(() -> this.instance);

        public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
            return EXTRA_CONTAINER_CAP.orEmpty(cap, this.handler.cast());
        }

        public CompoundTag serializeNBT() {
            return this.instance.serializeNBT();
        }

        public void deserializeNBT(CompoundTag nbt) {
            this.instance.deserializeNBT(nbt);
        }
    }

    public static class ExtraContainerImpl
    implements IExtraContainer,
    INBTSerializable<CompoundTag> {
        private ItemStack storedItem = ItemStack.f_41583_;
        private int originalSlot = -1;

        @Override
        public ItemStack getStoredItem() {
            return this.storedItem;
        }

        @Override
        public int getOriginalSlot() {
            return this.originalSlot;
        }

        @Override
        public void setStoredItem(ItemStack stack) {
            this.storedItem = stack;
        }

        @Override
        public void setOriginalSlot(int value) {
            this.originalSlot = value;
        }

        public CompoundTag serializeNBT() {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128365_(storedItem, (Tag)this.storedItem.m_41739_(new CompoundTag()));
            nbt.m_128405_(orignalSlot, this.originalSlot);
            return nbt;
        }

        public void deserializeNBT(CompoundTag nbt) {
            this.storedItem = ItemStack.m_41712_((CompoundTag)nbt.m_128469_(storedItem));
            this.originalSlot = nbt.m_128451_(orignalSlot);
        }
    }

    public static interface IExtraContainer {
        public ItemStack getStoredItem();

        public int getOriginalSlot();

        public void setStoredItem(ItemStack var1);

        public void setOriginalSlot(int var1);
    }
}

