/*
 * Decompiled with CFR 0.152.
 */
package net.kenji.kenjiscombatforms.api.handlers;

import java.util.List;
import java.util.Optional;
import net.kenji.kenjiscombatforms.api.handlers.GlobalFormStrategyHandler;
import net.kenji.kenjiscombatforms.api.handlers.data_handle.SavedDataHandler;
import net.kenji.kenjiscombatforms.api.interfaces.ability.Ability;
import net.kenji.kenjiscombatforms.api.interfaces.ability.FinalAbility;
import net.kenji.kenjiscombatforms.api.interfaces.form.AbstractFormData;
import net.kenji.kenjiscombatforms.api.interfaces.form.Form;
import net.kenji.kenjiscombatforms.api.managers.AbilityManager;
import net.kenji.kenjiscombatforms.api.managers.FormManager;
import net.kenji.kenjiscombatforms.api.managers.forms.VoidForm;
import net.kenji.kenjiscombatforms.api.managers.forms.WitherForm;
import net.kenji.kenjiscombatforms.network.NetworkHandler;
import net.kenji.kenjiscombatforms.network.fist_forms.client_data.SyncClientAbilityPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.PacketDistributor;

public class AbilityChangeHandler {
    private static final AbilityManager.AbilityOption1 NONE = AbilityManager.AbilityOption1.NONE;
    private static final AbilityManager.AbilityOption2 NONE2 = AbilityManager.AbilityOption2.NONE;
    private static final AbilityManager.AbilityOption3 NONE3 = AbilityManager.AbilityOption3.NONE;
    private static final FormManager.FormSelectionOption BASIC = FormManager.FormSelectionOption.BASIC;
    private static final FormManager.FormSelectionOption VOID = FormManager.FormSelectionOption.VOID;
    private static final FormManager.FormSelectionOption WITHER = FormManager.FormSelectionOption.WITHER;
    private static final AbilityChangeHandler INSTANCE = new AbilityChangeHandler();

    public static AbilityChangeHandler getInstance() {
        return INSTANCE;
    }

    public boolean getVoid1Selected(Player player) {
        return this.isAbilitySelected(player, AbilityManager.AbilityOption1.VOID_ABILITY1);
    }

    public boolean getWither1Selected(Player player) {
        return this.isAbilitySelected(player, AbilityManager.AbilityOption1.WITHER_ABILITY1);
    }

    private boolean isAbilitySelected(Player player, AbilityManager.AbilityOption1 form) {
        AbilityManager.PlayerAbilityData data = AbilityManager.getInstance().getPlayerAbilityData(player);
        return data.chosenAbility1 == form;
    }

    public void setAllAbilities(Player player) {
        this.setFormAbility1(player);
        this.setFormAbility2(player);
        this.setFormAbility3(player);
    }

    public void deactivateCurrentAbilities(Player player) {
        this.deactivateAbilities(player);
    }

    public void resetAllAbilityValues(Player player) {
        this.abilityValuesToReset(player);
    }

    public boolean getAllAbilityValuesReset(Player player) {
        return !this.getAbilityValues(player);
    }

    public void resetAllChosenAbilities(Player player) {
        this.resetChosenAbilities(player);
    }

    private void deactivateAbilities(Player player) {
        List<Ability> abilities = AbilityManager.getInstance().getCurrentAbilities(player);
        List<FinalAbility> finalAbilities = AbilityManager.getInstance().getCurrentFinalAbilities(player);
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (abilities != null) {
                abilities.forEach(ability -> {
                    if (ability != null && ability.getAbilityData(player) != null && ability.getAbilityData(player).isAbilityActive()) {
                        ability.deactivateAbilityOptional(serverPlayer);
                    }
                });
            }
            if (finalAbilities != null) {
                finalAbilities.forEach(finalAbility -> {
                    if (finalAbility != null && finalAbility.getAbilityData(player) != null && finalAbility.getAbilityData(player).isAbilityActive()) {
                        finalAbility.deactivateAbilityOptional(serverPlayer);
                    }
                });
            }
        }
    }

    private Optional<AbstractFormData> getFormData(Player player, String formName) {
        Form form = FormManager.getInstance().getForm(formName);
        return Optional.ofNullable(form).map(f -> f.getFormData(player.m_20148_()));
    }

    private void resetChosenAbilities(Player player) {
        AbilityManager.PlayerAbilityData abilityData = AbilityManager.getInstance().getPlayerAbilityData(player);
        abilityData.chosenAbility1 = NONE;
        abilityData.chosenAbility2 = NONE2;
        abilityData.chosenFinal = NONE3;
    }

    private void abilityValuesToReset(Player player) {
        AbstractFormData voidFormData = VoidForm.getInstance().getFormData(player.m_20148_());
        AbstractFormData witherFormData = WitherForm.getInstance().getFormData(player.m_20148_());
        voidFormData.setCurrentStoredAbility1(AbilityManager.AbilityOption1.NONE);
        voidFormData.setCurrentStoredAbility2(AbilityManager.AbilityOption2.NONE);
        witherFormData.setCurrentStoredAbility1(AbilityManager.AbilityOption1.NONE);
        witherFormData.setCurrentStoredAbility2(AbilityManager.AbilityOption2.NONE);
    }

    private boolean getAbilityValues(Player player) {
        return true;
    }

    public void storeAbility1(Player player, String formName, AbilityManager.AbilityOption1 ability) {
        this.getFormData(player, formName).ifPresent(formData -> {
            formData.setCurrentStoredAbility1(ability);
            this.setFormAbility1(player);
            FormManager.getInstance().getForm(formName).syncDataToClient(player);
        });
        AbilityManager.getInstance().updatePlayerData(player.m_20148_(), AbilityManager.getInstance().getPlayerAbilityData(player));
    }

    public void storeAbility2(Player player, String formName, AbilityManager.AbilityOption2 ability) {
        this.getFormData(player, formName).ifPresent(formData -> {
            formData.setCurrentStoredAbility2(ability);
            this.setFormAbility2(player);
            FormManager.getInstance().getForm(formName).syncDataToClient(player);
        });
        AbilityManager.getInstance().updatePlayerData(player.m_20148_(), AbilityManager.getInstance().getPlayerAbilityData(player));
    }

    public void setAbility1(Player player, FormManager.PlayerFormData formData, AbilityManager.PlayerAbilityData abilityData) {
        Optional.ofNullable(FormManager.getInstance().getForm(formData.selectedForm.name())).ifPresent(form -> {
            AbstractFormData specificFormData = form.getFormData(player.m_20148_());
            abilityData.ability1 = Optional.ofNullable(specificFormData.getCurrentStoredAbility1()).orElse(AbilityManager.AbilityOption1.NONE);
            form.updatePlayerData(player.m_20148_(), specificFormData);
            form.syncDataToClient(player);
        });
        AbilityManager.getInstance().updatePlayerData(player.m_20148_(), AbilityManager.getInstance().getPlayerAbilityData(player));
    }

    public void setAbility2(Player player, FormManager.PlayerFormData formData, AbilityManager.PlayerAbilityData abilityData) {
        Optional.ofNullable(FormManager.getInstance().getForm(formData.selectedForm.name())).ifPresent(form -> {
            AbstractFormData specificFormData = form.getFormData(player.m_20148_());
            abilityData.ability2 = Optional.ofNullable(specificFormData.getCurrentStoredAbility2()).orElse(AbilityManager.AbilityOption2.NONE);
            form.updatePlayerData(player.m_20148_(), specificFormData);
            form.syncDataToClient(player);
        });
        AbilityManager.getInstance().updatePlayerData(player.m_20148_(), AbilityManager.getInstance().getPlayerAbilityData(player));
    }

    public void setAbility3(Player player, FormManager.PlayerFormData formData, AbilityManager.PlayerAbilityData abilityData) {
        Optional.ofNullable(FormManager.getInstance().getForm(formData.selectedForm.name())).ifPresent(form -> {
            AbstractFormData specificFormData = form.getFormData(player.m_20148_());
            abilityData.ability3 = Optional.ofNullable(specificFormData.getStoredAbility3()).orElse(AbilityManager.AbilityOption3.NONE);
            form.updatePlayerData(player.m_20148_(), specificFormData);
            form.syncDataToClient(player);
        });
        AbilityManager.getInstance().updatePlayerData(player.m_20148_(), AbilityManager.getInstance().getPlayerAbilityData(player));
    }

    private void syncDataToClient(Player player) {
        FormManager.PlayerFormData formData = FormManager.getInstance().getFormData(player);
        AbilityManager.PlayerAbilityData abilityData = AbilityManager.getInstance().getPlayerAbilityData(player);
        Form currentForm = FormManager.getInstance().getForm(formData.selectedForm.name());
        AbstractFormData currentFormData = currentForm.getFormData(player.m_20148_());
        System.out.println("Is Syncing To Client! Ability1: " + abilityData.ability1 + "Ability2:" + abilityData.ability2 + "Ability3:" + abilityData.ability3);
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            NetworkHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new SyncClientAbilityPacket(abilityData.ability1, abilityData.ability2, abilityData.ability3, abilityData.chosenAbility1, abilityData.chosenAbility2, abilityData.chosenFinal, formData.selectedForm));
        }
    }

    public void storeFormAbility1(Player player, AbilityManager.AbilityOption1 ability) {
        FormManager.PlayerFormData formData = FormManager.getInstance().getFormData(player);
        System.out.println("HasStoredAbility! Ability1: " + ability);
        String form = formData.selectedForm.name();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            SavedDataHandler savedData = SavedDataHandler.get(serverPlayer.m_284548_());
            savedData.updatePlayerData(player.m_20148_());
            this.storeAbility1(player, form, ability);
            this.reValueAbility1(player, ability);
            savedData.m_77762_();
        }
    }

    public void storeFormAbility2(Player player, AbilityManager.AbilityOption2 ability) {
        FormManager.PlayerFormData formData = FormManager.getInstance().getFormData(player);
        System.out.println("HasStoredAbility! Ability2: " + ability);
        String form = formData.selectedForm.name();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            SavedDataHandler savedData = SavedDataHandler.get(serverPlayer.m_284548_());
            savedData.updatePlayerData(player.m_20148_());
            this.storeAbility2(player, form, ability);
            this.reValueAbility2(player, ability);
            savedData.m_77762_();
        }
    }

    public void setFormAbility1(Player player) {
        FormManager.PlayerFormData formData = FormManager.getInstance().getFormData(player);
        AbilityManager.PlayerAbilityData abilityData = AbilityManager.getInstance().getPlayerAbilityData(player);
        this.setAbility1(player, formData, abilityData);
    }

    public void setFormAbility2(Player player) {
        FormManager.PlayerFormData formData = FormManager.getInstance().getFormData(player);
        AbilityManager.PlayerAbilityData abilityData = AbilityManager.getInstance().getPlayerAbilityData(player);
        this.setAbility2(player, formData, abilityData);
    }

    public void setFormAbility3(Player player) {
        FormManager.PlayerFormData formData = FormManager.getInstance().getFormData(player);
        AbilityManager.PlayerAbilityData abilityData = AbilityManager.getInstance().getPlayerAbilityData(player);
        this.setAbility3(player, formData, abilityData);
    }

    public void reValueAbility1(Player player, AbilityManager.AbilityOption1 ability1) {
        AbilityManager.PlayerAbilityData abilityData = AbilityManager.getInstance().getPlayerAbilityData(player);
        if (abilityData.chosenAbility1 != AbilityManager.AbilityOption1.NONE) {
            GlobalFormStrategyHandler.getInstance().setChosenAbility1(player, ability1);
            GlobalFormStrategyHandler.getInstance().setPreviouslyChosenAbility1(player, ability1);
        }
        this.syncDataToClient(player);
    }

    public void reValueAbility2(Player player, AbilityManager.AbilityOption2 ability2) {
        AbilityManager.PlayerAbilityData abilityData = AbilityManager.getInstance().getPlayerAbilityData(player);
        if (abilityData.chosenAbility2 != AbilityManager.AbilityOption2.NONE) {
            GlobalFormStrategyHandler.getInstance().setChosenAbility2(player, ability2);
            GlobalFormStrategyHandler.getInstance().setPreviouslyChosenAbility2(player, ability2);
        }
        this.syncDataToClient(player);
    }

    public void setFormsAndAbilities(Player player, AbstractFormData currentFormData) {
        AbilityManager.PlayerAbilityData abilityData = AbilityManager.getInstance().getPlayerAbilityData(player);
        this.setFormAbility1(player);
        this.setFormAbility2(player);
        this.setFormAbility3(player);
        this.setAbilities(player, currentFormData, abilityData);
        AbilityChangeHandler abilityChangeHandler = AbilityChangeHandler.getInstance();
        abilityChangeHandler.deactivateCurrentAbilities(player);
        this.syncDataToClient(player);
        AbilityManager.getInstance().updatePlayerData(player.m_20148_(), AbilityManager.getInstance().getPlayerAbilityData(player));
    }

    private void setAbilities(Player player, AbstractFormData currentFormData, AbilityManager.PlayerAbilityData data) {
        GlobalFormStrategyHandler.getInstance().setStoredChosenAbilities(player, currentFormData.getPreviousAbility1(), currentFormData.getPreviousAbility2(), currentFormData.getPreviousAbility3());
    }
}

