/*
 * Decompiled with CFR 0.152.
 */
package net.kenji.kenjiscombatforms.api.handlers;

import net.kenji.kenjiscombatforms.api.PowerControl;
import net.kenji.kenjiscombatforms.api.capabilities.ExtraContainerCapability;
import net.kenji.kenjiscombatforms.api.handlers.CommonEventHandler;
import net.kenji.kenjiscombatforms.api.handlers.ControlHandler;
import net.kenji.kenjiscombatforms.api.handlers.FormChangeHandler;
import net.kenji.kenjiscombatforms.item.custom.base_items.BaseFistClass;
import net.kenji.kenjiscombatforms.keybinds.ModKeybinds;
import net.kenji.kenjiscombatforms.network.NetworkHandler;
import net.kenji.kenjiscombatforms.network.UpdateInventoryOpenPacket;
import net.kenji.kenjiscombatforms.network.capability.SyncNBTPacket;
import net.kenji.kenjiscombatforms.network.capability.SyncRemovedNBTPacket;
import net.kenji.kenjiscombatforms.network.movers.WitherInputPacket;
import net.kenji.kenjiscombatforms.network.voidform.ClientVoidData;
import net.kenji.kenjiscombatforms.network.witherform.ClientWitherData;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import yesman.epicfight.client.ClientEngine;
import yesman.epicfight.client.events.engine.ControllEngine;

@Mod.EventBusSubscriber(modid="kenjiscombatforms", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ClientEventHandler {
    private static long lastPressTime = 0L;
    private static final long PRESS_COOLDOWN = 100L;
    private boolean canCrash = false;
    private static final ClientEventHandler INSTANCE = new ClientEventHandler();
    public Player currentPlayer;
    static boolean hasSelected = false;
    private static boolean lastScreenWasContainer = false;

    public static ClientEventHandler getInstance() {
        return INSTANCE;
    }

    private PowerControl.controlRelatedEvents.PlayerData getOrCreatePlayerData(Player player) {
        return PowerControl.controlRelatedEvents.getInstance().playerDataMap.computeIfAbsent(player.m_20148_(), k -> new PowerControl.controlRelatedEvents.PlayerData());
    }

    public boolean getAreFinalsActive() {
        return ClientVoidData.getIsEnderActive() || ClientWitherData.getIsWitherActive();
    }

    public boolean getIsAllButWitherActive() {
        return ClientVoidData.getIsEnderActive() && !ClientWitherData.getIsWitherActive();
    }

    public boolean getAllButEnderActive() {
        return ClientWitherData.getIsWitherActive() && !ClientVoidData.getIsEnderActive();
    }

    public boolean getIsWitherActive() {
        return ClientWitherData.getIsWitherActive();
    }

    public void setCanCrash(boolean canCrash) {
        this.canCrash = canCrash;
    }

    public boolean getCanCrash() {
        return this.canCrash;
    }

    public void crash() {
        throw new RuntimeException("Intentional debug crash!");
    }

    public int getOriginalSlot(Player player) {
        return CommonEventHandler.getInstance().getOriginalSlot(player);
    }

    @SubscribeEvent
    public static void onKeyPress(InputEvent.Key event) {
        long currentTime;
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        FormChangeHandler formChangeHandler = FormChangeHandler.getInstance();
        CommonEventHandler commonEventHandler = CommonEventHandler.getInstance();
        if (player == null) {
            return;
        }
        if (ModKeybinds.TOGGLE_HAND_COMBAT_KEY.m_90859_() && (currentTime = System.currentTimeMillis()) - lastPressTime > 100L) {
            lastPressTime = currentTime;
            int originalSlot = ClientEventHandler.getInstance().getOriginalSlot((Player)player);
            int selectedSlot = player.m_150109_().f_35977_;
            ItemStack currentItem = player.m_150109_().m_8020_(selectedSlot);
            player.getCapability(ExtraContainerCapability.EXTRA_CONTAINER_CAP).ifPresent(arg_0 -> ClientEventHandler.lambda$onKeyPress$1(commonEventHandler, (Player)player, currentItem, selectedSlot, originalSlot, arg_0));
        }
    }

    public int getSelectedExtraSlot(Player player) {
        return player.m_150109_().f_35977_;
    }

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            Minecraft mc = Minecraft.m_91087_();
            LocalPlayer clientPlayer = mc.f_91074_;
            ControllEngine controllEngine = ClientEngine.getInstance().controllEngine;
            if (clientPlayer != null) {
                CommonEventHandler commonEventHandler = CommonEventHandler.getInstance();
                int originalSlot = ClientEventHandler.getInstance().getOriginalSlot((Player)clientPlayer);
                if (ClientWitherData.getIsWitherActive()) {
                    boolean jump = mc.f_91066_.f_92089_.m_90857_();
                    boolean sneak = ControlHandler.controlRelatedEvents.getInstance().getShiftDown((Player)clientPlayer);
                    NetworkHandler.INSTANCE.sendToServer((Object)new WitherInputPacket(jump, sneak));
                    Vec3 velocity = clientPlayer.m_20184_();
                    if (!(clientPlayer.m_9236_().m_8055_(clientPlayer.m_20183_().m_6625_(2)).m_60795_() && clientPlayer.m_9236_().m_8055_(clientPlayer.m_20183_()).m_60795_() || !jump)) {
                        clientPlayer.m_20334_(velocity.f_82479_, 0.2, velocity.f_82481_);
                    }
                    if (sneak) {
                        clientPlayer.m_20334_(velocity.f_82479_, -0.2, velocity.f_82481_);
                    }
                }
                if (ClientEventHandler.getInstance().getAreFinalsActive()) {
                    if (!hasSelected) {
                        CommonEventHandler.getInstance().setOriginalSlot((Player)clientPlayer, clientPlayer.m_150109_().f_35977_);
                        hasSelected = true;
                    }
                    clientPlayer.m_150109_().f_35977_ = CommonEventHandler.getInstance().getOriginalSlot((Player)clientPlayer);
                }
                if (!ClientEventHandler.getInstance().getAreFinalsActive() && hasSelected) {
                    hasSelected = false;
                }
                if (originalSlot != -1 && clientPlayer.m_150109_().f_35977_ != originalSlot) {
                    clientPlayer.getCapability(ExtraContainerCapability.EXTRA_CONTAINER_CAP).ifPresent(arg_0 -> ClientEventHandler.lambda$onClientTick$2(commonEventHandler, (Player)clientPlayer, originalSlot, arg_0));
                }
            }
            if (ClientEventHandler.getInstance().getCanCrash()) {
                ClientEventHandler.getInstance().crash();
            }
        }
    }

    @SubscribeEvent
    public static void onClientSetup(FMLClientSetupEvent event) {
        event.enqueueWork(() -> {});
    }

    @SubscribeEvent
    public static void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent event) {
        Player player;
        ClientEventHandler.getInstance().currentPlayer = player = event.getEntity();
        Minecraft mc = Minecraft.m_91087_();
    }

    @SubscribeEvent
    public static void onPlayerLeave(PlayerEvent.PlayerLoggedOutEvent event) {
        Player player = event.getEntity();
        Minecraft mc = Minecraft.m_91087_();
    }

    Player returnPlayer() {
        return ClientEventHandler.getInstance().currentPlayer;
    }

    private static boolean isHoldingFistFormItem(Player player) {
        return player.m_21205_().m_41720_() instanceof BaseFistClass;
    }

    @SubscribeEvent
    public static void onInventoryOpen(ScreenEvent.Init event) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player != null) {
            player.getCapability(ExtraContainerCapability.EXTRA_CONTAINER_CAP).ifPresent(arg_0 -> ClientEventHandler.lambda$onInventoryOpen$4((Player)player, event, arg_0));
        }
    }

    @SubscribeEvent
    public static void onGuiOpen(ScreenEvent.Init event) {
        if (event.getScreen() instanceof AbstractContainerScreen) {
            lastScreenWasContainer = true;
            NetworkHandler.INSTANCE.sendToServer((Object)new UpdateInventoryOpenPacket(true));
        }
    }

    @SubscribeEvent
    public static void onGuiClose(ScreenEvent.Closing event) {
        if (lastScreenWasContainer) {
            NetworkHandler.INSTANCE.sendToServer((Object)new UpdateInventoryOpenPacket(false));
            lastScreenWasContainer = false;
        }
    }

    @SubscribeEvent
    public static void onHotbarScroll(InputEvent.MouseScrollingEvent event) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ != null && ClientEventHandler.getInstance().getAreFinalsActive()) {
            event.setCanceled(true);
        }
    }

    private static /* synthetic */ void lambda$onInventoryOpen$4(Player player, ScreenEvent.Init event, ExtraContainerCapability.IExtraContainer container) {
        ItemStack storedItem = container.getStoredItem();
        if (player.m_21205_().m_41720_() instanceof BaseFistClass && event.getScreen() instanceof InventoryScreen) {
            if (!storedItem.m_41619_()) {
                player.m_150109_().m_6836_(ClientEventHandler.getInstance().getOriginalSlot(player), storedItem);
                NetworkHandler.INSTANCE.sendToServer((Object)new SyncNBTPacket(storedItem, ClientEventHandler.getInstance().getOriginalSlot(player)));
            }
            CommonEventHandler.getInstance().setStoredItemNBT(player, ItemStack.f_41583_);
            CommonEventHandler.getInstance().setOriginalSlot(player, -1);
            NetworkHandler.INSTANCE.sendToServer((Object)new SyncNBTPacket(storedItem, ClientEventHandler.getInstance().getOriginalSlot(player)));
        }
    }

    private static /* synthetic */ void lambda$onClientTick$2(CommonEventHandler commonEventHandler, Player clientPlayer, int originalSlot, ExtraContainerCapability.IExtraContainer container) {
        ItemStack storedItem = commonEventHandler.getStoredItem(clientPlayer);
        if (!storedItem.m_41619_()) {
            clientPlayer.m_150109_().m_6836_(originalSlot, storedItem);
            NetworkHandler.INSTANCE.sendToServer((Object)new SyncRemovedNBTPacket(storedItem, originalSlot));
            commonEventHandler.setStoredItemNBT(clientPlayer, ItemStack.f_41583_);
            commonEventHandler.setOriginalSlot(clientPlayer, -1);
            container.setOriginalSlot(-1);
            NetworkHandler.INSTANCE.sendToServer((Object)new SyncRemovedNBTPacket(storedItem, originalSlot));
            clientPlayer.m_150109_().m_6596_();
        }
        if (clientPlayer.m_150109_().m_8020_(originalSlot).m_41720_() instanceof BaseFistClass) {
            clientPlayer.m_150109_().m_6836_(originalSlot, ItemStack.f_41583_);
            NetworkHandler.INSTANCE.sendToServer((Object)new SyncRemovedNBTPacket(storedItem, originalSlot));
        }
    }

    private static /* synthetic */ void lambda$onKeyPress$1(CommonEventHandler commonEventHandler, Player player, ItemStack currentItem, int selectedSlot, int originalSlot, ExtraContainerCapability.IExtraContainer container) {
        ItemStack storedItem = commonEventHandler.getStoredItem(player);
        if (!ClientEventHandler.getInstance().getAreFinalsActive()) {
            if (storedItem.m_41619_()) {
                if (!(currentItem.m_41720_() instanceof BaseFistClass)) {
                    commonEventHandler.setStoredItemNBT(player, currentItem);
                    container.setStoredItem(currentItem);
                }
                commonEventHandler.setOriginalSlot(player, selectedSlot);
                container.setOriginalSlot(selectedSlot);
                NetworkHandler.INSTANCE.sendToServer((Object)new SyncNBTPacket(currentItem, selectedSlot));
                player.m_5496_(SoundEvents.f_12317_, 1.0f, 1.0f);
            } else if (!storedItem.m_41619_() && originalSlot != -1) {
                if (currentItem.m_41720_() instanceof BaseFistClass) {
                    player.m_150109_().m_6836_(originalSlot, ItemStack.f_41583_);
                }
                player.m_150109_().m_6836_(originalSlot, storedItem);
                NetworkHandler.INSTANCE.sendToServer((Object)new SyncRemovedNBTPacket(storedItem, originalSlot));
                container.setStoredItem(ItemStack.f_41583_);
                commonEventHandler.setStoredItemNBT(player, ItemStack.f_41583_);
                commonEventHandler.setOriginalSlot(player, -1);
                container.setOriginalSlot(-1);
                NetworkHandler.INSTANCE.sendToServer((Object)new SyncRemovedNBTPacket(storedItem, originalSlot));
                player.m_5496_(SoundEvents.f_12317_, 1.0f, 1.0f);
            }
            if (storedItem.m_41619_() && currentItem.m_41720_() instanceof BaseFistClass) {
                player.m_150109_().m_6836_(selectedSlot, ItemStack.f_41583_);
                NetworkHandler.INSTANCE.sendToServer((Object)new SyncRemovedNBTPacket(storedItem, selectedSlot));
                container.setOriginalSlot(-1);
            }
        }
    }
}

