/*
 * Decompiled with CFR 0.152.
 */
package net.kenji.kenjiscombatforms.api.handlers;

import java.util.List;
import net.kenji.kenjiscombatforms.api.capabilities.ExtraContainerCapability;
import net.kenji.kenjiscombatforms.api.handlers.AbilityChangeHandler;
import net.kenji.kenjiscombatforms.api.handlers.LevelHandler;
import net.kenji.kenjiscombatforms.api.managers.FormLevelManager;
import net.kenji.kenjiscombatforms.api.utils.SkillUtils;
import net.kenji.kenjiscombatforms.item.custom.base_items.BaseFistClass;
import net.kenji.kenjiscombatforms.network.NetworkHandler;
import net.kenji.kenjiscombatforms.network.capability.SyncNBTPacket;
import net.kenji.kenjiscombatforms.network.capability.SyncRemovedNBTPacket;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.event.entity.item.ItemTossEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.player.PlayerContainerEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.PacketDistributor;
import reascer.wom.gameasset.WOMSkills;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.skill.SkillSlot;
import yesman.epicfight.skill.SkillSlots;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;

@Mod.EventBusSubscriber(modid="kenjiscombatforms", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class CommonEventHandler {
    int originalSlot = -1;
    private static final CommonEventHandler INSTANCE = new CommonEventHandler();

    public int getOriginalSlot(Player player) {
        CompoundTag nbt = player.getPersistentData();
        return nbt.m_128451_("originalSlot");
    }

    public void setOriginalSlot(Player player, int slotIndex) {
        CompoundTag nbt = player.getPersistentData();
        nbt.m_128405_("originalSlot", slotIndex);
    }

    public void setStoredItemNBT(Player player, ItemStack storedItem) {
        CompoundTag nbt = player.getPersistentData();
        nbt.m_128365_(ExtraContainerCapability.storedItem, (Tag)storedItem.m_41777_().serializeNBT());
    }

    public ItemStack getStoredItem(Player player) {
        CompoundTag nbt = player.getPersistentData();
        return ItemStack.m_41712_((CompoundTag)nbt.m_128469_(ExtraContainerCapability.storedItem));
    }

    private FormLevelManager.PlayerFormLevelData getOrCreateLevelData(ServerPlayer player) {
        return LevelHandler.getInstance().getOrCreatePlayerLevelData((Player)player);
    }

    public static CommonEventHandler getInstance() {
        return INSTANCE;
    }

    public boolean getIsNearItem(Player player) {
        return CommonEventHandler.getInstance().isNearItem(player);
    }

    public boolean getIsHoldingFistForm(Player player) {
        return CommonEventHandler.isHoldingFistForm(player);
    }

    @SubscribeEvent
    public static void onDimensionChange(PlayerEvent.PlayerChangedDimensionEvent event) {
        Player player = event.getEntity();
        if (player == null) {
            return;
        }
        player.getCapability(ExtraContainerCapability.EXTRA_CONTAINER_CAP).ifPresent(container -> {
            ItemStack storedItem = container.getStoredItem();
            int originalSlot = container.getOriginalSlot();
            if (CommonEventHandler.getInstance().getOriginalSlot(player) != -1 && container.getOriginalSlot() != -1) {
                System.out.println("Stored Item before dimension change: " + storedItem);
                System.out.println("slot before dimension change: " + originalSlot);
                CompoundTag nbt = player.getPersistentData();
                CommonEventHandler.getInstance().setStoredItemNBT(player, storedItem);
                CommonEventHandler.getInstance().setOriginalSlot(player, originalSlot);
                System.out.println("Stored Item after dimension change: " + CommonEventHandler.getInstance().getStoredItem(player));
                System.out.println("slot after dimension change: " + CommonEventHandler.getInstance().getOriginalSlot(player));
                player.m_150109_().m_6836_(CommonEventHandler.getInstance().getOriginalSlot(player), ItemStack.f_41583_);
                player.m_150109_().m_6836_(CommonEventHandler.getInstance().getOriginalSlot(player), CommonEventHandler.getInstance().getStoredItem(player));
                player.f_36095_.m_38946_();
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    NetworkHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new SyncRemovedNBTPacket(storedItem, originalSlot));
                }
            }
        });
    }

    @SubscribeEvent
    public static void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent event) {
        String skillName;
        Skill skillToSet;
        Player player = event.getEntity();
        CompoundTag nbt = player.getPersistentData();
        int offHandSlot = 40;
        ItemStack storedItem = CommonEventHandler.getInstance().getStoredItem(player);
        int originalSlot = CommonEventHandler.getInstance().getOriginalSlot(player);
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            AbilityChangeHandler abilityChangeHandler = AbilityChangeHandler.getInstance();
            abilityChangeHandler.deactivateCurrentAbilities(player);
            if (CommonEventHandler.getInstance().getOriginalSlot(player) != -1 && !storedItem.m_41619_()) {
                if (player.m_150109_().m_8020_(originalSlot).m_41720_() instanceof BaseFistClass) {
                    player.m_150109_().m_6836_(originalSlot, ItemStack.f_41583_);
                }
                player.m_150109_().m_6836_(originalSlot, storedItem);
                NetworkHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new SyncRemovedNBTPacket(storedItem, originalSlot));
                CommonEventHandler.getInstance().setStoredItemNBT(player, ItemStack.f_41583_);
            }
        }
        if (nbt.m_128441_("storedDodgeSkill") && (skillToSet = SkillUtils.getSkillByName(skillName = nbt.m_128461_("storedDodgeSkill"))) != null) {
            event.getEntity().getCapability(EpicFightCapabilities.CAPABILITY_ENTITY).ifPresent(cap -> {
                if (cap instanceof PlayerPatch) {
                    PlayerPatch playerPatch = (PlayerPatch)cap;
                    if (CommonEventHandler.getInstance().getSkillValid(playerPatch)) {
                        playerPatch.getSkill((SkillSlot)SkillSlots.DODGE).setSkill(skillToSet);
                        nbt.m_128473_("storedDodgeSkill");
                        System.out.println("storeDodgeSkill" + skillName);
                    }
                }
            });
        }
    }

    boolean getSkillValid(PlayerPatch<?> playerPatch) {
        return playerPatch.getSkill((SkillSlot)SkillSlots.DODGE).getSkill() == WOMSkills.SHADOWSTEP || playerPatch.getSkill((SkillSlot)SkillSlots.DODGE).getSkill() == WOMSkills.ENDERSTEP || playerPatch.getSkill((SkillSlot)SkillSlots.DODGE).getSkill() == null;
    }

    @SubscribeEvent
    public static void onPlayerLeave(PlayerEvent.PlayerLoggedOutEvent event) {
        Player player = event.getEntity();
        if (!player.m_9236_().f_46443_) {
            AbilityChangeHandler abilityChangeHandler = AbilityChangeHandler.getInstance();
            abilityChangeHandler.deactivateCurrentAbilities(player);
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                ItemStack storedItem = CommonEventHandler.getInstance().getStoredItem(player);
                int originalSlot = CommonEventHandler.getInstance().getOriginalSlot(player);
                int selectedSlot = player.m_150109_().f_35977_;
                ItemStack currentItem = player.m_150109_().m_8020_(selectedSlot);
                if (originalSlot != -1) {
                    if (player.m_150109_().m_8020_(originalSlot).m_41720_() instanceof BaseFistClass) {
                        player.m_150109_().m_6836_(originalSlot, ItemStack.f_41583_);
                    }
                    if (!storedItem.m_41619_()) {
                        player.m_150109_().m_6836_(originalSlot, storedItem);
                        CommonEventHandler.getInstance().setStoredItemNBT(player, ItemStack.f_41583_);
                    }
                } else if (player.m_150109_().m_8020_(selectedSlot).m_41720_() instanceof BaseFistClass) {
                    player.m_150109_().m_6836_(selectedSlot, ItemStack.f_41583_);
                }
                NetworkHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new SyncNBTPacket(storedItem, originalSlot));
            }
        }
    }

    @SubscribeEvent
    public static void onDeath(LivingDeathEvent event) {
        LivingEntity entity = event.getEntity();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            AbilityChangeHandler abilityChangeHandler = AbilityChangeHandler.getInstance();
            abilityChangeHandler.deactivateCurrentAbilities(player);
            ItemStack storedItem = CommonEventHandler.getInstance().getStoredItem(player);
            int originalSlot = CommonEventHandler.getInstance().getOriginalSlot(player);
            int selectedSlot = player.m_150109_().f_35977_;
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                if (originalSlot != -1) {
                    if (player.m_150109_().m_8020_(originalSlot).m_41720_() instanceof BaseFistClass) {
                        player.m_150109_().m_6836_(originalSlot, ItemStack.f_41583_);
                    }
                    if (!storedItem.m_41619_()) {
                        player.m_150109_().m_6836_(originalSlot, storedItem);
                        CommonEventHandler.getInstance().setStoredItemNBT(player, ItemStack.f_41583_);
                    }
                } else if (player.m_150109_().m_8020_(selectedSlot).m_41720_() instanceof BaseFistClass) {
                    player.m_150109_().m_6836_(selectedSlot, ItemStack.f_41583_);
                }
                NetworkHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new SyncNBTPacket(storedItem, originalSlot));
            }
        }
    }

    @SubscribeEvent
    public void itemTossEvent(ItemTossEvent event) {
        if (CommonEventHandler.isHoldingFistForm(event.getPlayer())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onGuiOpen(PlayerContainerEvent.Open event) {
        Player player = event.getEntity();
    }

    private static boolean isHoldingFistForm(Player player) {
        Item handItem = player.m_21205_().m_41720_();
        return handItem instanceof BaseFistClass;
    }

    private boolean isNearItem(Player player) {
        double ITEM_DETECTION_RANGE = player.m_6143_();
        AABB detectionBox = player.m_20191_().m_82400_(ITEM_DETECTION_RANGE);
        List nearbyItems = player.m_9236_().m_45976_(ItemEntity.class, detectionBox);
        return !nearbyItems.isEmpty();
    }
}

