/*
 * Decompiled with CFR 0.152.
 */
package net.kenji.kenjiscombatforms.api.handlers;

import net.kenji.kenjiscombatforms.api.handlers.LevelHandler;
import net.kenji.kenjiscombatforms.api.handlers.data_handle.SavedDataHandler;
import net.kenji.kenjiscombatforms.api.interfaces.form.AbstractFormData;
import net.kenji.kenjiscombatforms.api.interfaces.form.Form;
import net.kenji.kenjiscombatforms.api.interfaces.form.FormAbilityStrategy;
import net.kenji.kenjiscombatforms.api.interfaces.form.FormLevelStrategy;
import net.kenji.kenjiscombatforms.api.managers.AbilityManager;
import net.kenji.kenjiscombatforms.api.managers.FormLevelManager;
import net.kenji.kenjiscombatforms.api.managers.FormManager;
import net.kenji.kenjiscombatforms.api.managers.forms.BasicForm;
import net.kenji.kenjiscombatforms.api.managers.forms.PowerForm;
import net.kenji.kenjiscombatforms.api.managers.forms.SwiftForm;
import net.kenji.kenjiscombatforms.api.managers.forms.VoidForm;
import net.kenji.kenjiscombatforms.api.managers.forms.WitherForm;
import net.kenji.kenjiscombatforms.network.NetworkHandler;
import net.kenji.kenjiscombatforms.network.fist_forms.client_data.SyncClientAbilityPacket;
import net.kenji.kenjiscombatforms.network.fist_forms.client_data.SyncClientFormsPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.PacketDistributor;

@Mod.EventBusSubscriber(modid="kenjiscombatforms", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class GlobalFormStrategyHandler {
    private static final GlobalFormStrategyHandler INSTANCE = new GlobalFormStrategyHandler();

    public static GlobalFormStrategyHandler getInstance() {
        return INSTANCE;
    }

    public void setStoredChosenAbilities(Player player, AbilityManager.AbilityOption1 ability, AbilityManager.AbilityOption2 ability2, AbilityManager.AbilityOption3 ability3) {
        FormLevelManager.PlayerFormLevelData levelData = LevelHandler.getInstance().getOrCreatePlayerLevelData(player);
        AbilityManager.PlayerAbilityData abilityData = AbilityManager.getInstance().getPlayerAbilityData(player);
        FormManager.PlayerFormData formData = FormManager.getInstance().getFormData(player);
        FormAbilityStrategy strategy = switch (formData.selectedForm) {
            case FormManager.FormSelectionOption.VOID -> new VoidForm.CurrentFormAbilityStrategy();
            case FormManager.FormSelectionOption.WITHER -> new WitherForm.CurrentFormAbilityStrategy();
            case FormManager.FormSelectionOption.BASIC -> new BasicForm.BasicFormAbilityStrategy();
            case FormManager.FormSelectionOption.SWIFT -> new SwiftForm.CurrentFormAbilityStrategy();
            case FormManager.FormSelectionOption.POWER -> new PowerForm.CurrentFormAbilityStrategy();
            default -> throw new IllegalStateException("Unexpected form: " + formData.selectedForm);
        };
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            SavedDataHandler savedData = SavedDataHandler.get(serverPlayer.m_284548_());
            savedData.updatePlayerData(player.m_20148_());
            savedData.m_77762_();
        }
        strategy.setStoredChosenAbilities(player, ability, ability2, ability3, abilityData);
        this.syncDataToClient(player);
        AbilityManager.getInstance().updatePlayerData(player.m_20148_(), abilityData);
    }

    public void setChosenAbility1(Player player, AbilityManager.AbilityOption1 ability) {
        FormLevelManager.PlayerFormLevelData levelData = LevelHandler.getInstance().getOrCreatePlayerLevelData(player);
        AbilityManager.PlayerAbilityData abilityData = AbilityManager.getInstance().getPlayerAbilityData(player);
        FormManager.PlayerFormData formData = FormManager.getInstance().getFormData(player);
        FormAbilityStrategy strategy = switch (formData.selectedForm) {
            case FormManager.FormSelectionOption.VOID -> new VoidForm.CurrentFormAbilityStrategy();
            case FormManager.FormSelectionOption.WITHER -> new WitherForm.CurrentFormAbilityStrategy();
            case FormManager.FormSelectionOption.BASIC -> new BasicForm.BasicFormAbilityStrategy();
            case FormManager.FormSelectionOption.SWIFT -> new SwiftForm.CurrentFormAbilityStrategy();
            case FormManager.FormSelectionOption.POWER -> new PowerForm.CurrentFormAbilityStrategy();
            default -> throw new IllegalStateException("Unexpected form: " + formData.selectedForm);
        };
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            SavedDataHandler savedData = SavedDataHandler.get(serverPlayer.m_284548_());
            savedData.updatePlayerData(player.m_20148_());
            savedData.m_77762_();
        }
        strategy.setChosenAbility1(player, ability, abilityData);
        this.syncDataToClient(player);
        AbilityManager.getInstance().updatePlayerData(player.m_20148_(), abilityData);
    }

    public void setChosenAbility2(Player player, AbilityManager.AbilityOption2 ability) {
        FormLevelManager.PlayerFormLevelData levelData = LevelHandler.getInstance().getOrCreatePlayerLevelData(player);
        AbilityManager.PlayerAbilityData abilityData = AbilityManager.getInstance().getPlayerAbilityData(player);
        FormManager.PlayerFormData formData = FormManager.getInstance().getFormData(player);
        FormAbilityStrategy strategy = switch (formData.selectedForm) {
            case FormManager.FormSelectionOption.VOID -> new VoidForm.CurrentFormAbilityStrategy();
            case FormManager.FormSelectionOption.WITHER -> new WitherForm.CurrentFormAbilityStrategy();
            case FormManager.FormSelectionOption.BASIC -> new BasicForm.BasicFormAbilityStrategy();
            case FormManager.FormSelectionOption.SWIFT -> new SwiftForm.CurrentFormAbilityStrategy();
            case FormManager.FormSelectionOption.POWER -> new PowerForm.CurrentFormAbilityStrategy();
            default -> throw new IllegalStateException("Unexpected form: " + formData.selectedForm);
        };
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            SavedDataHandler savedData = SavedDataHandler.get(serverPlayer.m_284548_());
            savedData.updatePlayerData(player.m_20148_());
            savedData.m_77762_();
        }
        strategy.setChosenAbility2(player, ability, abilityData);
        this.syncDataToClient(player);
        AbilityManager.getInstance().updatePlayerData(player.m_20148_(), abilityData);
    }

    public void setChosenAbility3(Player player, AbilityManager.AbilityOption3 ability) {
        FormLevelManager.PlayerFormLevelData levelData = LevelHandler.getInstance().getOrCreatePlayerLevelData(player);
        AbilityManager.PlayerAbilityData abilityData = AbilityManager.getInstance().getPlayerAbilityData(player);
        FormManager.PlayerFormData formData = FormManager.getInstance().getFormData(player);
        FormAbilityStrategy strategy = switch (formData.selectedForm) {
            case FormManager.FormSelectionOption.VOID -> new VoidForm.CurrentFormAbilityStrategy();
            case FormManager.FormSelectionOption.WITHER -> new WitherForm.CurrentFormAbilityStrategy();
            case FormManager.FormSelectionOption.BASIC -> new BasicForm.BasicFormAbilityStrategy();
            case FormManager.FormSelectionOption.SWIFT -> new SwiftForm.CurrentFormAbilityStrategy();
            case FormManager.FormSelectionOption.POWER -> new PowerForm.CurrentFormAbilityStrategy();
            default -> throw new IllegalStateException("Unexpected form: " + formData.selectedForm);
        };
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            SavedDataHandler savedData = SavedDataHandler.get(serverPlayer.m_284548_());
            savedData.updatePlayerData(player.m_20148_());
            savedData.m_77762_();
        }
        strategy.setChooseFinalAbility(player, ability, abilityData);
        this.syncDataToClient(player);
        AbilityManager.getInstance().updatePlayerData(player.m_20148_(), abilityData);
    }

    public void setPreviouslyChosenAbility1(Player player, AbilityManager.AbilityOption1 ability) {
        FormLevelManager.PlayerFormLevelData levelData = LevelHandler.getInstance().getOrCreatePlayerLevelData(player);
        AbilityManager.PlayerAbilityData abilityData = AbilityManager.getInstance().getPlayerAbilityData(player);
        FormManager.PlayerFormData formData = FormManager.getInstance().getFormData(player);
        FormAbilityStrategy strategy = switch (formData.selectedForm) {
            case FormManager.FormSelectionOption.VOID -> new VoidForm.CurrentFormAbilityStrategy();
            case FormManager.FormSelectionOption.WITHER -> new WitherForm.CurrentFormAbilityStrategy();
            case FormManager.FormSelectionOption.BASIC -> new BasicForm.BasicFormAbilityStrategy();
            case FormManager.FormSelectionOption.SWIFT -> new SwiftForm.CurrentFormAbilityStrategy();
            case FormManager.FormSelectionOption.POWER -> new PowerForm.CurrentFormAbilityStrategy();
            default -> throw new IllegalStateException("Unexpected form: " + formData.selectedForm);
        };
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            SavedDataHandler savedData = SavedDataHandler.get(serverPlayer.m_284548_());
            savedData.updatePlayerData(player.m_20148_());
            savedData.m_77762_();
        }
        strategy.storeChosenAbility1(player, ability, abilityData);
        this.syncDataToClient(player);
        AbilityManager.getInstance().updatePlayerData(player.m_20148_(), abilityData);
    }

    public void setPreviouslyChosenAbility2(Player player, AbilityManager.AbilityOption2 ability) {
        FormLevelManager.PlayerFormLevelData levelData = LevelHandler.getInstance().getOrCreatePlayerLevelData(player);
        AbilityManager.PlayerAbilityData abilityData = AbilityManager.getInstance().getPlayerAbilityData(player);
        FormManager.PlayerFormData formData = FormManager.getInstance().getFormData(player);
        FormAbilityStrategy strategy = switch (formData.selectedForm) {
            case FormManager.FormSelectionOption.VOID -> new VoidForm.CurrentFormAbilityStrategy();
            case FormManager.FormSelectionOption.WITHER -> new WitherForm.CurrentFormAbilityStrategy();
            case FormManager.FormSelectionOption.BASIC -> new BasicForm.BasicFormAbilityStrategy();
            case FormManager.FormSelectionOption.SWIFT -> new SwiftForm.CurrentFormAbilityStrategy();
            case FormManager.FormSelectionOption.POWER -> new PowerForm.CurrentFormAbilityStrategy();
            default -> throw new IllegalStateException("Unexpected form: " + formData.selectedForm);
        };
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            SavedDataHandler savedData = SavedDataHandler.get(serverPlayer.m_284548_());
            savedData.updatePlayerData(player.m_20148_());
            savedData.m_77762_();
        }
        strategy.storeChosenAbility2(player, ability, abilityData);
        this.syncDataToClient(player);
        AbilityManager.getInstance().updatePlayerData(player.m_20148_(), abilityData);
    }

    public void setPreviouslyChosenAbility3(Player player, AbilityManager.AbilityOption3 ability) {
        FormLevelManager.PlayerFormLevelData levelData = LevelHandler.getInstance().getOrCreatePlayerLevelData(player);
        AbilityManager.PlayerAbilityData abilityData = AbilityManager.getInstance().getPlayerAbilityData(player);
        FormManager.PlayerFormData formData = FormManager.getInstance().getFormData(player);
        FormAbilityStrategy strategy = switch (formData.selectedForm) {
            case FormManager.FormSelectionOption.VOID -> new VoidForm.CurrentFormAbilityStrategy();
            case FormManager.FormSelectionOption.WITHER -> new WitherForm.CurrentFormAbilityStrategy();
            case FormManager.FormSelectionOption.BASIC -> new BasicForm.BasicFormAbilityStrategy();
            case FormManager.FormSelectionOption.SWIFT -> new SwiftForm.CurrentFormAbilityStrategy();
            case FormManager.FormSelectionOption.POWER -> new PowerForm.CurrentFormAbilityStrategy();
            default -> throw new IllegalStateException("Unexpected form: " + formData.selectedForm);
        };
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            SavedDataHandler savedData = SavedDataHandler.get(serverPlayer.m_284548_());
            savedData.updatePlayerData(player.m_20148_());
            savedData.m_77762_();
        }
        strategy.storeChooseFinalAbility(player, ability, abilityData);
        this.syncDataToClient(player);
        AbilityManager.getInstance().updatePlayerData(player.m_20148_(), abilityData);
    }

    @SubscribeEvent
    public static void onLivingDeath(LivingDeathEvent event) {
        Entity entity = event.getSource().m_7639_();
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            FormManager.PlayerFormData formData = FormManager.getInstance().getFormData((Player)player);
            LivingEntity entity2 = event.getEntity();
            FormLevelStrategy strategy = switch (formData.selectedForm) {
                case FormManager.FormSelectionOption.BASIC -> new BasicForm.CurrentFormLevelStrategy();
                case FormManager.FormSelectionOption.VOID -> new VoidForm.CurrentFormLevelStrategy();
                case FormManager.FormSelectionOption.WITHER -> new WitherForm.CurrentFormLevelStrategy();
                case FormManager.FormSelectionOption.SWIFT -> new SwiftForm.CurrentFormLevelStrategy();
                case FormManager.FormSelectionOption.POWER -> new PowerForm.CurrentFormLevelStrategy();
                default -> throw new IllegalStateException("Unexpected form: " + formData.selectedForm);
            };
            SavedDataHandler savedData = SavedDataHandler.get(player.m_284548_());
            savedData.updatePlayerData(player.m_20148_());
            savedData.m_77762_();
            strategy.gainFormXp(player, (Entity)entity2);
            GlobalFormStrategyHandler.getInstance().syncDataToClient((Player)player);
        }
    }

    private void syncDataToClient(Player player) {
        FormManager.PlayerFormData formData = FormManager.getInstance().getFormData(player);
        AbilityManager.PlayerAbilityData abilityData = AbilityManager.getInstance().getPlayerAbilityData(player);
        Form currentForm = FormManager.getInstance().getForm(formData.selectedForm.name());
        AbstractFormData currentFormData = currentForm.getFormData(player.m_20148_());
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            NetworkHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new SyncClientAbilityPacket(abilityData.ability1, abilityData.ability2, abilityData.ability3, abilityData.chosenAbility1, abilityData.chosenAbility2, abilityData.chosenFinal, formData.selectedForm));
            NetworkHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new SyncClientFormsPacket(formData.form1, formData.form2, formData.form3, currentFormData.getCurrentFormLevel(), currentFormData.getCurrentFormXp(), currentFormData.getCurrentFormXpMAX()));
        }
    }
}

