/*
 * Decompiled with CFR 0.152.
 */
package net.kenji.kenjiscombatforms.api.handlers.data_handle;

import java.util.UUID;
import net.kenji.kenjiscombatforms.api.handlers.AbilityChangeHandler;
import net.kenji.kenjiscombatforms.api.handlers.data_handle.SavedDataHandler;
import net.kenji.kenjiscombatforms.api.interfaces.form.AbstractFormData;
import net.kenji.kenjiscombatforms.api.interfaces.form.Form;
import net.kenji.kenjiscombatforms.api.managers.AbilityManager;
import net.kenji.kenjiscombatforms.api.managers.FormLevelManager;
import net.kenji.kenjiscombatforms.api.managers.FormManager;
import net.kenji.kenjiscombatforms.api.managers.forms.BasicForm;
import net.kenji.kenjiscombatforms.api.managers.forms.VoidForm;
import net.kenji.kenjiscombatforms.api.managers.forms.WitherForm;
import net.kenji.kenjiscombatforms.network.NetworkHandler;
import net.kenji.kenjiscombatforms.network.fist_forms.client_data.SyncClientAbilityPacket;
import net.kenji.kenjiscombatforms.network.fist_forms.client_data.SyncClientFormsPacket;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.event.server.ServerStoppingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.PacketDistributor;

@Mod.EventBusSubscriber(modid="kenjiscombatforms", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class DataLoadHandler {
    @SubscribeEvent
    public static void onWorldLoad(LevelEvent.Load event) {
        if (!event.getLevel().m_5776_()) {
            ServerLevel level = (ServerLevel)event.getLevel();
            SavedDataHandler.get(level);
        }
    }

    @SubscribeEvent
    public static void onServerStopping(ServerStoppingEvent event) {
        ServerLevel level = event.getServer().m_129880_(Level.f_46428_);
        SavedDataHandler savedData = SavedDataHandler.get(level);
        savedData.m_77762_();
        level.m_8895_().m_78151_();
    }

    @SubscribeEvent
    public static void onWorldSave(LevelEvent.Save event) {
        if (!event.getLevel().m_5776_()) {
            ServerLevel level = (ServerLevel)event.getLevel();
            SavedDataHandler savedData = SavedDataHandler.get(level);
            savedData.m_77762_();
            savedData.forceSave(level);
            level.m_8895_().m_78151_();
        }
    }

    @SubscribeEvent
    public static void onPlayerLoggedOut(PlayerEvent.PlayerLoggedOutEvent event) {
        if (!event.getEntity().m_9236_().f_46443_) {
            ServerLevel level = (ServerLevel)event.getEntity().m_9236_();
            SavedDataHandler.get(level).m_77762_();
            level.m_8895_().m_78151_();
        }
    }

    @SubscribeEvent
    public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            SavedDataHandler savedData = SavedDataHandler.get(serverPlayer.m_284548_());
            CompoundTag playerData = savedData.getPlayerData(serverPlayer.m_20148_());
            DataLoadHandler.loadPlayerData(serverPlayer, playerData);
            DataLoadHandler.syncDataToClient((Player)serverPlayer);
        }
    }

    public static void requestDataSync(ServerPlayer player) {
        SavedDataHandler savedData = SavedDataHandler.get(player.m_284548_());
        CompoundTag playerData = savedData.getPlayerData(player.m_20148_());
        DataLoadHandler.loadPlayerData(player, playerData);
    }

    private static void loadPlayerData(ServerPlayer player, CompoundTag savedData) {
        UUID playerUUID = player.m_20148_();
        AbilityManager.PlayerAbilityData playerAbilityData = AbilityManager.getInstance().getOrCreatePlayerAbilityData((Player)player);
        FormManager.PlayerFormData playerFormData = FormManager.getInstance().getOrCreatePlayerFormData((Player)player);
        VoidForm.FormData voidFormData = VoidForm.getInstance().getOrCreateFormData((Player)player);
        WitherForm.FormData witherFormData = WitherForm.getInstance().getOrCreateFormData((Player)player);
        BasicForm.BasicFormData basicFormData = BasicForm.getInstance().getOrCreateFormData((Player)player);
        FormLevelManager.PlayerFormLevelData formLevelData = FormLevelManager.getInstance().getOrCreatePlayerLevelData((Player)player);
        try {
            SavedDataHandler.triggerPlayerDataLoad(playerUUID, playerAbilityData, playerFormData, savedData);
            AbilityManager.getInstance().playerDataMap.put(playerUUID, playerAbilityData);
            FormManager.getInstance().playerDataMap.put(playerUUID, playerFormData);
            VoidForm.getInstance().playerDataMap.put(playerUUID, voidFormData);
            WitherForm.getInstance().playerDataMap.put(playerUUID, witherFormData);
            BasicForm.getInstance().playerDataMap.put(playerUUID, basicFormData);
            FormLevelManager.getInstance().playerDataMap.put(playerUUID, formLevelData);
        }
        catch (Exception e) {
            System.out.println("Error loading data for player: " + playerUUID);
        }
        Form currentForm = FormManager.getInstance().getForm(playerFormData.selectedForm.name());
        AbstractFormData currentFormData = currentForm.getFormData(player.m_20148_());
        AbilityChangeHandler.getInstance().setFormsAndAbilities((Player)player, currentFormData);
    }

    private static void syncDataToClient(Player player) {
        AbstractFormData voidFormData = VoidForm.getInstance().getFormData(player.m_20148_());
        AbstractFormData witherFormData = WitherForm.getInstance().getFormData(player.m_20148_());
        FormManager.PlayerFormData formData = FormManager.getInstance().getFormData(player);
        AbilityManager.PlayerAbilityData abilityData = AbilityManager.getInstance().getPlayerAbilityData(player);
        Form currentForm = FormManager.getInstance().getForm(formData.selectedForm.name());
        AbstractFormData currentFormData = currentForm.getFormData(player.m_20148_());
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            NetworkHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new SyncClientFormsPacket(formData.form1, formData.form2, formData.form3, currentFormData.getCurrentFormLevel(), currentFormData.getCurrentFormXp(), currentFormData.getCurrentFormXpMAX()));
            NetworkHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new SyncClientAbilityPacket(abilityData.ability1, abilityData.ability2, abilityData.ability3, abilityData.chosenAbility1, abilityData.chosenAbility2, abilityData.chosenFinal, formData.selectedForm));
        }
    }
}

