/*
 * Decompiled with CFR 0.152.
 */
package net.kenji.kenjiscombatforms.api.handlers.power_data;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.kenji.kenjiscombatforms.api.interfaces.ability.AbstractAbilityData;
import net.kenji.kenjiscombatforms.config.EpicFightCombatFormsCommon;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;

public class EnderPlayerDataSets {
    public Map<UUID, TeleportPlayerData> A1playerDataMap = new ConcurrentHashMap<UUID, TeleportPlayerData>();
    public Map<UUID, VoidRiftPlayerData> A2playerDataMap = new ConcurrentHashMap<UUID, VoidRiftPlayerData>();
    public Map<UUID, EnderFormPlayerData> A3playerDataMap = new ConcurrentHashMap<UUID, EnderFormPlayerData>();
    public Map<UUID, EnderLevitationPlayerData> A4playerDataMap = new ConcurrentHashMap<UUID, EnderLevitationPlayerData>();
    public Map<UUID, VoidGrabPlayerData> A5playerDataMap = new ConcurrentHashMap<UUID, VoidGrabPlayerData>();
    public Map<UUID, EnderWarpPlayerData> A7playerDataMap = new ConcurrentHashMap<UUID, EnderWarpPlayerData>();
    private static final EnderPlayerDataSets INSTANCE = new EnderPlayerDataSets();
    private static final long PRESS_COOLDOWN = 4L;

    public static EnderPlayerDataSets getInstance() {
        return INSTANCE;
    }

    public TeleportPlayerData getOrCreateTeleportPlayerData(Player player) {
        return EnderPlayerDataSets.getInstance().A1playerDataMap.computeIfAbsent(player.m_20148_(), k -> new TeleportPlayerData());
    }

    public VoidRiftPlayerData getOrCreateVoidRiftPlayerData(Player player) {
        return EnderPlayerDataSets.getInstance().A2playerDataMap.computeIfAbsent(player.m_20148_(), k -> new VoidRiftPlayerData());
    }

    public EnderFormPlayerData getOrCreateEnderFormPlayerData(Player player) {
        return EnderPlayerDataSets.getInstance().A3playerDataMap.computeIfAbsent(player.m_20148_(), k -> new EnderFormPlayerData());
    }

    public EnderLevitationPlayerData getOrCreateEnderLevitationPlayerData(Player player) {
        return EnderPlayerDataSets.getInstance().A4playerDataMap.computeIfAbsent(player.m_20148_(), k -> new EnderLevitationPlayerData());
    }

    public VoidGrabPlayerData getOrCreateVoidGrabPlayerData(Player player) {
        return EnderPlayerDataSets.getInstance().A5playerDataMap.computeIfAbsent(player.m_20148_(), k -> new VoidGrabPlayerData());
    }

    public EnderWarpPlayerData getOrCreateEnderWarpPlayerData(Player player) {
        return EnderPlayerDataSets.getInstance().A7playerDataMap.computeIfAbsent(player.m_20148_(), k -> new EnderWarpPlayerData());
    }

    public static class TeleportPlayerData
    extends AbstractAbilityData {
        public final int INITIAL_PRESS_COUNTER = 90;
        public int tickCount = 0;
        public int abilityCooldown = this.MAX_COOLDOWN;
        public boolean isTpHoldActive = false;
        public Entity holdEntity;
        public int holdTickCounter = 0;
        public final int maxDist = (Integer)EpicFightCombatFormsCommon.TELEPORT_DIST.get();
        public long pressCounter = 90L;
        public long tpPressCounter = 90L;

        public TeleportPlayerData() {
            super((Integer)EpicFightCombatFormsCommon.ABILITY1_COOLDOWN.get());
        }

        @Override
        public void resetAbility() {
        }

        @Override
        public boolean isAbilityActive() {
            return false;
        }
    }

    public static class VoidRiftPlayerData
    extends AbstractAbilityData {
        public int tickCount = 0;
        public int abilityCooldown = this.MAX_COOLDOWN;
        public boolean isRiftActive = false;
        public boolean hasPlayedSound = false;
        public BlockPos riftPosition = null;
        public int timerCount = 0;
        public boolean canCount = false;

        public VoidRiftPlayerData() {
            super((Integer)EpicFightCombatFormsCommon.ABILITY2_COOLDOWN.get());
        }

        @Override
        public void resetAbility() {
        }

        @Override
        public boolean isAbilityActive() {
            return this.isRiftActive;
        }
    }

    public static class EnderFormPlayerData
    extends AbstractAbilityData {
        public int tickCount = 0;
        public boolean isEnderActive = false;
        public boolean hasPlayedSound = true;
        public int abilityCooldown = this.MAX_COOLDOWN;
        public final Map<UUID, Entity> playerEnderMap = new ConcurrentHashMap<UUID, Entity>();
        public Entity enderEntity;

        public EnderFormPlayerData() {
            super((Integer)EpicFightCombatFormsCommon.ABILITY3_COOLDOWN.get());
        }

        @Override
        public void resetAbility() {
        }

        @Override
        public boolean isAbilityActive() {
            return this.isEnderActive;
        }
    }

    public static class EnderLevitationPlayerData
    extends AbstractAbilityData {
        public int tickCount = 0;
        public int abilityCooldown = this.MAX_COOLDOWN;
        public boolean isActive = false;
        public int countTicker = 0;
        public Map<UUID, EntityState> affectedEntities = new HashMap<UUID, EntityState>();

        public EnderLevitationPlayerData() {
            super((Integer)EpicFightCombatFormsCommon.ABILITY4_COOLDOWN.get());
        }

        @Override
        public void resetAbility() {
        }

        @Override
        public boolean isAbilityActive() {
            return this.isActive;
        }

        public static class EntityState {
            public int levitationTicks = 0;
        }
    }

    public static class VoidGrabPlayerData
    extends AbstractAbilityData {
        public int tickCount = 0;
        public final int EXPLOSION_DAMAGE = (Integer)EpicFightCombatFormsCommon.EXPLOSION_DAMAGE.get();
        public int abilityCooldown = this.MAX_COOLDOWN;
        public boolean hasActivated = false;
        public int countTicker = 0;
        public Map<UUID, EntityState> affectedEntities = new HashMap<UUID, EntityState>();

        public VoidGrabPlayerData() {
            super((Integer)EpicFightCombatFormsCommon.ABILITY5_COOLDOWN.get());
        }

        @Override
        public void resetAbility() {
        }

        @Override
        public boolean isAbilityActive() {
            return false;
        }

        public static class EntityState {
            public int ticksRemaining;
            public boolean shouldThrow;
            public boolean hasThrown = false;
        }
    }

    public static class EnderWarpPlayerData
    extends AbstractAbilityData {
        public int tickCount = 0;
        public int abilityCooldown = this.MAX_COOLDOWN;
        public final int maxDist = (Integer)EpicFightCombatFormsCommon.TELEPORT_DIST.get();

        public EnderWarpPlayerData() {
            super(14);
        }

        @Override
        public void resetAbility() {
        }

        @Override
        public boolean isAbilityActive() {
            return false;
        }
    }
}

