/*
 * Decompiled with CFR 0.152.
 */
package net.kenji.kenjiscombatforms.api.handlers.power_data;

import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.kenji.kenjiscombatforms.api.interfaces.ability.AbstractAbilityData;
import net.kenji.kenjiscombatforms.config.EpicFightCombatFormsCommon;
import net.minecraft.world.entity.player.Player;

public class PowerPlayerDataSets {
    public Map<UUID, StrengthPlayerData> A1playerDataMap = new ConcurrentHashMap<UUID, StrengthPlayerData>();
    public Map<UUID, PowerInflictPlayerData> A2playerDataMap = new ConcurrentHashMap<UUID, PowerInflictPlayerData>();
    private static final PowerPlayerDataSets INSTANCE = new PowerPlayerDataSets();

    public static PowerPlayerDataSets getInstance() {
        return INSTANCE;
    }

    public StrengthPlayerData getOrCreateStrengthPlayerData(Player player) {
        return PowerPlayerDataSets.getInstance().A1playerDataMap.computeIfAbsent(player.m_20148_(), k -> new StrengthPlayerData());
    }

    public PowerInflictPlayerData getOrCreatePowerInflictPlayerData(Player player) {
        return PowerPlayerDataSets.getInstance().A2playerDataMap.computeIfAbsent(player.m_20148_(), k -> new PowerInflictPlayerData());
    }

    public static class StrengthPlayerData
    extends AbstractAbilityData {
        public int tickCount = 0;
        public int abilityCooldown = this.MAX_COOLDOWN;

        public StrengthPlayerData() {
            super((Integer)EpicFightCombatFormsCommon.ABILITY1_COOLDOWN.get());
        }

        @Override
        public void resetAbility() {
        }

        @Override
        public boolean isAbilityActive() {
            return false;
        }
    }

    public static class PowerInflictPlayerData
    extends AbstractAbilityData {
        public int tickCount = 0;
        public boolean isInflictActive = false;
        public int abilityCooldown = this.MAX_COOLDOWN;

        public PowerInflictPlayerData() {
            super((Integer)EpicFightCombatFormsCommon.ABILITY2_COOLDOWN.get());
        }

        @Override
        public void resetAbility() {
        }

        @Override
        public boolean isAbilityActive() {
            return this.isInflictActive;
        }
    }
}

