/*
 * Decompiled with CFR 0.152.
 */
package net.kenji.kenjiscombatforms.api.handlers.power_data;

import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.kenji.kenjiscombatforms.api.interfaces.ability.AbstractAbilityData;
import net.kenji.kenjiscombatforms.config.EpicFightCombatFormsCommon;
import net.minecraft.world.entity.player.Player;

public class SwiftPlayerDataSets {
    public Map<UUID, SpeedPlayerData> A1playerDataMap = new ConcurrentHashMap<UUID, SpeedPlayerData>();
    public Map<UUID, SwiftInflictPlayerData> A2playerDataMap = new ConcurrentHashMap<UUID, SwiftInflictPlayerData>();
    private static final SwiftPlayerDataSets INSTANCE = new SwiftPlayerDataSets();

    public static SwiftPlayerDataSets getInstance() {
        return INSTANCE;
    }

    public SpeedPlayerData getOrCreateSpeedPlayerData(Player player) {
        return SwiftPlayerDataSets.getInstance().A1playerDataMap.computeIfAbsent(player.m_20148_(), k -> new SpeedPlayerData());
    }

    public SwiftInflictPlayerData getOrCreateSwiftInflictPlayerData(Player player) {
        return SwiftPlayerDataSets.getInstance().A2playerDataMap.computeIfAbsent(player.m_20148_(), k -> new SwiftInflictPlayerData());
    }

    public static class SpeedPlayerData
    extends AbstractAbilityData {
        public int tickCount = 0;
        public int abilityCooldown = this.MAX_COOLDOWN;

        public SpeedPlayerData() {
            super((Integer)EpicFightCombatFormsCommon.ABILITY1_COOLDOWN.get());
        }

        @Override
        public void resetAbility() {
        }

        @Override
        public boolean isAbilityActive() {
            return false;
        }
    }

    public static class SwiftInflictPlayerData
    extends AbstractAbilityData {
        public int tickCount = 0;
        public boolean isInflictActive = false;
        public int abilityCooldown = this.MAX_COOLDOWN;

        public SwiftInflictPlayerData() {
            super((Integer)EpicFightCombatFormsCommon.ABILITY2_COOLDOWN.get());
        }

        @Override
        public void resetAbility() {
        }

        @Override
        public boolean isAbilityActive() {
            return this.isInflictActive;
        }
    }
}

