/*
 * Decompiled with CFR 0.152.
 */
package net.kenji.kenjiscombatforms.api.handlers.power_data;

import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.kenji.kenjiscombatforms.api.interfaces.ability.AbstractAbilityData;
import net.kenji.kenjiscombatforms.config.EpicFightCombatFormsCommon;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;

public class WitherPlayerDataSets {
    public Map<UUID, WitherDashPlayerData> A1playerDataMap = new ConcurrentHashMap<UUID, WitherDashPlayerData>();
    public Map<UUID, SoulDriftPlayerData> A2playerDataMap = new ConcurrentHashMap<UUID, SoulDriftPlayerData>();
    public Map<UUID, WitherFormPlayerData> A3playerDataMap = new ConcurrentHashMap<UUID, WitherFormPlayerData>();
    public Map<UUID, WitherMinionPlayerData> A4playerDataMap = new ConcurrentHashMap<UUID, WitherMinionPlayerData>();
    public Map<UUID, WitherImplodePlayerData> A5playerDataMap = new ConcurrentHashMap<UUID, WitherImplodePlayerData>();
    public Map<UUID, WitherFormDashPlayerData> A6playerDataMap = new ConcurrentHashMap<UUID, WitherFormDashPlayerData>();
    private static final WitherPlayerDataSets INSTANCE = new WitherPlayerDataSets();

    public static WitherPlayerDataSets getInstance() {
        return INSTANCE;
    }

    public WitherDashPlayerData getOrCreateDashPlayerData(Player player) {
        return WitherPlayerDataSets.getInstance().A1playerDataMap.computeIfAbsent(player.m_20148_(), k -> new WitherDashPlayerData());
    }

    public SoulDriftPlayerData getOrCreateSoulDriftPlayerData(Player player) {
        return WitherPlayerDataSets.getInstance().A2playerDataMap.computeIfAbsent(player.m_20148_(), k -> new SoulDriftPlayerData());
    }

    public WitherFormPlayerData getOrCreateWitherFormPlayerData(Player player) {
        return WitherPlayerDataSets.getInstance().A3playerDataMap.computeIfAbsent(player.m_20148_(), k -> new WitherFormPlayerData());
    }

    public WitherMinionPlayerData getOrCreateMinionPlayerData(Player player) {
        return WitherPlayerDataSets.getInstance().A4playerDataMap.computeIfAbsent(player.m_20148_(), k -> new WitherMinionPlayerData());
    }

    public WitherImplodePlayerData getOrCreateWitherImplodePlayerData(Player player) {
        return WitherPlayerDataSets.getInstance().A5playerDataMap.computeIfAbsent(player.m_20148_(), k -> new WitherImplodePlayerData());
    }

    public WitherFormDashPlayerData getOrCreateWitherFormDashPlayerData(Player player) {
        return WitherPlayerDataSets.getInstance().A6playerDataMap.computeIfAbsent(player.m_20148_(), k -> new WitherFormDashPlayerData());
    }

    public static class WitherDashPlayerData
    extends AbstractAbilityData {
        public int tickCount = 0;
        public int abilityCooldown = this.MAX_COOLDOWN;
        public final double MAX_SPEED = 3.0;
        public final double MAX_DISTANCE = 12.0;
        public final int MAX_DASH_TICKS = 12;
        public final double DECELERATION_DISTANCE = 5.0;
        public boolean isPauseActive = false;
        public boolean isDashActive = false;
        public boolean canIgnoreCollide = false;
        public final int MAX_BLOCKS = 5;
        public double distanceTraveled = 0.0;
        public Vec3 initialPosition = null;
        public int dashTicksRemaining = 0;
        public Vec3 dashDirection = null;
        public double currentSpeed = 0.0;

        public WitherDashPlayerData() {
            super((Integer)EpicFightCombatFormsCommon.ABILITY1_COOLDOWN.get());
        }

        @Override
        public void resetAbility() {
        }

        @Override
        public boolean isAbilityActive() {
            return false;
        }
    }

    public static class SoulDriftPlayerData
    extends AbstractAbilityData {
        public int tickCount = 0;
        public int abilityCooldown = this.MAX_COOLDOWN;
        public boolean isSoulDriftActive = false;
        public boolean hasPlayedSound = true;

        public SoulDriftPlayerData() {
            super((Integer)EpicFightCombatFormsCommon.ABILITY2_COOLDOWN.get());
        }

        @Override
        public void resetAbility() {
        }

        @Override
        public boolean isAbilityActive() {
            return this.isSoulDriftActive;
        }
    }

    public static class WitherFormPlayerData
    extends AbstractAbilityData {
        public int tickCount = 0;
        public boolean isWitherActive = false;
        public boolean isDelayPause = false;
        public boolean hasPlayedSound = true;
        public boolean isDashActive = false;
        public int abilityCooldown = this.MAX_COOLDOWN;
        public final Map<UUID, Entity> playerWitherMap = new ConcurrentHashMap<UUID, Entity>();
        public Entity witherEntity;

        public WitherFormPlayerData() {
            super((Integer)EpicFightCombatFormsCommon.ABILITY3_COOLDOWN.get());
        }

        @Override
        public void resetAbility() {
        }

        @Override
        public boolean isAbilityActive() {
            return this.isWitherActive;
        }
    }

    public static class WitherMinionPlayerData
    extends AbstractAbilityData {
        public int tickCount = 0;
        public final int MINION_COUNT = (Integer)EpicFightCombatFormsCommon.MINION_COUNT.get();
        public boolean areMinionsActive = false;
        public UUID playerUUID;
        public int abilityCooldown = this.MAX_COOLDOWN;
        public boolean hasPlayedSound = false;
        public int timerCount = 0;
        public boolean canCount = false;
        public Entity minionEntity;
        public Entity minionEntity2;
        public Entity minionEntity3;
        public Entity minionEntity4;
        public final Map<UUID, Entity> playerMinionMap = new ConcurrentHashMap<UUID, Entity>();
        public final Map<UUID, Entity> playerMinion2Map = new ConcurrentHashMap<UUID, Entity>();
        public final Map<UUID, Entity> playerMinion3Map = new ConcurrentHashMap<UUID, Entity>();
        public final Map<UUID, Entity> playerMinion4Map = new ConcurrentHashMap<UUID, Entity>();

        public WitherMinionPlayerData() {
            super((Integer)EpicFightCombatFormsCommon.ABILITY4_COOLDOWN.get() * 6);
        }

        @Override
        public void resetAbility() {
        }

        @Override
        public boolean isAbilityActive() {
            return this.areMinionsActive;
        }
    }

    public static class WitherImplodePlayerData
    extends AbstractAbilityData {
        public int tickCount = 0;
        public final int EXPLOSION_DAMAGE = (Integer)EpicFightCombatFormsCommon.EXPLOSION_DAMAGE.get();
        public int abilityCooldown = this.MAX_COOLDOWN;
        public boolean hasActivated = false;
        public int countTicker = 0;

        public WitherImplodePlayerData() {
            super((Integer)EpicFightCombatFormsCommon.ABILITY5_COOLDOWN.get());
        }

        @Override
        public void resetAbility() {
        }

        @Override
        public boolean isAbilityActive() {
            return false;
        }
    }

    public static class WitherFormDashPlayerData
    extends AbstractAbilityData {
        public int tickCount = 0;
        public int abilityCooldown = this.MAX_COOLDOWN;
        public final double MAX_SPEED = 3.0;
        public final double MAX_DISTANCE = 12.0;
        public final int MAX_DASH_TICKS = 12;
        public final double DECELERATION_DISTANCE = 5.0;
        public boolean isDashActive = false;
        public double distanceTraveled = 0.0;
        public Vec3 initialPosition = null;
        public int dashTicksRemaining = 0;
        public Vec3 dashDirection = null;
        public double currentSpeed = 0.0;

        public WitherFormDashPlayerData() {
            super(14);
        }

        @Override
        public void resetAbility() {
        }

        @Override
        public boolean isAbilityActive() {
            return false;
        }
    }
}

