/*
 * Decompiled with CFR 0.152.
 */
package net.kenji.kenjiscombatforms.api.managers;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.kenji.kenjiscombatforms.api.interfaces.ability.Ability;
import net.kenji.kenjiscombatforms.api.interfaces.ability.FinalAbility;
import net.kenji.kenjiscombatforms.api.managers.client_data.ClientFistData;
import net.minecraft.world.entity.player.Player;

public class AbilityManager {
    public final Map<UUID, PlayerAbilityData> playerDataMap = new ConcurrentHashMap<UUID, PlayerAbilityData>();
    private static final AbilityManager INSTANCE = new AbilityManager();
    private final Map<String, Ability> abilities = new HashMap<String, Ability>();
    private final Map<String, FinalAbility> finalAbilities = new HashMap<String, FinalAbility>();

    public void updatePlayerData(UUID playerUUID, PlayerAbilityData data) {
        this.playerDataMap.put(playerUUID, data);
    }

    public static AbilityManager getInstance() {
        return INSTANCE;
    }

    public void registerAbility(Ability ability) {
        this.abilities.put(ability.getName(), ability);
    }

    public void registerFinalAbility(FinalAbility finalAbility) {
        this.finalAbilities.put(finalAbility.getName(), finalAbility);
    }

    public Ability getAbility(String abilityName) {
        return this.abilities.get(abilityName);
    }

    public FinalAbility getFinalAbility(String abilityName) {
        return this.finalAbilities.get(abilityName);
    }

    public List<Ability> getCurrentAbilities(Player player) {
        PlayerAbilityData abilityData = AbilityManager.getInstance().getPlayerAbilityData(player);
        if (!player.m_9236_().f_46443_) {
            return Arrays.asList(AbilityManager.getInstance().getAbility(abilityData.chosenAbility1.name()), AbilityManager.getInstance().getAbility(abilityData.chosenAbility2.name()), AbilityManager.getInstance().getAbility(abilityData.chosenFinal.name()));
        }
        return Arrays.asList(AbilityManager.getInstance().getAbility(ClientFistData.getCurrentAbility1().name()), AbilityManager.getInstance().getAbility(ClientFistData.getCurrentAbility2().name()), AbilityManager.getInstance().getAbility(ClientFistData.getCurrentAbility3().name()));
    }

    public List<FinalAbility> getCurrentFinalAbilities(Player player) {
        PlayerAbilityData abilityData = AbilityManager.getInstance().getPlayerAbilityData(player);
        if (!player.m_9236_().f_46443_) {
            return Arrays.asList(AbilityManager.getInstance().getFinalAbility(abilityData.ability4.name()), AbilityManager.getInstance().getFinalAbility(abilityData.ability5.name()));
        }
        return Arrays.asList(AbilityManager.getInstance().getFinalAbility(ClientFistData.getCurrentAbility4().name()), AbilityManager.getInstance().getFinalAbility(ClientFistData.getCurrentAbility5().name()));
    }

    public PlayerAbilityData getOrCreatePlayerAbilityData(Player player) {
        return this.playerDataMap.computeIfAbsent(player.m_20148_(), k -> new PlayerAbilityData());
    }

    public PlayerAbilityData getPlayerAbilityData(Player player) {
        return this.getOrCreatePlayerAbilityData(player);
    }

    public static class PlayerAbilityData {
        public AbilityOption1 chosenAbility1 = AbilityOption1.NONE;
        public AbilityOption2 chosenAbility2 = AbilityOption2.NONE;
        public AbilityOption3 chosenFinal = AbilityOption3.NONE;
        public AbilityOption1 ability1 = AbilityOption1.NONE;
        public AbilityOption2 ability2 = AbilityOption2.NONE;
        public AbilityOption3 ability3 = AbilityOption3.NONE;
        public AbilityOption4 ability4 = AbilityOption4.NONE;
        public AbilityOption5 ability5 = AbilityOption5.NONE;
    }

    public static enum AbilityOption1 {
        NONE,
        VOID_ABILITY1,
        WITHER_ABILITY1,
        SWIFT_ABILITY1,
        POWER_ABILITY1;

    }

    public static enum AbilityOption2 {
        NONE,
        VOID_ABILITY2,
        WITHER_ABILITY2,
        SWIFT_ABILITY2,
        POWER_ABILITY2;

    }

    public static enum AbilityOption3 {
        NONE,
        VOID_FINAL,
        WITHER_FINAL;

    }

    public static enum AbilityOption4 {
        NONE,
        ENDER_LEVITATION,
        WITHER_MINIONS;

    }

    public static enum AbilityOption5 {
        NONE,
        VOID_GRAB,
        WITHER_IMPLODE;

    }

    public static enum AltAbilityOption {
        NONE,
        ENDER_WARP,
        WITHER_DASH,
        VOID_BACKSTAB;

    }
}

