/*
 * Decompiled with CFR 0.152.
 */
package net.kenji.kenjiscombatforms.api.managers;

import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.kenji.kenjiscombatforms.config.EpicFightCombatFormsCommon;
import net.minecraft.world.entity.player.Player;

public class FormLevelManager {
    public final Map<UUID, PlayerFormLevelData> playerDataMap = new ConcurrentHashMap<UUID, PlayerFormLevelData>();
    private static final FormLevelManager INSTANCE = new FormLevelManager();

    public static FormLevelManager getInstance() {
        return INSTANCE;
    }

    public void updatePlayerData(UUID playerUUID, PlayerFormLevelData data) {
        this.playerDataMap.put(playerUUID, data);
    }

    public PlayerFormLevelData getOrCreatePlayerLevelData(Player player) {
        return this.playerDataMap.computeIfAbsent(player.m_20148_(), k -> new PlayerFormLevelData());
    }

    public static class PlayerFormLevelData {
        public int voidFormMAX = (Integer)EpicFightCombatFormsCommon.MAX_FORM_STARTING_XP.get();
        public int witherFormMAX = (Integer)EpicFightCombatFormsCommon.MAX_FORM_STARTING_XP.get();
    }

    public static enum FormLevel {
        LEVEL1,
        LEVEL2,
        LEVEL3;

    }
}

