/*
 * Decompiled with CFR 0.152.
 */
package net.kenji.kenjiscombatforms.api.managers;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.kenji.kenjiscombatforms.api.interfaces.form.Form;
import net.minecraft.world.entity.player.Player;

public class FormManager {
    public final Map<UUID, PlayerFormData> playerDataMap = new ConcurrentHashMap<UUID, PlayerFormData>();
    private static final FormManager INSTANCE = new FormManager();
    private final Map<String, Form> forms = new HashMap<String, Form>();

    public static FormManager getInstance() {
        return INSTANCE;
    }

    public void updatePlayerData(UUID playerUUID, PlayerFormData data) {
        this.playerDataMap.put(playerUUID, data);
    }

    public void registerForm(Form form) {
        this.forms.put(form.getName(), form);
    }

    public Form getForm(String formName) {
        return this.forms.get(formName);
    }

    public PlayerFormData getOrCreatePlayerFormData(Player player) {
        return this.playerDataMap.computeIfAbsent(player.m_20148_(), k -> new PlayerFormData());
    }

    public PlayerFormData getFormData(Player player) {
        return this.getOrCreatePlayerFormData(player);
    }

    public static class PlayerFormData {
        public FormSelectionOption selectedForm = FormSelectionOption.BASIC;
        public FormSelectionOption form1 = FormSelectionOption.NONE;
        public FormSelectionOption form2 = FormSelectionOption.NONE;
        public FormSelectionOption form3 = FormSelectionOption.NONE;
    }

    public static enum FormSelectionOption {
        BASIC,
        VOID,
        WITHER,
        SWIFT,
        POWER,
        NONE;

    }
}

