/*
 * Decompiled with CFR 0.152.
 */
package net.kenji.kenjiscombatforms.api.powers.VoidPowers;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.UUID;
import net.kenji.kenjiscombatforms.api.capabilities.ExtraContainerCapability;
import net.kenji.kenjiscombatforms.api.handlers.CommonEventHandler;
import net.kenji.kenjiscombatforms.api.handlers.power_data.EnderPlayerDataSets;
import net.kenji.kenjiscombatforms.api.interfaces.ability.Ability;
import net.kenji.kenjiscombatforms.api.interfaces.ability.AbilityDamageGainStrategy;
import net.kenji.kenjiscombatforms.api.interfaces.ability.AbstractAbilityData;
import net.kenji.kenjiscombatforms.api.managers.AbilityManager;
import net.kenji.kenjiscombatforms.api.managers.client_data.ClientFistData;
import net.kenji.kenjiscombatforms.config.EpicFightCombatFormsCommon;
import net.kenji.kenjiscombatforms.entity.custom.noAiEntities.EnderEntity;
import net.kenji.kenjiscombatforms.event.CommonFunctions;
import net.kenji.kenjiscombatforms.item.custom.base_items.BaseFistClass;
import net.kenji.kenjiscombatforms.item.custom.fist_forms.EnderFormItem;
import net.kenji.kenjiscombatforms.network.NetworkHandler;
import net.kenji.kenjiscombatforms.network.capability.SyncNBTPacket;
import net.kenji.kenjiscombatforms.network.capability.SyncRemovedNBTPacket;
import net.kenji.kenjiscombatforms.network.fist_forms.client_data.SyncClientFinalAbilitesPacket;
import net.kenji.kenjiscombatforms.network.particle_packets.EndParticlesTickPacket;
import net.kenji.kenjiscombatforms.network.voidform.ClientVoidData;
import net.kenji.kenjiscombatforms.network.voidform.ability3.SyncVoidData3Packet;
import net.kenji.kenjiscombatforms.network.voidform.ability3.ToggleEnderPacket;
import net.minecraft.ChatFormatting;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.scores.PlayerTeam;
import net.minecraft.world.scores.Scoreboard;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.util.thread.EffectiveSide;
import net.minecraftforge.network.PacketDistributor;
import reascer.wom.gameasset.WOMSkills;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.skill.SkillSlot;
import yesman.epicfight.skill.SkillSlots;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;

public class EnderFormAbility
implements Ability {
    private final EnderPlayerDataSets dataSets = EnderPlayerDataSets.getInstance();
    private final Map<UUID, EnderPlayerDataSets.EnderFormPlayerData> playerDataMap;
    private final CommonFunctions dataHandlers;
    private Entity enderEntity;
    public String teamName;
    private static final EnderFormAbility INSTANCE = new EnderFormAbility();
    Skill currentDodgeSkill;

    private EnderPlayerDataSets.TeleportPlayerData getOrCreateTeleportPlayerData(Player player) {
        return this.dataSets.getOrCreateTeleportPlayerData(player);
    }

    private EnderPlayerDataSets.VoidRiftPlayerData getOrCreateVoidRiftPlayerData(Player player) {
        return this.dataSets.getOrCreateVoidRiftPlayerData(player);
    }

    public EnderPlayerDataSets.EnderFormPlayerData getPlayerData(Player player) {
        return (EnderPlayerDataSets.EnderFormPlayerData)this.getAbilityData(player);
    }

    @Override
    public String getName() {
        return AbilityManager.AbilityOption3.VOID_FINAL.name();
    }

    public EnderFormAbility() {
        this.playerDataMap = this.dataSets.A3playerDataMap;
        this.dataHandlers = CommonFunctions.getInstance();
        this.teamName = "enderEntityTeam";
    }

    public static EnderFormAbility getInstance() {
        return INSTANCE;
    }

    public int getAbilityCooldown(ServerPlayer player) {
        return this.getPlayerData((Player)player).abilityCooldown;
    }

    public void setAbilityCooldown(ServerPlayer player, int cooldown) {
        this.getPlayerData((Player)player).abilityCooldown = Math.min(Math.max(cooldown, 0), this.getPlayerData((Player)player).getMAX_COOLDOWN());
    }

    @Override
    public AbstractAbilityData getAbilityData(Player player) {
        return this.dataSets.getOrCreateEnderFormPlayerData(player);
    }

    @Override
    public void fillPerSecondCooldown(Player player) {
        EnderPlayerDataSets.EnderFormPlayerData data = this.getPlayerData(player);
        if (data.abilityCooldown > 0) {
            data.tickCount = this.dataHandlers.getTickCount(data.tickCount);
            data.abilityCooldown = this.dataHandlers.decreaseCooldown(data.abilityCooldown, data.tickCount);
        }
    }

    @Override
    public void drainPerSecondCooldown(Player player) {
        EnderPlayerDataSets.EnderFormPlayerData data = this.getPlayerData(player);
        data.tickCount = this.dataHandlers.getTickCount(data.tickCount);
        data.abilityCooldown = this.dataHandlers.increaseCooldown(data.abilityCooldown, data.tickCount);
    }

    @Override
    public boolean getAbilityActive(Player player) {
        return this.getAbilityData(player).isAbilityActive();
    }

    @Override
    public void sendPacketToServer(Player player) {
        NetworkHandler.INSTANCE.sendToServer((Object)new ToggleEnderPacket());
        if (!this.getAbilityActive(player)) {
            EnderFormAbility.getInstance().jumpUp(player);
        }
    }

    public void jumpUp(Player player) {
        EnderPlayerDataSets.EnderFormPlayerData data = this.getPlayerData(player);
        if (ClientVoidData.getCooldown3() == 0) {
            Vec3 velocity = player.m_20184_();
            player.m_20334_(velocity.f_82479_, 0.5, velocity.f_82481_);
        }
    }

    private void setCurrentDodgeSkill(PlayerPatch<?> playerPatch, Skill skill, CompoundTag nbt) {
        this.currentDodgeSkill = skill;
        if (this.getSkill(playerPatch) != null) {
            nbt.m_128359_("storedDodgeSkill", Objects.requireNonNull(this.getSkill(playerPatch)).getRegistryName().toString());
        }
    }

    private Skill getCurrentDodgeSkill() {
        return this.currentDodgeSkill;
    }

    @Override
    public void triggerAbility(ServerPlayer serverPlayer) {
        EnderPlayerDataSets.EnderFormPlayerData data = this.getPlayerData((Player)serverPlayer);
        serverPlayer.getCapability(EpicFightCapabilities.CAPABILITY_ENTITY).ifPresent(cap -> {
            if (cap instanceof PlayerPatch) {
                PlayerPatch playerPatch = (PlayerPatch)cap;
                Skill skillToSet = WOMSkills.ENDERSTEP;
                CompoundTag nbt = serverPlayer.getPersistentData();
                if (!data.isEnderActive && data.abilityCooldown == 0) {
                    this.setCurrentDodgeSkill(playerPatch, this.getSkill(playerPatch), nbt);
                    this.activateAbility(serverPlayer);
                    this.jumpUp((Player)serverPlayer);
                    this.setSkill(playerPatch, skillToSet);
                    data.hasPlayedSound = false;
                } else {
                    this.deactivateAbilityOptional(serverPlayer);
                    this.restoreItem((Player)serverPlayer);
                    this.setSkill(playerPatch, this.getCurrentDodgeSkill());
                    nbt.m_128473_("storedDodgeSkill");
                }
            }
        });
    }

    private void setSkill(PlayerPatch playerPatch, Skill skillToSet) {
        playerPatch.getSkill((SkillSlot)SkillSlots.DODGE).setSkill(skillToSet);
    }

    private Skill getSkill(PlayerPatch<?> playerPatch) {
        if (playerPatch.getSkill((SkillSlot)SkillSlots.DODGE) != null) {
            return playerPatch.getSkill((SkillSlot)SkillSlots.DODGE).getSkill();
        }
        return null;
    }

    @Override
    public void activateAbility(ServerPlayer serverPlayer) {
        EnderPlayerDataSets.EnderFormPlayerData data = this.getPlayerData((Player)serverPlayer);
        AbilityManager.PlayerAbilityData abilityData = AbilityManager.getInstance().getPlayerAbilityData((Player)serverPlayer);
        this.setFormItem((Player)serverPlayer);
        data.isEnderActive = true;
        abilityData.ability4 = AbilityManager.AbilityOption4.ENDER_LEVITATION;
        abilityData.ability5 = AbilityManager.AbilityOption5.VOID_GRAB;
        this.playSound((Player)serverPlayer);
        this.syncDataToClient(serverPlayer);
    }

    private void setFormItem(Player player) {
        int originalSlot = CommonEventHandler.getInstance().getOriginalSlot(player);
        int selectedSlot = player.m_150109_().f_35977_;
        ItemStack currentItem = player.m_150109_().m_8020_(selectedSlot);
        player.getCapability(ExtraContainerCapability.EXTRA_CONTAINER_CAP).ifPresent(container -> {
            ItemStack storedItem = container.getStoredItem();
            if (storedItem.m_41619_()) {
                if (!(currentItem.m_41720_() instanceof BaseFistClass)) {
                    CommonEventHandler.getInstance().setStoredItemNBT(player, currentItem);
                    container.setStoredItem(currentItem);
                }
                player.m_150109_().m_6836_(selectedSlot, ItemStack.f_41583_);
                player.m_150109_().m_6836_(selectedSlot, EnderFormItem.getInstance().m_7968_());
                CommonEventHandler.getInstance().setOriginalSlot(player, selectedSlot);
                container.setOriginalSlot(selectedSlot);
                NetworkHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)player), (Object)new SyncNBTPacket(storedItem, originalSlot));
                player.m_150109_().m_6596_();
                player.m_5496_(SoundEvents.f_12317_, 1.0f, 1.0f);
            }
        });
    }

    private void restoreItem(Player player) {
        int selectedSlot = player.m_150109_().f_35977_;
        ItemStack currentItem = player.m_150109_().m_8020_(selectedSlot);
        player.getCapability(ExtraContainerCapability.EXTRA_CONTAINER_CAP).ifPresent(container -> {
            ItemStack storedItem = container.getStoredItem();
            if (!storedItem.m_41619_()) {
                player.m_150109_().m_6836_(CommonEventHandler.getInstance().getOriginalSlot(player), container.getStoredItem());
                container.setStoredItem(ItemStack.f_41583_);
            } else {
                player.m_150109_().m_6836_(CommonEventHandler.getInstance().getOriginalSlot(player), ItemStack.f_41583_);
            }
            NetworkHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)player), (Object)new SyncRemovedNBTPacket(storedItem, CommonEventHandler.getInstance().getOriginalSlot(player)));
            container.setOriginalSlot(-1);
            player.m_5496_(SoundEvents.f_12317_, 1.0f, 1.0f);
        });
    }

    public boolean getEnderFormActive(Player player) {
        EnderPlayerDataSets.EnderFormPlayerData data = this.getPlayerData(player);
        return data.isEnderActive;
    }

    void addEnderEntityToTeam(Player currentPlayer, EnderEntity enderEntity) {
        Scoreboard scoreboard = currentPlayer.m_9236_().m_6188_();
        UUID playerUUID = currentPlayer.m_20148_();
        PlayerTeam team = scoreboard.m_83489_(this.teamName);
        if (team == null) {
            team = scoreboard.m_83492_(this.teamName);
            team.m_83351_(ChatFormatting.DARK_PURPLE);
            team.m_83355_(false);
        }
        if (currentPlayer.m_5647_() != scoreboard.m_83489_(this.teamName)) {
            enderEntity.m_30586_(playerUUID);
            scoreboard.m_6546_(playerUUID.toString(), team);
            scoreboard.m_6546_(enderEntity.m_20148_().toString(), team);
            System.out.println("Is adding enderEntity To Team");
        }
    }

    @Override
    public void deactivateAbilityOptional(ServerPlayer serverPlayer) {
        EnderPlayerDataSets.EnderFormPlayerData data = this.getPlayerData((Player)serverPlayer);
        data.isEnderActive = false;
        serverPlayer.m_150110_().f_35935_ = false;
        serverPlayer.m_150110_().f_35936_ = false;
        this.syncDataToClient(serverPlayer);
    }

    @Override
    public void decrementCooldown(Player player) {
        EnderPlayerDataSets.EnderFormPlayerData data = this.getPlayerData(player);
        AbilityManager.PlayerAbilityData abilityData = AbilityManager.getInstance().getPlayerAbilityData(player);
        if (this.isAbilityChosenOrEquipped(player) && EffectiveSide.get() == LogicalSide.SERVER && player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (!((Boolean)EpicFightCombatFormsCommon.ABILITY3_COMBAT_MODE.get()).booleanValue() && data.abilityCooldown > 0 && !data.isEnderActive) {
                this.fillPerSecondCooldown(player);
            }
            if (data.abilityCooldown < data.getMAX_COOLDOWN() && data.isEnderActive) {
                this.drainPerSecondCooldown(player);
            }
            if (data.abilityCooldown >= data.getMAX_COOLDOWN() && data.isEnderActive) {
                this.deactivateAbilityOptional(serverPlayer);
                Entity existingShadow = data.playerEnderMap.remove(player.m_20148_());
                if (existingShadow != null) {
                    existingShadow.m_142687_(Entity.RemovalReason.DISCARDED);
                }
                if (!data.hasPlayedSound) {
                    data.hasPlayedSound = true;
                    this.playSound(player);
                }
            }
        }
    }

    @Override
    public void tickServerAbilityData(ServerPlayer player) {
        EnderPlayerDataSets.EnderFormPlayerData data = this.getPlayerData((Player)player);
        AbilityManager.PlayerAbilityData abilityData = AbilityManager.getInstance().getPlayerAbilityData((Player)player);
        if (abilityData.chosenFinal.name().equals(this.getName())) {
            EnderFormAbility.getInstance().decrementCooldown((Player)player);
            this.syncDataToClient(player);
            if (data.isEnderActive || ClientVoidData.getIsEnderActive()) {
                player.m_150110_().f_35936_ = true;
                player.m_150110_().f_35935_ = true;
                player.m_150110_().m_35943_(0.05f);
                this.syncDataToClient(player);
                NetworkHandler.INSTANCE.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> player), (Object)new EndParticlesTickPacket(player.m_20185_(), player.m_20186_(), player.m_20189_(), player.m_20145_()));
            } else if (!player.f_8941_.m_9295_()) {
                player.m_150110_().f_35936_ = false;
                player.m_150110_().f_35935_ = false;
            }
        }
    }

    @Override
    public void tickClientAbilityData(Player player) {
        EnderPlayerDataSets.EnderFormPlayerData data = EnderFormAbility.getInstance().playerDataMap.computeIfAbsent(player.m_20148_(), k -> new EnderPlayerDataSets.EnderFormPlayerData());
        AbilityManager.PlayerAbilityData abilityData = AbilityManager.getInstance().getPlayerAbilityData(player);
        if (ClientFistData.getChosenAbility3().name().equals(this.getName())) {
            EnderFormAbility.getInstance().decrementCooldown(player);
            if (ClientVoidData.getIsEnderActive() || data.isEnderActive) {
                player.m_150110_().f_35936_ = true;
                player.m_150110_().f_35935_ = true;
            } else if (!player.m_7500_()) {
                player.m_150110_().f_35936_ = false;
                player.m_150110_().f_35935_ = false;
            }
        }
    }

    @Override
    public void syncDataToClient(ServerPlayer player) {
        EnderPlayerDataSets.EnderFormPlayerData data = this.getPlayerData((Player)player);
        AbilityManager.PlayerAbilityData abilityData = AbilityManager.getInstance().getPlayerAbilityData((Player)player);
        NetworkHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> player), (Object)new SyncVoidData3Packet(data.abilityCooldown, data.isEnderActive));
        NetworkHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> player), (Object)new SyncClientFinalAbilitesPacket(abilityData.ability4, abilityData.ability5));
    }

    public boolean isAbilityChosenOrEquipped(Player player) {
        AbilityManager.PlayerAbilityData abilityData = AbilityManager.getInstance().getPlayerAbilityData(player);
        return abilityData.chosenFinal.name().equals(this.getName());
    }

    private Entity getNearestEntity(Player player) {
        double searchRadius = 10.0;
        AABB searchBox = player.m_20191_().m_82400_(searchRadius);
        List nearbyEntities = player.m_9236_().m_45933_((Entity)player, searchBox);
        Entity closestEntity = null;
        double closestDistanceSq = Double.MAX_VALUE;
        for (Entity entity : nearbyEntities) {
            double distanceSq;
            if (entity instanceof EnderEntity || !((distanceSq = player.m_20280_(entity)) < closestDistanceSq)) continue;
            closestDistanceSq = distanceSq;
            closestEntity = entity;
        }
        return closestEntity;
    }

    @Override
    public void playSound(Player player) {
        player.m_9236_().m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11850_, SoundSource.PLAYERS, 1.0f, 1.0f);
    }

    @Override
    public void playSound2(Player player) {
    }

    @OnlyIn(value=Dist.CLIENT)
    public void spawnParticles(Player player) {
        int currentVoidCooldown = ClientVoidData.getCooldown3();
        BlockParticleOption whiteFallingDust = new BlockParticleOption(ParticleTypes.f_123814_, Blocks.f_50041_.m_49966_());
        Random random = new Random();
        int particleCount = 100;
        double x = player.m_20185_();
        double y = player.m_20186_();
        double z = player.m_20189_();
        for (int i = 0; i < particleCount; ++i) {
            double offsetX = (random.nextDouble() - 0.5) * 2.0;
            double offsetY = (random.nextDouble() - 0.5) * 2.0;
            double offsetZ = (random.nextDouble() - 0.5) * 2.0;
            double velocityX = (random.nextDouble() - 0.5) * 0.5;
            double velocityY = random.nextDouble() * 0.5;
            double velocityZ = (random.nextDouble() - 0.5) * 0.5;
            player.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123760_, x + offsetX, y + 1.0 + offsetY, z + offsetZ, velocityX, velocityY, velocityZ);
        }
    }

    public static class CurrentDamageGainStrategy
    implements AbilityDamageGainStrategy {
        @Override
        public void fillDamageCooldown(Player player) {
            EnderPlayerDataSets.EnderFormPlayerData data = EnderFormAbility.getInstance().getPlayerData(player);
            if (((Boolean)EpicFightCombatFormsCommon.ABILITY3_COMBAT_MODE.get()).booleanValue()) {
                if (!data.isAbilityActive()) {
                    if (data.abilityCooldown > 0) {
                        data.abilityCooldown -= ((Integer)EpicFightCombatFormsCommon.COMBAT_MODE_GAIN_AMOUNT.get()).intValue();
                    }
                } else if (data.abilityCooldown > 0) {
                    data.abilityCooldown -= (Integer)EpicFightCombatFormsCommon.COMBAT_MODE_GAIN_AMOUNT.get() / 2;
                }
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    EnderFormAbility.getInstance().syncDataToClient(serverPlayer);
                }
            }
        }
    }

    @Mod.EventBusSubscriber(modid="kenjiscombatforms", bus=Mod.EventBusSubscriber.Bus.FORGE)
    public static class ServerForgeEvents {
        @SubscribeEvent
        public static void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent event) {
            Player player = event.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                EnderFormAbility.getInstance().getPlayerData((Player)serverPlayer);
                EnderFormAbility.getInstance().syncDataToClient(serverPlayer);
                EnderFormAbility.getInstance().deactivateAbilityOptional(serverPlayer);
            }
        }

        @SubscribeEvent
        public static void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
            Player player;
            Entity existingDecoy = EnderFormAbility.getInstance().getPlayerData((Player)event.getEntity()).playerEnderMap.remove(event.getEntity().m_20148_());
            if (existingDecoy != null) {
                existingDecoy.m_142687_(Entity.RemovalReason.DISCARDED);
            }
            if ((player = event.getEntity()) instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                EnderFormAbility.getInstance().setAbilityCooldown(serverPlayer, EnderFormAbility.getInstance().getPlayerData((Player)serverPlayer).getMAX_COOLDOWN());
                EnderFormAbility.getInstance().syncDataToClient(serverPlayer);
            }
        }

        @SubscribeEvent
        public static void onPlayerLogout(PlayerEvent.PlayerLoggedOutEvent event) {
            Entity existingDecoy = EnderFormAbility.getInstance().getPlayerData((Player)event.getEntity()).playerEnderMap.remove(event.getEntity().m_20148_());
            if (existingDecoy != null) {
                existingDecoy.m_142687_(Entity.RemovalReason.DISCARDED);
            }
            EnderFormAbility.getInstance().playerDataMap.remove(event.getEntity().m_20148_());
        }

        @SubscribeEvent
        public static void onPlayerClone(PlayerEvent.Clone event) {
            Player player = event.getOriginal();
            if (player instanceof ServerPlayer) {
                ServerPlayer originalPlayer = (ServerPlayer)player;
                player = event.getEntity();
                if (player instanceof ServerPlayer) {
                    ServerPlayer newPlayer = (ServerPlayer)player;
                    EnderPlayerDataSets.EnderFormPlayerData originalData = EnderFormAbility.getInstance().getPlayerData((Player)originalPlayer);
                    EnderPlayerDataSets.EnderFormPlayerData newData = EnderFormAbility.getInstance().getPlayerData((Player)newPlayer);
                    newData.abilityCooldown = originalData.abilityCooldown;
                    EnderFormAbility.getInstance().syncDataToClient(newPlayer);
                }
            }
        }

        @SubscribeEvent
        public static void onPlayerDeath(LivingDeathEvent event) {
            LivingEntity livingEntity = event.getEntity();
            if (livingEntity instanceof Player) {
                Player player = (Player)livingEntity;
                player.getCapability(EpicFightCapabilities.CAPABILITY_ENTITY).ifPresent(cap -> {
                    if (cap instanceof PlayerPatch) {
                        PlayerPatch playerPatch = (PlayerPatch)cap;
                        EnderFormAbility.getInstance().setSkill(playerPatch, EnderFormAbility.getInstance().getCurrentDodgeSkill());
                    }
                });
            }
        }

        @SubscribeEvent
        public static void onPlayerLeave(PlayerEvent.PlayerLoggedOutEvent event) {
            Player player = event.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer player2 = (ServerPlayer)player;
                EnderPlayerDataSets.EnderFormPlayerData data = EnderFormAbility.getInstance().getPlayerData((Player)player2);
                player2.getCapability(EpicFightCapabilities.CAPABILITY_ENTITY).ifPresent(cap -> {
                    if (cap instanceof PlayerPatch) {
                        PlayerPatch playerPatch = (PlayerPatch)cap;
                        if (data.isEnderActive) {
                            EnderFormAbility.getInstance().setSkill(playerPatch, EnderFormAbility.getInstance().getCurrentDodgeSkill());
                        }
                    }
                });
            }
        }
    }
}

