/*
 * Decompiled with CFR 0.152.
 */
package net.kenji.kenjiscombatforms.api.powers.VoidPowers;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.kenji.kenjiscombatforms.api.handlers.power_data.EnderPlayerDataSets;
import net.kenji.kenjiscombatforms.api.interfaces.ability.AbstractAbilityData;
import net.kenji.kenjiscombatforms.api.interfaces.ability.FinalAbility;
import net.kenji.kenjiscombatforms.api.managers.AbilityManager;
import net.kenji.kenjiscombatforms.event.CommonFunctions;
import net.kenji.kenjiscombatforms.network.NetworkHandler;
import net.kenji.kenjiscombatforms.network.voidform.ender_abilities.ability4.EnderLevitationPacket;
import net.kenji.kenjiscombatforms.network.voidform.ender_abilities.ability4.SyncVoidData4Packet;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.PacketDistributor;

public class EnderLevitation
implements FinalAbility {
    EnderPlayerDataSets dataSets = EnderPlayerDataSets.getInstance();
    private final Map<UUID, EnderPlayerDataSets.EnderLevitationPlayerData> playerDataMap;
    private final CommonFunctions dataHandlers;
    private static final EnderLevitation INSTANCE = new EnderLevitation();

    @Override
    public String getName() {
        return AbilityManager.AbilityOption4.ENDER_LEVITATION.name();
    }

    @Override
    public String getFinalAbilityName() {
        return AbilityManager.AbilityOption3.VOID_FINAL.name();
    }

    private EnderPlayerDataSets.EnderLevitationPlayerData getPlayerData(Player player) {
        return (EnderPlayerDataSets.EnderLevitationPlayerData)this.getAbilityData(player);
    }

    private EnderPlayerDataSets.EnderFormPlayerData getOrCreateEnderFormPlayerData(Player player) {
        return this.dataSets.getOrCreateEnderFormPlayerData(player);
    }

    public EnderLevitation() {
        this.playerDataMap = this.dataSets.A4playerDataMap;
        this.dataHandlers = CommonFunctions.getInstance();
    }

    public static EnderLevitation getInstance() {
        return INSTANCE;
    }

    public int getAbilityCooldown(ServerPlayer player) {
        return this.getPlayerData((Player)player).abilityCooldown;
    }

    public void setAbilityCooldown(ServerPlayer player, int cooldown) {
        this.getPlayerData((Player)player).abilityCooldown = Math.min(Math.max(cooldown, 0), this.getPlayerData((Player)player).getMAX_COOLDOWN());
    }

    @Override
    public AbstractAbilityData getAbilityData(Player player) {
        return this.dataSets.getOrCreateEnderLevitationPlayerData(player);
    }

    @Override
    public boolean getFinalAbilityActive(Player player) {
        return AbilityManager.getInstance().getAbility(this.getFinalAbilityName()).getAbilityData(player).isAbilityActive();
    }

    @Override
    public boolean getAbilityActive(Player player) {
        return this.getAbilityData(player).isAbilityActive();
    }

    @Override
    public void fillPerSecondCooldown(Player player) {
        EnderPlayerDataSets.EnderLevitationPlayerData data = this.getPlayerData(player);
        int cooldown = data.abilityCooldown;
        if (cooldown > 0) {
            data.tickCount = this.dataHandlers.getTickCount(data.tickCount);
            data.abilityCooldown = this.dataHandlers.decreaseCooldown(data.abilityCooldown, data.tickCount);
        }
    }

    @Override
    public void drainPerSecondCooldown(Player player) {
        EnderPlayerDataSets.EnderLevitationPlayerData data = this.getPlayerData(player);
        data.tickCount = this.dataHandlers.getTickCount(data.tickCount);
        data.abilityCooldown = this.dataHandlers.increaseCooldown(data.abilityCooldown, data.tickCount);
    }

    @Override
    public void sendPacketToServer(Player player) {
        NetworkHandler.INSTANCE.sendToServer((Object)new EnderLevitationPacket());
    }

    @Override
    public void triggerAbility(ServerPlayer serverPlayer) {
        EnderPlayerDataSets.EnderLevitationPlayerData data = this.getPlayerData((Player)serverPlayer);
        EnderPlayerDataSets.EnderFormPlayerData bData = this.dataSets.getOrCreateEnderFormPlayerData((Player)serverPlayer);
        long currentTime = System.currentTimeMillis();
        if (data.abilityCooldown <= 0) {
            this.activateAbility(serverPlayer);
        } else {
            this.deactivateAbilityOptional(serverPlayer);
        }
    }

    @Override
    public void activateAbility(ServerPlayer serverPlayer) {
        EnderPlayerDataSets.EnderLevitationPlayerData data = this.getPlayerData((Player)serverPlayer);
        data.isActive = true;
        this.playSound((Player)serverPlayer);
    }

    @Override
    public void deactivateAbilityOptional(ServerPlayer serverPlayer) {
        EnderPlayerDataSets.EnderLevitationPlayerData data = this.getPlayerData((Player)serverPlayer);
        data.isActive = false;
    }

    @Override
    public void decrementCooldown(Player player) {
        EnderPlayerDataSets.EnderLevitationPlayerData data = this.getPlayerData(player);
        EnderPlayerDataSets.EnderFormPlayerData bData = this.dataSets.getOrCreateEnderFormPlayerData(player);
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (!data.isActive && bData.isAbilityActive()) {
                this.fillPerSecondCooldown(player);
                this.fillPerSecondCooldown(player);
            } else if (data.isActive) {
                this.drainPerSecondCooldown(player);
            } else if (data.abilityCooldown >= data.getMAX_COOLDOWN() && data.isActive) {
                this.deactivateAbilityOptional(serverPlayer);
            }
        }
    }

    @Override
    public void tickServerAbilityData(ServerPlayer player) {
        EnderLevitation.getInstance().decrementCooldown((Player)player);
        this.syncDataToClient(player);
        this.handlerNearbyEntities(player);
    }

    @Override
    public void tickClientAbilityData(Player player) {
    }

    @Override
    public void syncDataToClient(ServerPlayer player) {
        EnderPlayerDataSets.EnderLevitationPlayerData data = this.getPlayerData((Player)player);
        if (this.getFinalAbilityActive((Player)player)) {
            NetworkHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> player), (Object)new SyncVoidData4Packet(data.abilityCooldown));
        }
    }

    private void handlerNearbyEntities(ServerPlayer player) {
        EnderPlayerDataSets.EnderLevitationPlayerData data = this.getPlayerData((Player)player);
        EnderPlayerDataSets.EnderFormPlayerData eData = EnderLevitation.getInstance().getOrCreateEnderFormPlayerData((Player)player);
        if (eData.isEnderActive) {
            double radius = 10.0;
            AABB searchArea = new AABB(player.m_20097_()).m_82400_(radius);
            if (data.isActive) {
                Iterator<Map.Entry<UUID, EnderPlayerDataSets.EnderLevitationPlayerData.EntityState>> it = data.affectedEntities.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry<UUID, EnderPlayerDataSets.EnderLevitationPlayerData.EntityState> entry = it.next();
                    UUID entityId = entry.getKey();
                    EnderPlayerDataSets.EnderLevitationPlayerData.EntityState state = entry.getValue();
                    LivingEntity entity = (LivingEntity)player.m_284548_().m_8791_(entityId);
                    if (entity == null || !searchArea.m_82390_(entity.m_20182_())) {
                        if (entity != null) {
                            entity.m_20242_(false);
                        }
                        it.remove();
                        continue;
                    }
                    if (state.levitationTicks < 30) {
                        entity.m_7292_(new MobEffectInstance(MobEffects.f_19620_, 2, 0, false, false));
                        ++state.levitationTicks;
                        continue;
                    }
                    entity.m_20242_(true);
                }
                TargetingConditions targetingConditions = TargetingConditions.m_148352_();
                List nearbyEntities = player.m_9236_().m_45971_(LivingEntity.class, targetingConditions, (LivingEntity)player, searchArea);
                for (LivingEntity entity : nearbyEntities) {
                    if (data.affectedEntities.containsKey(entity.m_20148_())) continue;
                    data.affectedEntities.put(entity.m_20148_(), new EnderPlayerDataSets.EnderLevitationPlayerData.EntityState());
                }
            } else {
                for (UUID entityId : data.affectedEntities.keySet()) {
                    LivingEntity entity = (LivingEntity)player.m_284548_().m_8791_(entityId);
                    if (entity == null) continue;
                    entity.m_20242_(false);
                }
                data.affectedEntities.clear();
            }
        }
    }

    @Override
    public void playSound(Player player) {
        player.m_9236_().m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12554_, SoundSource.PLAYERS, 1.0f, 1.0f);
    }

    @Override
    public void playSound2(Player player) {
        player.m_9236_().m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12052_, SoundSource.PLAYERS, 1.0f, 1.0f);
    }

    @Mod.EventBusSubscriber(modid="kenjiscombatforms", bus=Mod.EventBusSubscriber.Bus.FORGE)
    public static class ServerForgeEvents {
        @SubscribeEvent
        public static void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent event) {
            Player player = event.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                EnderLevitation.getInstance().getPlayerData((Player)serverPlayer);
                EnderLevitation.getInstance().syncDataToClient(serverPlayer);
            }
        }

        @SubscribeEvent
        public static void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
            Player player = event.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                EnderLevitation.getInstance().setAbilityCooldown(serverPlayer, EnderLevitation.getInstance().getPlayerData((Player)serverPlayer).getMAX_COOLDOWN());
                EnderLevitation.getInstance().syncDataToClient(serverPlayer);
            }
        }

        @SubscribeEvent
        public static void onPlayerDeath(LivingDeathEvent event) {
            LivingEntity livingEntity = event.getEntity();
            if (livingEntity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)livingEntity;
            }
        }

        @SubscribeEvent
        public static void onPlayerLogout(PlayerEvent.PlayerLoggedOutEvent event) {
            Player player = event.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
            }
            EnderLevitation.getInstance().playerDataMap.remove(event.getEntity().m_20148_());
        }

        @SubscribeEvent
        public static void onPlayerClone(PlayerEvent.Clone event) {
            Player player = event.getOriginal();
            if (player instanceof ServerPlayer) {
                ServerPlayer originalPlayer = (ServerPlayer)player;
                player = event.getEntity();
                if (player instanceof ServerPlayer) {
                    ServerPlayer newPlayer = (ServerPlayer)player;
                    EnderPlayerDataSets.EnderLevitationPlayerData originalData = EnderLevitation.getInstance().getPlayerData((Player)originalPlayer);
                    EnderPlayerDataSets.EnderLevitationPlayerData newData = EnderLevitation.getInstance().getPlayerData((Player)newPlayer);
                    EnderLevitation.getInstance().syncDataToClient(newPlayer);
                }
            }
        }
    }
}

