/*
 * Decompiled with CFR 0.152.
 */
package net.kenji.kenjiscombatforms.api.powers.VoidPowers;

import java.util.Map;
import java.util.UUID;
import net.kenji.kenjiscombatforms.api.handlers.power_data.EnderPlayerDataSets;
import net.kenji.kenjiscombatforms.api.interfaces.ability.AbstractAbilityData;
import net.kenji.kenjiscombatforms.api.interfaces.ability.FinalAbility;
import net.kenji.kenjiscombatforms.api.managers.AbilityManager;
import net.kenji.kenjiscombatforms.event.CommonFunctions;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;

public class EnderWarpAbility
implements FinalAbility {
    private final EnderPlayerDataSets dataSets = EnderPlayerDataSets.getInstance();
    private final Map<UUID, EnderPlayerDataSets.TeleportPlayerData> playerDataMap;
    private static final EnderWarpAbility INSTANCE = new EnderWarpAbility();
    private final CommonFunctions dataHandlers;
    ServerPlayer serverPlayer;

    @Override
    public String getName() {
        return AbilityManager.AltAbilityOption.ENDER_WARP.name();
    }

    @Override
    public String getFinalAbilityName() {
        return AbilityManager.AbilityOption3.VOID_FINAL.name();
    }

    public EnderPlayerDataSets.EnderWarpPlayerData getPlayerData(Player player) {
        return (EnderPlayerDataSets.EnderWarpPlayerData)this.getAbilityData(player);
    }

    public EnderPlayerDataSets.EnderFormPlayerData getOrCreateEnderFormPlayerData(Player player) {
        return this.dataSets.getOrCreateEnderFormPlayerData(player);
    }

    public EnderWarpAbility() {
        this.playerDataMap = this.dataSets.A1playerDataMap;
        this.dataHandlers = CommonFunctions.getInstance();
    }

    public static EnderWarpAbility getInstance() {
        return INSTANCE;
    }

    public float getAbilityCooldown(Player player) {
        return this.getPlayerData((Player)player).abilityCooldown;
    }

    public void setAbilityCooldown(Player player) {
        this.getPlayerData((Player)player).abilityCooldown += this.getPlayerData(player).getMAX_COOLDOWN() / 2;
    }

    @Override
    public AbstractAbilityData getAbilityData(Player player) {
        return this.dataSets.getOrCreateEnderWarpPlayerData(player);
    }

    @Override
    public boolean getFinalAbilityActive(Player player) {
        return false;
    }

    @Override
    public boolean getAbilityActive(Player player) {
        return this.getAbilityData(player).isAbilityActive();
    }

    @Override
    public void fillPerSecondCooldown(Player player) {
        EnderPlayerDataSets.EnderWarpPlayerData data = this.getPlayerData(player);
        int cooldown = data.abilityCooldown;
        if (cooldown > 0) {
            data.tickCount = this.dataHandlers.getTickCount(data.tickCount);
            data.abilityCooldown = this.dataHandlers.decreaseCooldown(data.abilityCooldown, data.tickCount);
        }
    }

    @Override
    public void drainPerSecondCooldown(Player player) {
    }

    @Override
    public void sendPacketToServer(Player player) {
    }

    @Override
    public void triggerAbility(ServerPlayer serverPlayer) {
        long currentTime = System.currentTimeMillis();
        serverPlayer.getCapability(EpicFightCapabilities.CAPABILITY_ENTITY).ifPresent(cap -> {
            PlayerPatch playerPatch;
            if (!(cap instanceof PlayerPatch) || !((playerPatch = (PlayerPatch)cap).getStamina() >= playerPatch.getMaxStamina()) || this.getPlayerData((Player)serverPlayer).abilityCooldown <= this.getPlayerData((Player)serverPlayer).getMAX_COOLDOWN()) {
                // empty if block
            }
        });
    }

    @Override
    public void activateAbility(ServerPlayer serverPlayer) {
        EnderPlayerDataSets.EnderWarpPlayerData data = this.getPlayerData((Player)serverPlayer);
        EnderPlayerDataSets.EnderFormPlayerData eData = this.getOrCreateEnderFormPlayerData((Player)serverPlayer);
        int maxDistance = 8;
        Vec3 eyePos = serverPlayer.m_146892_();
        Vec3 getViewVec = serverPlayer.m_20252_(1.0f);
        Vec3 endVec = eyePos.m_82549_(getViewVec.m_82490_((double)maxDistance));
        serverPlayer.m_6021_(endVec.f_82479_, endVec.f_82480_, endVec.f_82481_);
    }

    @Override
    public void deactivateAbilityOptional(ServerPlayer serverPlayer) {
    }

    @Override
    public void decrementCooldown(Player player) {
        EnderPlayerDataSets.EnderFormPlayerData wData = this.dataSets.getOrCreateEnderFormPlayerData(player);
        EnderPlayerDataSets.EnderWarpPlayerData eData = this.getPlayerData(player);
        if (wData.isEnderActive && eData.abilityCooldown <= eData.getMAX_COOLDOWN()) {
            this.fillPerSecondCooldown(player);
        }
    }

    @Override
    public void tickServerAbilityData(ServerPlayer player) {
    }

    @Override
    public void tickClientAbilityData(Player player) {
    }

    @Override
    public void syncDataToClient(ServerPlayer player) {
    }

    @Override
    public void playSound(Player player) {
        player.m_9236_().m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11852_, SoundSource.PLAYERS, 1.0f, 1.0f);
    }

    @Override
    public void playSound2(Player player) {
    }

    public void tickClientPlayer(Player player) {
        EnderPlayerDataSets.EnderWarpPlayerData data = this.getPlayerData(player);
        EnderWarpAbility.getInstance().decrementCooldown(player);
    }

    @Mod.EventBusSubscriber(modid="kenjiscombatforms", bus=Mod.EventBusSubscriber.Bus.FORGE)
    public static class ServerForgeEvents {
        @SubscribeEvent
        public static void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent event) {
            Player player = event.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                EnderWarpAbility.getInstance().getPlayerData((Player)serverPlayer);
                EnderWarpAbility.getInstance().syncDataToClient(serverPlayer);
            }
        }

        @SubscribeEvent
        public static void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
            Player player = event.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                EnderWarpAbility.getInstance().setAbilityCooldown((Player)serverPlayer);
                EnderWarpAbility.getInstance().syncDataToClient(serverPlayer);
            }
        }

        @SubscribeEvent
        public static void onPlayerLogout(PlayerEvent.PlayerLoggedOutEvent event) {
            EnderWarpAbility.getInstance().playerDataMap.remove(event.getEntity().m_20148_());
        }

        @SubscribeEvent
        public static void onPlayerClone(PlayerEvent.Clone event) {
            Player player = event.getOriginal();
            if (player instanceof ServerPlayer) {
                ServerPlayer originalPlayer = (ServerPlayer)player;
                player = event.getEntity();
                if (player instanceof ServerPlayer) {
                    ServerPlayer newPlayer = (ServerPlayer)player;
                    EnderPlayerDataSets.EnderWarpPlayerData originalData = EnderWarpAbility.getInstance().getPlayerData((Player)originalPlayer);
                    EnderPlayerDataSets.EnderWarpPlayerData newData = EnderWarpAbility.getInstance().getPlayerData((Player)newPlayer);
                    newData.abilityCooldown = originalData.abilityCooldown;
                    EnderWarpAbility.getInstance().syncDataToClient(newPlayer);
                }
            }
        }
    }
}

