/*
 * Decompiled with CFR 0.152.
 */
package net.kenji.kenjiscombatforms.api.powers.VoidPowers;

import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import net.kenji.kenjiscombatforms.api.handlers.ClientEventHandler;
import net.kenji.kenjiscombatforms.api.handlers.power_data.EnderPlayerDataSets;
import net.kenji.kenjiscombatforms.api.interfaces.ability.Ability;
import net.kenji.kenjiscombatforms.api.interfaces.ability.AbstractAbilityData;
import net.kenji.kenjiscombatforms.api.managers.AbilityManager;
import net.kenji.kenjiscombatforms.config.EpicFightCombatFormsCommon;
import net.kenji.kenjiscombatforms.event.CommonFunctions;
import net.kenji.kenjiscombatforms.keybinds.ModKeybinds;
import net.kenji.kenjiscombatforms.network.NetworkHandler;
import net.kenji.kenjiscombatforms.network.voidform.ClientVoidData;
import net.kenji.kenjiscombatforms.network.voidform.ability1.SyncVoidDataPacket;
import net.kenji.kenjiscombatforms.network.voidform.ability1.TeleportPlayerPacket;
import net.kenji.kenjiscombatforms.network.voidform.ability2.TeleportPlayerBehindPacket;
import net.kenji.kenjiscombatforms.screen.guiEffects.BlinkEffect;
import net.minecraft.client.KeyMapping;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.PacketDistributor;

public class TeleportPlayer
implements Ability {
    private final EnderPlayerDataSets dataSets = EnderPlayerDataSets.getInstance();
    private final Map<UUID, EnderPlayerDataSets.TeleportPlayerData> playerDataMap;
    private static final TeleportPlayer INSTANCE = new TeleportPlayer();
    private final CommonFunctions dataHandlers;

    @Override
    public String getName() {
        return AbilityManager.AbilityOption1.VOID_ABILITY1.name();
    }

    public EnderPlayerDataSets.TeleportPlayerData getPlayerData(Player player) {
        return (EnderPlayerDataSets.TeleportPlayerData)this.getAbilityData(player);
    }

    public TeleportPlayer() {
        this.playerDataMap = this.dataSets.A1playerDataMap;
        this.dataHandlers = CommonFunctions.getInstance();
    }

    public static TeleportPlayer getInstance() {
        return INSTANCE;
    }

    public void setAbilityCooldown(Player player) {
        this.getPlayerData((Player)player).abilityCooldown += this.getPlayerData(player).getMAX_COOLDOWN() / (Integer)EpicFightCombatFormsCommon.ABILITY1_COOLDOWN_DIVISION.get();
    }

    @Override
    public AbstractAbilityData getAbilityData(Player player) {
        return this.dataSets.getOrCreateTeleportPlayerData(player);
    }

    @Override
    public void fillPerSecondCooldown(Player player) {
        EnderPlayerDataSets.TeleportPlayerData data = this.getPlayerData(player);
        int cooldown = data.abilityCooldown;
        if (cooldown > 0) {
            data.tickCount = this.dataHandlers.getTickCount(data.tickCount);
            data.abilityCooldown = this.dataHandlers.decreaseCooldown(data.abilityCooldown, data.tickCount);
        }
    }

    @Override
    public void drainPerSecondCooldown(Player player) {
    }

    @Override
    public boolean getAbilityActive(Player player) {
        return this.getAbilityData(player).isAbilityActive();
    }

    @Override
    public void sendPacketToServer(Player player) {
        EnderPlayerDataSets.TeleportPlayerData data = this.getPlayerData(player);
        if (!ClientEventHandler.getInstance().getAreFinalsActive() && ClientVoidData.getCooldown() <= EnderPlayerDataSets.getInstance().getOrCreateTeleportPlayerData(player).getMAX_COOLDOWN() / (Integer)EpicFightCombatFormsCommon.ABILITY1_COOLDOWN_DIVISION.get()) {
            if (data.tpPressCounter >= 0L) {
                --data.tpPressCounter;
            }
            NetworkHandler.INSTANCE.sendToServer((Object)new TeleportPlayerBehindPacket());
        }
    }

    @Override
    public void triggerAbility(ServerPlayer serverPlayer) {
        EnderPlayerDataSets.TeleportPlayerData data = this.getPlayerData((Player)serverPlayer);
        this.activateAbility(serverPlayer);
        this.setAbilityCooldown((Player)serverPlayer);
        this.playSound((Player)serverPlayer);
    }

    @Override
    public void activateAbility(ServerPlayer player) {
        EnderPlayerDataSets.TeleportPlayerData data = this.getPlayerData((Player)player);
        player.m_6021_((double)this.getLookingBlock((Player)player, data.maxDist).m_123341_(), (double)(this.getLookingBlock((Player)player, data.maxDist).m_123342_() + 1), (double)this.getLookingBlock((Player)player, data.maxDist).m_123343_());
    }

    @Override
    public void deactivateAbilityOptional(ServerPlayer serverPlayer) {
    }

    @Override
    public void decrementCooldown(Player player) {
        EnderPlayerDataSets.TeleportPlayerData data = this.playerDataMap.computeIfAbsent(player.m_20148_(), k -> new EnderPlayerDataSets.TeleportPlayerData());
        if (this.isAbilityChosenOrEquipped(player)) {
            this.fillPerSecondCooldown(player);
        }
    }

    @Override
    public void tickServerAbilityData(ServerPlayer player) {
        EnderPlayerDataSets.TeleportPlayerData data = this.getPlayerData((Player)player);
        AbilityManager.PlayerAbilityData abilityData = AbilityManager.getInstance().getPlayerAbilityData((Player)player);
        if (abilityData.chosenAbility1.name().equals(this.getName())) {
            TeleportPlayer.getInstance().decrementCooldown((Player)player);
            this.syncDataToClient(player);
        }
    }

    @Override
    public void tickClientAbilityData(Player player) {
        KeyMapping isAbilityKeyDown;
        EnderPlayerDataSets.TeleportPlayerData data = this.getPlayerData(player);
        boolean isAbilitySelectionMode = (Boolean)EpicFightCombatFormsCommon.ABILITY_SELECTION_MODE.get();
        KeyMapping keyMapping = isAbilityKeyDown = isAbilitySelectionMode ? ModKeybinds.ACTIVATE_CURRENT_ABILITY_KEY : ModKeybinds.ABILITY1_KEY;
        if (data.tpPressCounter <= 0L && !isAbilityKeyDown.m_90857_()) {
            NetworkHandler.INSTANCE.sendToServer((Object)new TeleportPlayerPacket());
            TeleportPlayer.getInstance().blink(player);
            Objects.requireNonNull(data);
            data.tpPressCounter = 90L;
            Objects.requireNonNull(data);
            data.pressCounter = 90L;
        }
    }

    @Override
    public void syncDataToClient(ServerPlayer player) {
        EnderPlayerDataSets.TeleportPlayerData data = this.getPlayerData((Player)player);
        if (this.isAbilityChosenOrEquipped((Player)player)) {
            NetworkHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> player), (Object)new SyncVoidDataPacket(data.abilityCooldown));
        }
    }

    public boolean isAbilityChosenOrEquipped(Player player) {
        AbilityManager.PlayerAbilityData abilityData = AbilityManager.getInstance().getPlayerAbilityData(player);
        return abilityData.chosenAbility1.name().equals(this.getName());
    }

    @Override
    public void playSound(Player player) {
        player.m_9236_().m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11852_, SoundSource.PLAYERS, 1.0f, 1.0f);
    }

    @Override
    public void playSound2(Player player) {
    }

    @OnlyIn(value=Dist.CLIENT)
    public void blink(Player player) {
        EnderPlayerDataSets.TeleportPlayerData data = this.getPlayerData(player);
        float currentVoidCooldown = ClientVoidData.getCooldown();
        if (currentVoidCooldown <= (float)(data.getMAX_COOLDOWN() / 2) && this.getLookingBlock(player, data.maxDist) != null) {
            BlinkEffect.triggerFade(player);
        }
    }

    public BlockPos getLookingBlock(Player player, int maxDistance) {
        maxDistance = this.getPlayerData((Player)player).maxDist;
        Vec3 eyePos = player.m_20299_(1.0f);
        Vec3 lookVec = player.m_20252_(1.0f);
        Vec3 endVec = eyePos.m_82520_(lookVec.f_82479_ * (double)maxDistance, lookVec.f_82480_ * (double)maxDistance, lookVec.f_82481_ * (double)maxDistance);
        ClipContext clipContext = new ClipContext(eyePos, endVec, ClipContext.Block.VISUAL, ClipContext.Fluid.NONE, (Entity)player);
        BlockHitResult hitResult = player.m_9236_().m_45547_(clipContext);
        if (hitResult.m_6662_() == HitResult.Type.BLOCK) {
            return hitResult.m_82425_();
        }
        return null;
    }

    @Mod.EventBusSubscriber(modid="kenjiscombatforms", bus=Mod.EventBusSubscriber.Bus.FORGE)
    public static class ServerForgeEvents {
        @SubscribeEvent
        public static void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent event) {
            Player player = event.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                TeleportPlayer.getInstance().getPlayerData((Player)serverPlayer);
                TeleportPlayer.getInstance().syncDataToClient(serverPlayer);
            }
        }

        @SubscribeEvent
        public static void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
            Player player = event.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                TeleportPlayer.getInstance().setAbilityCooldown((Player)serverPlayer);
                TeleportPlayer.getInstance().syncDataToClient(serverPlayer);
            }
        }

        @SubscribeEvent
        public static void onPlayerLogout(PlayerEvent.PlayerLoggedOutEvent event) {
            TeleportPlayer.getInstance().playerDataMap.remove(event.getEntity().m_20148_());
        }

        @SubscribeEvent
        public static void onPlayerClone(PlayerEvent.Clone event) {
            Player player = event.getOriginal();
            if (player instanceof ServerPlayer) {
                ServerPlayer originalPlayer = (ServerPlayer)player;
                player = event.getEntity();
                if (player instanceof ServerPlayer) {
                    ServerPlayer newPlayer = (ServerPlayer)player;
                    EnderPlayerDataSets.TeleportPlayerData originalData = TeleportPlayer.getInstance().getPlayerData((Player)originalPlayer);
                    EnderPlayerDataSets.TeleportPlayerData newData = TeleportPlayer.getInstance().getPlayerData((Player)newPlayer);
                    newData.abilityCooldown = originalData.abilityCooldown;
                    TeleportPlayer.getInstance().syncDataToClient(newPlayer);
                }
            }
        }
    }
}

