/*
 * Decompiled with CFR 0.152.
 */
package net.kenji.kenjiscombatforms.api.powers.VoidPowers;

import java.util.Map;
import java.util.UUID;
import net.kenji.kenjiscombatforms.api.handlers.power_data.EnderPlayerDataSets;
import net.kenji.kenjiscombatforms.api.interfaces.ability.Ability;
import net.kenji.kenjiscombatforms.api.interfaces.ability.AbstractAbilityData;
import net.kenji.kenjiscombatforms.api.managers.AbilityManager;
import net.kenji.kenjiscombatforms.config.EpicFightCombatFormsCommon;
import net.kenji.kenjiscombatforms.event.CommonFunctions;
import net.kenji.kenjiscombatforms.network.NetworkHandler;
import net.kenji.kenjiscombatforms.network.voidform.ClientVoidData;
import net.kenji.kenjiscombatforms.network.voidform.ability1.SyncVoidDataPacket;
import net.kenji.kenjiscombatforms.screen.guiEffects.BlinkEffect;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.PacketDistributor;

public class TeleportPlayerBackstab
implements Ability {
    private final EnderPlayerDataSets dataSets = EnderPlayerDataSets.getInstance();
    private final Map<UUID, EnderPlayerDataSets.TeleportPlayerData> playerDataMap;
    private final CommonFunctions dataHandlers;
    private static final TeleportPlayerBackstab INSTANCE = new TeleportPlayerBackstab();
    ServerPlayer serverPlayer;

    private EnderPlayerDataSets.TeleportPlayerData getPlayerData(Player player) {
        return (EnderPlayerDataSets.TeleportPlayerData)this.getAbilityData(player);
    }

    @Override
    public String getName() {
        return AbilityManager.AltAbilityOption.VOID_BACKSTAB.name();
    }

    public TeleportPlayerBackstab() {
        this.playerDataMap = this.dataSets.A1playerDataMap;
        this.dataHandlers = CommonFunctions.getInstance();
    }

    public static TeleportPlayerBackstab getInstance() {
        return INSTANCE;
    }

    public float getAbilityCooldown(ServerPlayer player) {
        return this.getPlayerData((Player)player).abilityCooldown;
    }

    public void setAbilityCooldown(Player player) {
        this.getPlayerData((Player)player).abilityCooldown += this.getPlayerData(player).getMAX_COOLDOWN() / (Integer)EpicFightCombatFormsCommon.ABILITY1_COOLDOWN_DIVISION.get();
    }

    @Override
    public AbstractAbilityData getAbilityData(Player player) {
        return this.dataSets.getOrCreateTeleportPlayerData(player);
    }

    @Override
    public void fillPerSecondCooldown(Player player) {
    }

    @Override
    public void drainPerSecondCooldown(Player player) {
    }

    @Override
    public boolean getAbilityActive(Player player) {
        return this.getAbilityData(player).isAbilityActive();
    }

    @Override
    public void sendPacketToServer(Player player) {
    }

    @Override
    public void triggerAbility(ServerPlayer serverPlayer) {
        EnderPlayerDataSets.TeleportPlayerData data = this.getPlayerData((Player)serverPlayer);
        long currentTime = System.currentTimeMillis();
        if (this.getLookingEntity((Player)serverPlayer, data.maxDist) != null && data.abilityCooldown <= data.getMAX_COOLDOWN() / (Integer)EpicFightCombatFormsCommon.ABILITY1_COOLDOWN_DIVISION.get()) {
            this.activateAbility(serverPlayer);
            this.playSound((Player)serverPlayer);
            this.setAbilityCooldown((Player)serverPlayer);
            this.syncDataToClient(serverPlayer);
        }
    }

    @Override
    public void activateAbility(ServerPlayer serverPlayer) {
        EnderPlayerDataSets.TeleportPlayerData data = this.getPlayerData((Player)serverPlayer);
        if (!serverPlayer.m_6047_() || !serverPlayer.m_6144_()) {
            UUID tpEntityUUID = this.getLookingEntity((Player)serverPlayer, data.maxDist).m_20148_();
            Vec3 targetPos = this.getLookingEntity((Player)serverPlayer, data.maxDist).m_20318_(1.0f);
            Vec3 eyePos = this.getLookingEntity((Player)serverPlayer, data.maxDist).m_20299_(1.0f);
            Vec3 targetlookVec = this.getLookingEntity((Player)serverPlayer, data.maxDist).m_20252_(1.0f);
            double distanceBehind = 5.0;
            double yOffset = 0.5;
            float targetPitch = this.getLookingEntity((Player)serverPlayer, data.maxDist).m_146908_();
            float targetYaw = this.getLookingEntity((Player)serverPlayer, data.maxDist).m_146909_();
            Vec3 behindPos = targetPos.m_82546_(targetlookVec.m_82490_(distanceBehind));
            serverPlayer.m_6021_(behindPos.f_82479_, behindPos.f_82480_ + yOffset, behindPos.f_82481_);
            serverPlayer.m_7618_(EntityAnchorArgument.Anchor.FEET, serverPlayer.m_284548_().m_8791_(tpEntityUUID).m_20318_(1.0f));
            serverPlayer.m_146926_(targetYaw);
        } else {
            Entity entity = this.getLookingEntity((Player)serverPlayer, data.maxDist);
            if (entity != null) {
                Vec3 lookVec = serverPlayer.m_20154_();
                Vec3 playerPos = serverPlayer.m_20182_();
                Vec3 targetPos = playerPos.m_82549_(lookVec.m_82490_(3.0));
                entity.m_6021_(targetPos.f_82479_, targetPos.f_82480_ + 1.5, targetPos.f_82481_);
                entity.m_7618_(EntityAnchorArgument.Anchor.EYES, serverPlayer.m_20182_());
                data.isTpHoldActive = true;
                data.holdEntity = entity;
            }
        }
    }

    @Override
    public void deactivateAbilityOptional(ServerPlayer serverPlayer) {
    }

    @Override
    public void decrementCooldown(Player player) {
    }

    @Override
    public void tickServerAbilityData(ServerPlayer player) {
        this.tickHoldEntity((Player)player);
    }

    @Override
    public void tickClientAbilityData(Player player) {
    }

    @Override
    public void syncDataToClient(ServerPlayer player) {
        EnderPlayerDataSets.TeleportPlayerData data = this.getPlayerData((Player)player);
        NetworkHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> player), (Object)new SyncVoidDataPacket(data.abilityCooldown));
    }

    @Override
    public void playSound(Player player) {
        player.m_9236_().m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11852_, SoundSource.PLAYERS, 1.0f, 1.0f);
    }

    @Override
    public void playSound2(Player player) {
    }

    @OnlyIn(value=Dist.CLIENT)
    public void blink(Player player) {
        int currentVoidCooldown;
        EnderPlayerDataSets.TeleportPlayerData data = this.getPlayerData(player);
        if (this.getLookingEntity(player, data.maxDist) != null && (currentVoidCooldown = ClientVoidData.getCooldown2()) <= data.getMAX_COOLDOWN() / 2) {
            BlinkEffect.triggerFade(player);
        }
    }

    public boolean isAbilityChosenOrEquipped(Player player) {
        AbilityManager.PlayerAbilityData abilityData = AbilityManager.getInstance().getPlayerAbilityData(player);
        return abilityData.chosenAbility1.name().equals(this.getName());
    }

    public Entity getLookingEntity(Player player, int maxDistance) {
        maxDistance = this.getPlayerData((Player)player).maxDist;
        Vec3 eyePos = player.m_20299_(1.0f);
        Vec3 lookVec = player.m_20252_(1.0f);
        Vec3 endVec = eyePos.m_82520_(lookVec.f_82479_ * (double)maxDistance, lookVec.f_82480_ * (double)maxDistance, lookVec.f_82481_ * (double)maxDistance);
        EntityHitResult hitResult = ProjectileUtil.m_150175_((Level)player.m_9236_(), (Entity)player, (Vec3)eyePos, (Vec3)endVec, (AABB)player.m_20191_().m_82400_((double)maxDistance), entity -> !entity.m_5833_(), (float)0.0f);
        if (hitResult != null) {
            return hitResult.m_82443_();
        }
        return null;
    }

    private void tickHoldEntity(Player player) {
        EnderPlayerDataSets.TeleportPlayerData data = this.getPlayerData(player);
        int holdTime = 55;
        if (this.isAbilityChosenOrEquipped(player)) {
            Entity entity;
            if ((player.m_6047_() || player.m_6144_()) && (entity = this.getLookingEntity(player, data.maxDist)) instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19619_, 5, 1, false, false));
                livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19620_, 5, -1, false, false));
            }
            if (data.isTpHoldActive) {
                LivingEntity livingEntity;
                Entity entity2;
                ++data.holdTickCounter;
                if (data.holdTickCounter < holdTime) {
                    data.holdEntity.m_20256_(Vec3.f_82478_);
                    entity2 = data.holdEntity;
                    if (entity2 instanceof LivingEntity) {
                        livingEntity = (LivingEntity)entity2;
                        livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19619_, holdTime, 1, false, false));
                    }
                }
                if (data.holdTickCounter > holdTime && (entity2 = data.holdEntity) instanceof LivingEntity) {
                    livingEntity = (LivingEntity)entity2;
                    data.isTpHoldActive = false;
                    data.holdTickCounter = 0;
                    data.holdEntity = null;
                    livingEntity.m_21195_(MobEffects.f_19619_);
                }
            }
        }
    }

    @Mod.EventBusSubscriber(modid="kenjiscombatforms", bus=Mod.EventBusSubscriber.Bus.FORGE)
    public static class ServerForgeEvents {
        @SubscribeEvent
        public static void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent event) {
            Player player = event.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                TeleportPlayerBackstab.getInstance().getPlayerData((Player)serverPlayer);
                TeleportPlayerBackstab.getInstance().syncDataToClient(serverPlayer);
            }
        }

        @SubscribeEvent
        public static void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
            Player player = event.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                TeleportPlayerBackstab.getInstance().syncDataToClient(serverPlayer);
            }
        }

        @SubscribeEvent
        public static void onPlayerLogout(PlayerEvent.PlayerLoggedOutEvent event) {
            TeleportPlayerBackstab.getInstance().playerDataMap.remove(event.getEntity().m_20148_());
        }

        @SubscribeEvent
        public static void onPlayerClone(PlayerEvent.Clone event) {
            Player player = event.getOriginal();
            if (player instanceof ServerPlayer) {
                ServerPlayer originalPlayer = (ServerPlayer)player;
                player = event.getEntity();
                if (player instanceof ServerPlayer) {
                    ServerPlayer newPlayer = (ServerPlayer)player;
                    EnderPlayerDataSets.TeleportPlayerData originalData = TeleportPlayerBackstab.getInstance().getPlayerData((Player)originalPlayer);
                    EnderPlayerDataSets.TeleportPlayerData newData = TeleportPlayerBackstab.getInstance().getPlayerData((Player)newPlayer);
                    newData.abilityCooldown = originalData.abilityCooldown;
                    TeleportPlayerBackstab.getInstance().syncDataToClient(newPlayer);
                }
            }
        }
    }
}

