/*
 * Decompiled with CFR 0.152.
 */
package net.kenji.kenjiscombatforms.api.powers.VoidPowers;

import java.util.Map;
import java.util.UUID;
import net.kenji.kenjiscombatforms.api.handlers.ClientEventHandler;
import net.kenji.kenjiscombatforms.api.handlers.power_data.EnderPlayerDataSets;
import net.kenji.kenjiscombatforms.api.interfaces.ability.Ability;
import net.kenji.kenjiscombatforms.api.interfaces.ability.AbilityDamageGainStrategy;
import net.kenji.kenjiscombatforms.api.interfaces.ability.AbstractAbilityData;
import net.kenji.kenjiscombatforms.api.managers.AbilityManager;
import net.kenji.kenjiscombatforms.block.ModBlocks;
import net.kenji.kenjiscombatforms.block.custom.VoidRiftBlock;
import net.kenji.kenjiscombatforms.config.EpicFightCombatFormsCommon;
import net.kenji.kenjiscombatforms.event.CommonFunctions;
import net.kenji.kenjiscombatforms.event.sound.SoundManager;
import net.kenji.kenjiscombatforms.network.NetworkHandler;
import net.kenji.kenjiscombatforms.network.particle_packets.RiftSummonParticlesTickPacket;
import net.kenji.kenjiscombatforms.network.voidform.ability2.SyncVoidData2Packet;
import net.kenji.kenjiscombatforms.network.voidform.ability2.VoidRiftPacket;
import net.kenji.kenjiscombatforms.sound.ModSounds;
import net.minecraft.core.BlockPos;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundBlockUpdatePacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.util.thread.EffectiveSide;
import net.minecraftforge.network.PacketDistributor;

public class VoidAnchorRift
implements Ability {
    private final EnderPlayerDataSets dataSets = EnderPlayerDataSets.getInstance();
    private final Map<UUID, EnderPlayerDataSets.VoidRiftPlayerData> playerDataMap;
    private static final VoidAnchorRift INSTANCE = new VoidAnchorRift();
    private final CommonFunctions dataHandlers;

    @Override
    public String getName() {
        return AbilityManager.AbilityOption2.VOID_ABILITY2.name();
    }

    private EnderPlayerDataSets.VoidRiftPlayerData getPlayerData(Player player) {
        return (EnderPlayerDataSets.VoidRiftPlayerData)this.getAbilityData(player);
    }

    public VoidAnchorRift() {
        this.playerDataMap = this.dataSets.A2playerDataMap;
        this.dataHandlers = CommonFunctions.getInstance();
    }

    public static VoidAnchorRift getInstance() {
        return INSTANCE;
    }

    public int getAbilityCooldown(ServerPlayer player) {
        return this.getPlayerData((Player)player).abilityCooldown;
    }

    public void setAbilityCooldown(ServerPlayer player, int cooldown) {
        this.getPlayerData((Player)player).abilityCooldown = Math.min(Math.max(cooldown, 0), this.getPlayerData((Player)player).getMAX_COOLDOWN());
    }

    private void timerRiftPlacement(ServerPlayer player) {
        EnderPlayerDataSets.VoidRiftPlayerData data = this.getPlayerData((Player)player);
        Block voidRiftBlock = (Block)ModBlocks.VOID_RIFT.get();
        BlockState voidRiftState = voidRiftBlock.m_49966_();
        if (data.canCount) {
            ++data.timerCount;
            if (data.timerCount > 100 && data.riftPosition != null) {
                this.playSound2((Player)player);
                player.m_9236_().m_7731_(data.riftPosition, voidRiftState, 3);
                data.timerCount = 0;
                data.canCount = false;
                if (player.m_9236_().f_46443_) {
                    this.stopCustomSound((Player)player);
                }
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void stopCustomSound(Player player) {
        EnderPlayerDataSets.VoidRiftPlayerData data = this.playerDataMap.computeIfAbsent(player.m_20148_(), k -> new EnderPlayerDataSets.VoidRiftPlayerData());
        SoundManager.stopCustomSound(player.m_9236_(), data.riftPosition);
    }

    @OnlyIn(value=Dist.CLIENT)
    private void playCustomSound(Player player) {
        EnderPlayerDataSets.VoidRiftPlayerData data = this.playerDataMap.computeIfAbsent(player.m_20148_(), k -> new EnderPlayerDataSets.VoidRiftPlayerData());
        SoundManager.playCustomSound(player.m_9236_(), player.m_20183_(), (SoundEvent)ModSounds.VOID_RIFT_SOUND.get(), SoundSource.BLOCKS, 0.8f, 1.0f);
    }

    @Override
    public AbstractAbilityData getAbilityData(Player player) {
        return this.dataSets.getOrCreateVoidRiftPlayerData(player);
    }

    @Override
    public void fillPerSecondCooldown(Player player) {
        EnderPlayerDataSets.VoidRiftPlayerData data = this.getPlayerData(player);
        int cooldown = data.abilityCooldown;
        if (cooldown > 0) {
            data.tickCount = this.dataHandlers.getTickCount(data.tickCount);
            data.abilityCooldown = this.dataHandlers.decreaseCooldown(data.abilityCooldown, data.tickCount);
        }
    }

    @Override
    public void drainPerSecondCooldown(Player player) {
        EnderPlayerDataSets.VoidRiftPlayerData data = this.getPlayerData(player);
        data.tickCount = this.dataHandlers.getTickCount(data.tickCount);
        data.abilityCooldown = this.dataHandlers.increaseCooldown(data.abilityCooldown, data.tickCount);
    }

    @Override
    public boolean getAbilityActive(Player player) {
        return this.getAbilityData(player).isAbilityActive();
    }

    @Override
    public void sendPacketToServer(Player player) {
        if (!ClientEventHandler.getInstance().getAreFinalsActive()) {
            NetworkHandler.INSTANCE.sendToServer((Object)new VoidRiftPacket());
        }
    }

    @Override
    public void triggerAbility(ServerPlayer serverPlayer) {
        EnderPlayerDataSets.VoidRiftPlayerData data = this.getPlayerData((Player)serverPlayer);
        if (data.abilityCooldown <= 0) {
            this.activateAbility(serverPlayer);
        } else {
            this.deactivateAbilityOptional(serverPlayer);
        }
    }

    @Override
    public void activateAbility(ServerPlayer player) {
        EnderPlayerDataSets.VoidRiftPlayerData data = this.getPlayerData((Player)player);
        data.isRiftActive = true;
        data.canCount = true;
        if (player.m_9236_().f_46443_) {
            this.playCustomSound((Player)player);
        }
        BlockPos riftBlockPos = player.m_20183_();
        data.riftPosition = riftBlockPos.m_7949_();
        NetworkHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> player), (Object)new RiftSummonParticlesTickPacket(player.m_20183_(), 4, 64, 24));
    }

    @Override
    public void deactivateAbilityOptional(ServerPlayer serverPlayer) {
        EnderPlayerDataSets.VoidRiftPlayerData data = this.getPlayerData((Player)serverPlayer);
        if (data.isRiftActive && data.riftPosition != null) {
            ServerLevel level = serverPlayer.m_284548_();
            if (level.m_8055_(data.riftPosition).m_60734_() instanceof VoidRiftBlock) {
                level.m_7731_(data.riftPosition, Blocks.f_50016_.m_49966_(), 3);
                level.m_7260_(data.riftPosition, level.m_8055_(data.riftPosition), Blocks.f_50016_.m_49966_(), 3);
                serverPlayer.f_8906_.m_9829_((Packet)new ClientboundBlockUpdatePacket((BlockGetter)level, data.riftPosition));
            }
            data.isRiftActive = false;
            data.riftPosition = null;
        }
    }

    @Override
    public void decrementCooldown(Player player) {
        EnderPlayerDataSets.VoidRiftPlayerData data = this.playerDataMap.computeIfAbsent(player.m_20148_(), k -> new EnderPlayerDataSets.VoidRiftPlayerData());
        if (this.isAbilityChosenOrEquipped(player) && player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (EffectiveSide.get() == LogicalSide.SERVER) {
                if (!((Boolean)EpicFightCombatFormsCommon.ABILITY2_COMBAT_MODE.get()).booleanValue() && !data.isRiftActive) {
                    this.fillPerSecondCooldown(player);
                }
                if (data.abilityCooldown < data.getMAX_COOLDOWN() && data.isRiftActive) {
                    this.drainPerSecondCooldown(player);
                    this.drainPerSecondCooldown(player);
                }
                if (data.abilityCooldown >= data.getMAX_COOLDOWN() && data.isRiftActive) {
                    this.deactivateAbilityOptional(serverPlayer);
                    if (!data.hasPlayedSound) {
                        data.hasPlayedSound = true;
                        this.playSound(player);
                    }
                }
            }
        }
    }

    @Override
    public void tickServerAbilityData(ServerPlayer player) {
        EnderPlayerDataSets.VoidRiftPlayerData data = this.getPlayerData((Player)player);
        AbilityManager.PlayerAbilityData abilityData = AbilityManager.getInstance().getPlayerAbilityData((Player)player);
        if (abilityData.chosenAbility2.name().equals(this.getName())) {
            VoidAnchorRift.getInstance().decrementCooldown((Player)player);
            this.syncDataToClient(player);
            this.timerRiftPlacement(player);
        }
    }

    @Override
    public void tickClientAbilityData(Player player) {
    }

    @Override
    public void syncDataToClient(ServerPlayer player) {
        EnderPlayerDataSets.VoidRiftPlayerData data = this.getPlayerData((Player)player);
        if (this.isAbilityChosenOrEquipped((Player)player)) {
            NetworkHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> player), (Object)new SyncVoidData2Packet(data.abilityCooldown));
        }
    }

    public boolean isAbilityChosenOrEquipped(Player player) {
        AbilityManager.PlayerAbilityData abilityData = AbilityManager.getInstance().getPlayerAbilityData(player);
        return abilityData.chosenAbility2.name().equals(this.getName());
    }

    @Override
    public void playSound(Player player) {
        player.m_9236_().m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11851_, SoundSource.PLAYERS, 1.0f, 1.0f);
    }

    @Override
    public void playSound2(Player player) {
        player.m_9236_().m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12052_, SoundSource.PLAYERS, 1.0f, 1.0f);
    }

    public static class CurrentDamageGainStrategy
    implements AbilityDamageGainStrategy {
        @Override
        public void fillDamageCooldown(Player player) {
            EnderPlayerDataSets.VoidRiftPlayerData data = VoidAnchorRift.getInstance().playerDataMap.computeIfAbsent(player.m_20148_(), k -> new EnderPlayerDataSets.VoidRiftPlayerData());
            if (((Boolean)EpicFightCombatFormsCommon.ABILITY2_COMBAT_MODE.get()).booleanValue() && !data.isAbilityActive()) {
                if (data.abilityCooldown > 0) {
                    data.abilityCooldown -= ((Integer)EpicFightCombatFormsCommon.COMBAT_MODE_GAIN_AMOUNT.get()).intValue();
                }
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    VoidAnchorRift.getInstance().syncDataToClient(serverPlayer);
                }
            }
        }
    }

    @Mod.EventBusSubscriber(modid="kenjiscombatforms", bus=Mod.EventBusSubscriber.Bus.FORGE)
    public static class ServerForgeEvents {
        @SubscribeEvent
        public static void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent event) {
            Player player = event.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                VoidAnchorRift.getInstance().getPlayerData((Player)serverPlayer);
            }
        }

        @SubscribeEvent
        public static void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
            Player player = event.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                VoidAnchorRift.getInstance().setAbilityCooldown(serverPlayer, VoidAnchorRift.getInstance().getPlayerData((Player)serverPlayer).getMAX_COOLDOWN());
            }
        }

        @SubscribeEvent
        public static void onPlayerLogout(PlayerEvent.PlayerLoggedOutEvent event) {
            VoidAnchorRift.getInstance().playerDataMap.remove(event.getEntity().m_20148_());
        }

        @SubscribeEvent
        public static void onPlayerClone(PlayerEvent.Clone event) {
            Player player = event.getOriginal();
            if (player instanceof ServerPlayer) {
                ServerPlayer originalPlayer = (ServerPlayer)player;
                player = event.getEntity();
                if (player instanceof ServerPlayer) {
                    ServerPlayer newPlayer = (ServerPlayer)player;
                    EnderPlayerDataSets.VoidRiftPlayerData originalData = VoidAnchorRift.getInstance().getPlayerData((Player)originalPlayer);
                    EnderPlayerDataSets.VoidRiftPlayerData newData = VoidAnchorRift.getInstance().getPlayerData((Player)newPlayer);
                    newData.abilityCooldown = originalData.abilityCooldown;
                }
            }
        }
    }
}

