/*
 * Decompiled with CFR 0.152.
 */
package net.kenji.kenjiscombatforms.api.powers.VoidPowers;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.kenji.kenjiscombatforms.api.handlers.power_data.EnderPlayerDataSets;
import net.kenji.kenjiscombatforms.api.interfaces.ability.AbstractAbilityData;
import net.kenji.kenjiscombatforms.api.interfaces.ability.FinalAbility;
import net.kenji.kenjiscombatforms.api.managers.AbilityManager;
import net.kenji.kenjiscombatforms.event.CommonFunctions;
import net.kenji.kenjiscombatforms.network.NetworkHandler;
import net.kenji.kenjiscombatforms.network.voidform.ender_abilities.ability5.SyncVoidData5Packet;
import net.kenji.kenjiscombatforms.network.voidform.ender_abilities.ability5.VoidGrabPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.PacketDistributor;

public class VoidGrab
implements FinalAbility {
    private final EnderPlayerDataSets dataSets = EnderPlayerDataSets.getInstance();
    private final Map<UUID, EnderPlayerDataSets.VoidGrabPlayerData> playerDataMap;
    private final CommonFunctions dataHandlers;
    private static final VoidGrab INSTANCE = new VoidGrab();

    @Override
    public String getName() {
        return AbilityManager.AbilityOption5.VOID_GRAB.name();
    }

    @Override
    public String getFinalAbilityName() {
        return AbilityManager.AbilityOption3.VOID_FINAL.name();
    }

    public EnderPlayerDataSets.VoidGrabPlayerData getPlayerData(Player player) {
        return (EnderPlayerDataSets.VoidGrabPlayerData)this.getAbilityData(player);
    }

    public EnderPlayerDataSets.EnderFormPlayerData getOrCreateEnderFormPlayerData(Player player) {
        return this.dataSets.getOrCreateEnderFormPlayerData(player);
    }

    public VoidGrab() {
        this.playerDataMap = EnderPlayerDataSets.getInstance().A5playerDataMap;
        this.dataHandlers = CommonFunctions.getInstance();
    }

    public static VoidGrab getInstance() {
        return INSTANCE;
    }

    public int getAbilityCooldown(Player player) {
        return this.getPlayerData((Player)player).abilityCooldown;
    }

    public void setAbilityCooldown(Player player) {
        this.getPlayerData((Player)player).abilityCooldown += this.getPlayerData(player).getMAX_COOLDOWN() / 2;
    }

    @Override
    public AbstractAbilityData getAbilityData(Player player) {
        return this.dataSets.getOrCreateVoidGrabPlayerData(player);
    }

    @Override
    public boolean getFinalAbilityActive(Player player) {
        return AbilityManager.getInstance().getAbility(this.getFinalAbilityName()).getAbilityData(player).isAbilityActive();
    }

    @Override
    public boolean getAbilityActive(Player player) {
        return this.getAbilityData(player).isAbilityActive();
    }

    @Override
    public void fillPerSecondCooldown(Player player) {
        EnderPlayerDataSets.VoidGrabPlayerData data = this.getPlayerData(player);
        int cooldown = data.abilityCooldown;
        if (cooldown > 0) {
            data.tickCount = this.dataHandlers.getTickCount(data.tickCount);
            data.abilityCooldown = this.dataHandlers.decreaseCooldown(data.abilityCooldown, data.tickCount);
        }
    }

    @Override
    public void drainPerSecondCooldown(Player player) {
    }

    @Override
    public void sendPacketToServer(Player player) {
        NetworkHandler.INSTANCE.sendToServer((Object)new VoidGrabPacket());
    }

    @Override
    public void triggerAbility(ServerPlayer serverPlayer) {
        EnderPlayerDataSets.VoidGrabPlayerData data = this.getPlayerData((Player)serverPlayer);
        EnderPlayerDataSets.EnderFormPlayerData wData = this.getOrCreateEnderFormPlayerData((Player)serverPlayer);
        long currentTime = System.currentTimeMillis();
        if (data.abilityCooldown <= 0 && wData.isAbilityActive()) {
            this.playSound((Player)serverPlayer);
            this.activateAbility(serverPlayer);
        }
    }

    @Override
    public void activateAbility(ServerPlayer serverPlayer) {
        EnderPlayerDataSets.VoidGrabPlayerData data = this.getPlayerData((Player)serverPlayer);
        data.hasActivated = true;
        data.abilityCooldown = data.getMAX_COOLDOWN();
    }

    @Override
    public void deactivateAbilityOptional(ServerPlayer serverPlayer) {
    }

    @Override
    public void decrementCooldown(Player player) {
        EnderPlayerDataSets.VoidGrabPlayerData data = this.getPlayerData(player);
        EnderPlayerDataSets.EnderFormPlayerData wData = this.dataSets.getOrCreateEnderFormPlayerData(player);
        if (wData.isAbilityActive()) {
            this.fillPerSecondCooldown(player);
        }
    }

    @Override
    public void tickServerAbilityData(ServerPlayer player) {
        VoidGrab.getInstance().decrementCooldown((Player)player);
        EnderPlayerDataSets.VoidGrabPlayerData data = this.getPlayerData((Player)player);
        this.handleNearbyZombies(player);
        this.syncDataToClient(player);
    }

    @Override
    public void tickClientAbilityData(Player player) {
    }

    @Override
    public void syncDataToClient(ServerPlayer player) {
        EnderPlayerDataSets.VoidGrabPlayerData data = this.getPlayerData((Player)player);
        if (this.getFinalAbilityActive((Player)player)) {
            NetworkHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> player), (Object)new SyncVoidData5Packet(data.abilityCooldown));
        }
    }

    public boolean isAbilityChosenOrEquipped(Player player) {
        AbilityManager.PlayerAbilityData abilityData = AbilityManager.getInstance().getPlayerAbilityData(player);
        return abilityData.chosenFinal.name().equals(this.getName());
    }

    @Override
    public void playSound(Player player) {
        player.m_9236_().m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12500_, SoundSource.PLAYERS, 1.0f, 1.0f);
    }

    @Override
    public void playSound2(Player player) {
    }

    private void handleNearbyZombies(ServerPlayer player) {
        EnderPlayerDataSets.VoidGrabPlayerData data = this.getPlayerData((Player)player);
        EnderPlayerDataSets.EnderFormPlayerData eData = EnderPlayerDataSets.getInstance().getOrCreateEnderFormPlayerData((Player)player);
        if (data.hasActivated && data.countTicker == 0) {
            double radius = 10.0;
            AABB searchArea = new AABB(player.m_20097_()).m_82400_(radius);
            TargetingConditions targetingConditions = TargetingConditions.m_148352_();
            List nearbyEntities = player.m_9236_().m_45971_(LivingEntity.class, targetingConditions, (LivingEntity)player, searchArea);
            for (LivingEntity entity : nearbyEntities) {
                data.affectedEntities.put(entity.m_20148_(), new EnderPlayerDataSets.VoidGrabPlayerData.EntityState());
            }
        }
        if (data.hasActivated) {
            boolean allThrown;
            ++data.countTicker;
            Iterator<Map.Entry<UUID, EnderPlayerDataSets.VoidGrabPlayerData.EntityState>> it = data.affectedEntities.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<UUID, EnderPlayerDataSets.VoidGrabPlayerData.EntityState> entry = it.next();
                UUID entityId = entry.getKey();
                EnderPlayerDataSets.VoidGrabPlayerData.EntityState state2 = entry.getValue();
                LivingEntity entity = (LivingEntity)player.m_284548_().m_8791_(entityId);
                if (entity == null) {
                    it.remove();
                    continue;
                }
                if (data.countTicker <= 30) {
                    entity.m_7292_(new MobEffectInstance(MobEffects.f_19620_, 2, 0, false, false));
                    entity.m_7292_(new MobEffectInstance(MobEffects.f_19619_, 2, 0, false, false));
                    continue;
                }
                if (state2.hasThrown) continue;
                Vec3 lookVec = player.m_20154_();
                double throwStrength = 4.0;
                Vec3 throwVec = lookVec.m_82490_(throwStrength);
                entity.m_20256_(throwVec);
                entity.m_7292_(new MobEffectInstance(MobEffects.f_19615_, 40, 0, false, false));
                state2.hasThrown = true;
            }
            if (data.countTicker > 30 && (allThrown = data.affectedEntities.values().stream().allMatch(state -> state.hasThrown))) {
                data.hasActivated = false;
                data.countTicker = 0;
                data.affectedEntities.clear();
            }
        }
    }

    private void unsafeTeleport(Entity entity, double x, double y, double z) {
        entity.m_6021_(x, y, z);
        if (entity instanceof ServerPlayer) {
            ((ServerPlayer)entity).f_8906_.m_9774_(x, y, z, entity.m_146908_(), entity.m_146909_());
        }
    }

    @Mod.EventBusSubscriber(modid="kenjiscombatforms", bus=Mod.EventBusSubscriber.Bus.FORGE)
    public static class ServerForgeEvents {
        @SubscribeEvent
        public static void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent event) {
            Player player = event.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                VoidGrab.getInstance().getPlayerData((Player)serverPlayer);
                VoidGrab.getInstance().syncDataToClient(serverPlayer);
            }
            Player player2 = event.getEntity();
        }

        @SubscribeEvent
        public static void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
            Player player = event.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                VoidGrab.getInstance().setAbilityCooldown((Player)serverPlayer);
                VoidGrab.getInstance().syncDataToClient(serverPlayer);
            }
        }

        @SubscribeEvent
        public static void onPlayerLogout(PlayerEvent.PlayerLoggedOutEvent event) {
            VoidGrab.getInstance().playerDataMap.remove(event.getEntity().m_20148_());
        }

        @SubscribeEvent
        public static void onPlayerClone(PlayerEvent.Clone event) {
            Player player = event.getOriginal();
            if (player instanceof ServerPlayer) {
                ServerPlayer originalPlayer = (ServerPlayer)player;
                player = event.getEntity();
                if (player instanceof ServerPlayer) {
                    ServerPlayer newPlayer = (ServerPlayer)player;
                    EnderPlayerDataSets.VoidGrabPlayerData originalData = VoidGrab.getInstance().getPlayerData((Player)originalPlayer);
                    EnderPlayerDataSets.VoidGrabPlayerData newData = VoidGrab.getInstance().getPlayerData((Player)newPlayer);
                    newData.abilityCooldown = originalData.abilityCooldown;
                    VoidGrab.getInstance().syncDataToClient(newPlayer);
                }
            }
        }

        @SubscribeEvent
        public void onPlayerTick(TickEvent.PlayerTickEvent event) {
            if (event.phase == TickEvent.Phase.END) {
                Player player = event.player;
                EnderPlayerDataSets.VoidGrabPlayerData voidGrabPlayerData = VoidGrab.getInstance().getPlayerData(player);
            }
        }
    }
}

