/*
 * Decompiled with CFR 0.152.
 */
package net.kenji.kenjiscombatforms.api.powers.WitherPowers;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.kenji.kenjiscombatforms.api.handlers.ClientEventHandler;
import net.kenji.kenjiscombatforms.api.handlers.power_data.WitherPlayerDataSets;
import net.kenji.kenjiscombatforms.api.interfaces.ability.Ability;
import net.kenji.kenjiscombatforms.api.interfaces.ability.AbilityDamageGainStrategy;
import net.kenji.kenjiscombatforms.api.interfaces.ability.AbstractAbilityData;
import net.kenji.kenjiscombatforms.api.managers.AbilityManager;
import net.kenji.kenjiscombatforms.api.powers.WitherPowers.WitherMinions;
import net.kenji.kenjiscombatforms.config.EpicFightCombatFormsCommon;
import net.kenji.kenjiscombatforms.entity.ModEntities;
import net.kenji.kenjiscombatforms.entity.custom.noAiEntities.EnderEntity;
import net.kenji.kenjiscombatforms.entity.custom.noAiEntities.ShadowPlayerEntity;
import net.kenji.kenjiscombatforms.event.CommonFunctions;
import net.kenji.kenjiscombatforms.network.NetworkHandler;
import net.kenji.kenjiscombatforms.network.particle_packets.SmokeParticlesPacket;
import net.kenji.kenjiscombatforms.network.particle_packets.SoulParticlesTickPacket;
import net.kenji.kenjiscombatforms.network.witherform.ability2.SoulDriftPacket;
import net.kenji.kenjiscombatforms.network.witherform.ability2.SyncWitherData2Packet;
import net.minecraft.ChatFormatting;
import net.minecraft.server.TickTask;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.scores.PlayerTeam;
import net.minecraft.world.scores.Scoreboard;
import net.minecraft.world.scores.Team;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.PacketDistributor;
import yesman.epicfight.gameasset.Animations;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;

public class SoulDrift
implements Ability {
    private Entity shadowEntity;
    private final WitherPlayerDataSets dataSets = WitherPlayerDataSets.getInstance();
    private final CommonFunctions dataHandlers = CommonFunctions.getInstance();
    private final Map<UUID, WitherPlayerDataSets.SoulDriftPlayerData> playerDataMap;
    public Map<UUID, Entity> playerShadowMap;
    private static final SoulDrift INSTANCE = new SoulDrift();

    @Override
    public String getName() {
        return AbilityManager.AbilityOption2.WITHER_ABILITY2.name();
    }

    public WitherPlayerDataSets.SoulDriftPlayerData getPlayerData(Player player) {
        return (WitherPlayerDataSets.SoulDriftPlayerData)this.getAbilityData(player);
    }

    public SoulDrift() {
        this.playerDataMap = WitherPlayerDataSets.getInstance().A2playerDataMap;
        this.playerShadowMap = new ConcurrentHashMap<UUID, Entity>();
    }

    public static SoulDrift getInstance() {
        return INSTANCE;
    }

    public int getAbilityCooldown(ServerPlayer player) {
        return this.getPlayerData((Player)player).abilityCooldown;
    }

    public void setAbilityCooldown(ServerPlayer player, int cooldown) {
        this.getPlayerData((Player)player).abilityCooldown = Math.min(Math.max(cooldown, 0), this.getPlayerData((Player)player).getMAX_COOLDOWN());
    }

    @Override
    public AbstractAbilityData getAbilityData(Player player) {
        return this.dataSets.getOrCreateSoulDriftPlayerData(player);
    }

    @Override
    public void fillPerSecondCooldown(Player player) {
        WitherPlayerDataSets.SoulDriftPlayerData data = this.getPlayerData(player);
        int cooldown = data.abilityCooldown;
        if (cooldown > 0) {
            data.tickCount = this.dataHandlers.getTickCount(data.tickCount);
            data.abilityCooldown = this.dataHandlers.decreaseCooldown(data.abilityCooldown, data.tickCount);
        }
    }

    @Override
    public void drainPerSecondCooldown(Player player) {
        WitherPlayerDataSets.SoulDriftPlayerData data = this.getPlayerData(player);
        data.tickCount = this.dataHandlers.getTickCount(data.tickCount);
        data.abilityCooldown = this.dataHandlers.increaseCooldown(data.abilityCooldown, data.tickCount);
    }

    @Override
    public boolean getAbilityActive(Player player) {
        return this.getAbilityData(player).isAbilityActive();
    }

    @Override
    public void sendPacketToServer(Player player) {
        if (!ClientEventHandler.getInstance().getAreFinalsActive()) {
            NetworkHandler.INSTANCE.sendToServer((Object)new SoulDriftPacket());
        }
    }

    @Override
    public void triggerAbility(ServerPlayer serverPlayer) {
        WitherPlayerDataSets.SoulDriftPlayerData data = this.getPlayerData((Player)serverPlayer);
        if (!data.isSoulDriftActive && data.abilityCooldown <= 0) {
            this.activateAbility(serverPlayer);
            data.hasPlayedSound = false;
        } else if (data.isSoulDriftActive) {
            this.deactivateAbilityOptional(serverPlayer);
        }
    }

    @Override
    public void activateAbility(ServerPlayer serverPlayer) {
        WitherPlayerDataSets.SoulDriftPlayerData data = this.getPlayerData((Player)serverPlayer);
        Vec3 pushVector = new Vec3(0.0, 2.0, 0.0);
        data.isSoulDriftActive = true;
        this.activateDecoySummon(serverPlayer);
        serverPlayer.m_5997_(pushVector.f_82479_, pushVector.f_82480_, pushVector.f_82481_);
        serverPlayer.m_7292_(new MobEffectInstance(MobEffects.f_19609_, data.getMAX_COOLDOWN() * 20, 2, false, false));
        serverPlayer.m_7292_(new MobEffectInstance(MobEffects.f_19620_, 12, 1, false, false));
        serverPlayer.m_284548_().m_7654_().m_6937_((Runnable)new TickTask(serverPlayer.m_284548_().m_7654_().m_129921_() + 12, () -> serverPlayer.m_7292_(new MobEffectInstance(MobEffects.f_19620_, data.getMAX_COOLDOWN() * 20, -1, false, false))));
        this.handleNearbyMonsters((Player)serverPlayer);
        this.playSound((Player)serverPlayer);
        this.syncDataToClient(serverPlayer);
        NetworkHandler.INSTANCE.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> serverPlayer), (Object)new SmokeParticlesPacket(serverPlayer.m_20185_(), serverPlayer.m_20186_(), serverPlayer.m_20189_()));
    }

    @Override
    public void deactivateAbilityOptional(ServerPlayer serverPlayer) {
        WitherPlayerDataSets.SoulDriftPlayerData data = this.getPlayerData((Player)serverPlayer);
        double radius = 2.0;
        serverPlayer.m_21195_(MobEffects.f_19609_);
        serverPlayer.m_21195_(MobEffects.f_19620_);
        data.isSoulDriftActive = false;
        Entity existingDecoy = this.playerShadowMap.remove(serverPlayer.m_20148_());
        if (existingDecoy != null) {
            existingDecoy.m_142687_(Entity.RemovalReason.DISCARDED);
        }
        NetworkHandler.INSTANCE.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> serverPlayer), (Object)new SmokeParticlesPacket(serverPlayer.m_20185_(), serverPlayer.m_20186_(), serverPlayer.m_20189_()));
        this.syncDataToClient(serverPlayer);
    }

    @Override
    public void decrementCooldown(Player player) {
        WitherPlayerDataSets.SoulDriftPlayerData data = this.playerDataMap.computeIfAbsent(player.m_20148_(), k -> new WitherPlayerDataSets.SoulDriftPlayerData());
        if (this.isAbilityChosenOrEquipped(player)) {
            if (!((Boolean)EpicFightCombatFormsCommon.ABILITY2_COMBAT_MODE.get()).booleanValue()) {
                if (!data.isSoulDriftActive) {
                    this.fillPerSecondCooldown(player);
                }
            } else if (data.abilityCooldown < data.getMAX_COOLDOWN() && data.isAbilityActive()) {
                this.drainPerSecondCooldown(player);
                this.drainPerSecondCooldown(player);
            }
            if (data.abilityCooldown >= data.getMAX_COOLDOWN()) {
                player.m_21195_(MobEffects.f_19609_);
                player.m_21195_(MobEffects.f_19620_);
                player.m_6842_(false);
                data.isSoulDriftActive = false;
                Entity existingShadow = this.playerShadowMap.remove(player.m_20148_());
                if (existingShadow != null) {
                    existingShadow.m_142687_(Entity.RemovalReason.DISCARDED);
                }
                if (!data.hasPlayedSound) {
                    data.hasPlayedSound = true;
                    this.playSound(player);
                }
            }
            if (data.abilityCooldown >= data.getMAX_COOLDOWN() && data.isAbilityActive()) {
                this.deactivateClientInvisibility(player);
            }
        }
    }

    @Override
    public void tickServerAbilityData(ServerPlayer player) {
        WitherPlayerDataSets.SoulDriftPlayerData data = this.getPlayerData((Player)player);
        AbilityManager.PlayerAbilityData abilityData = AbilityManager.getInstance().getPlayerAbilityData((Player)player);
        if (abilityData.chosenAbility2.name().equals(this.getName())) {
            SoulDrift.getInstance().decrementCooldown((Player)player);
        }
        this.syncDataToClient(player);
        if (data.isSoulDriftActive) {
            NetworkHandler.INSTANCE.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> player), (Object)new SoulParticlesTickPacket(player.m_20185_(), player.m_20186_(), player.m_20189_(), player.m_20145_()));
            if (player.m_20145_() && this.shadowEntity instanceof EnderEntity && this.shadowEntity.m_6084_()) {
                ((EnderEntity)this.shadowEntity).setOpacity(7.0f);
            }
        }
    }

    @Override
    public void tickClientAbilityData(Player player) {
        WitherPlayerDataSets.SoulDriftPlayerData data = SoulDrift.getInstance().playerDataMap.computeIfAbsent(player.m_20148_(), k -> new WitherPlayerDataSets.SoulDriftPlayerData());
        SoulDrift.getInstance().decrementCooldown(player);
        if (data.isSoulDriftActive) {
            SoulDrift.preventCombatActions(player);
            if (player.m_6144_() || player.m_6047_()) {
                if (!player.m_9236_().m_8055_(player.m_20183_()).m_280296_()) {
                    Vec3 pushVector = new Vec3(0.0, -0.03, 0.0);
                    player.m_5997_(pushVector.f_82479_, pushVector.f_82480_, pushVector.f_82481_);
                }
            } else if (!player.m_9236_().m_8055_(player.m_20183_().m_6625_(3)).m_280296_() && !player.m_9236_().m_8055_(player.m_20183_()).m_280296_()) {
                Vec3 pushVector = new Vec3(0.0, -0.03, 0.0);
                player.m_5997_(pushVector.f_82479_, pushVector.f_82480_, pushVector.f_82481_);
            }
        }
    }

    @Override
    public void syncDataToClient(ServerPlayer player) {
        WitherPlayerDataSets.SoulDriftPlayerData data = this.getPlayerData((Player)player);
        if (this.isAbilityChosenOrEquipped((Player)player)) {
            NetworkHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> player), (Object)new SyncWitherData2Packet(data.abilityCooldown));
        }
    }

    public boolean isAbilityChosenOrEquipped(Player player) {
        AbilityManager.PlayerAbilityData abilityData = AbilityManager.getInstance().getPlayerAbilityData(player);
        return abilityData.chosenAbility2.name().equals(this.getName());
    }

    public void activateDecoySummon(ServerPlayer player) {
        WitherPlayerDataSets.SoulDriftPlayerData data = this.getPlayerData((Player)player);
        double radius = 10.0;
        data.hasPlayedSound = false;
        this.getNearestEntity((Player)player);
        Scoreboard scoreboard = player.m_9236_().m_6188_();
        String teamName = "active_shadows";
        PlayerTeam team = scoreboard.m_83489_(teamName);
        this.shadowEntity = ((EntityType)ModEntities.SHADOW_PLAYER.get()).m_262496_(player.m_284548_(), player.m_20183_(), MobSpawnType.TRIGGERED);
        if (team == null) {
            team = scoreboard.m_83492_(teamName);
            team.m_83351_(ChatFormatting.DARK_GRAY);
            team.m_83355_(false);
        }
        PlayerTeam minionTeam = scoreboard.m_83489_(WitherMinions.getInstance().teamName);
        if (this.shadowEntity != null) {
            scoreboard.m_6546_(this.shadowEntity.m_20149_(), team);
            this.playerShadowMap.put(player.m_20148_(), this.shadowEntity);
            Entity entity = this.shadowEntity;
            if (entity instanceof ShadowPlayerEntity) {
                ShadowPlayerEntity shadowPlayer = (ShadowPlayerEntity)entity;
                shadowPlayer.m_21816_(player.m_20148_());
            }
            if (minionTeam != null) {
                Objects.requireNonNull(scoreboard.m_83489_(teamName)).m_83536_((Team)minionTeam);
            }
        }
    }

    public static void preventCombatActions(Player player) {
        player.getCapability(EpicFightCapabilities.CAPABILITY_ENTITY).ifPresent(cap -> {
            if (cap instanceof PlayerPatch) {
                PlayerPatch playerPatch = (PlayerPatch)cap;
                playerPatch.getAnimator().playAnimation(Animations.BIPED_WALK, 0.0f);
                playerPatch.getEntityState().inaction();
            }
        });
    }

    public static void ResetCombatActions(Player player) {
        player.getCapability(EpicFightCapabilities.CAPABILITY_ENTITY).ifPresent(cap -> {
            if (cap instanceof PlayerPatch) {
                PlayerPatch playerPatch = (PlayerPatch)cap;
                playerPatch.getEntityState().inaction();
            }
        });
    }

    private Entity getNearestEntity(Player player) {
        double searchRadius = 10.0;
        AABB searchBox = player.m_20191_().m_82400_(searchRadius);
        List nearbyEntities = player.m_9236_().m_45933_((Entity)player, searchBox);
        Entity closestEntity = null;
        double closestDistanceSq = Double.MAX_VALUE;
        for (Entity entity : nearbyEntities) {
            double distanceSq;
            if (entity instanceof EnderEntity || !((distanceSq = player.m_20280_(entity)) < closestDistanceSq)) continue;
            closestDistanceSq = distanceSq;
            closestEntity = entity;
        }
        return closestEntity;
    }

    public void deactivateClientInvisibility(Player player) {
        SoulDrift.preventCombatActions(player);
    }

    @Override
    public void playSound(Player player) {
        player.m_9236_().m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12500_, SoundSource.PLAYERS, 1.0f, 1.0f);
    }

    @Override
    public void playSound2(Player player) {
    }

    private void handleNearbyMonsters(Player player) {
        double radius = 30.0;
        AABB searchArea = new AABB(player.m_20097_()).m_82400_(radius);
        TargetingConditions targetingConditions = TargetingConditions.m_148352_();
        List nearbyEntities = player.m_9236_().m_45971_(Monster.class, targetingConditions, (LivingEntity)player, searchArea);
        for (Monster monster : nearbyEntities) {
            if (monster.m_5448_() == null || !monster.m_5448_().m_7306_((Entity)player) || player.m_9236_().m_45517_(LightLayer.BLOCK, player.m_20183_()) >= 8) continue;
            monster.m_6710_(null);
            monster.f_21346_.m_25363_((Goal)new NearestAttackableTargetGoal((Mob)monster, Player.class, true));
        }
    }

    public static class CurrentDamageGainStrategy
    implements AbilityDamageGainStrategy {
        @Override
        public void fillDamageCooldown(Player player) {
            WitherPlayerDataSets.SoulDriftPlayerData data = SoulDrift.getInstance().getPlayerData(player);
            if (((Boolean)EpicFightCombatFormsCommon.ABILITY2_COMBAT_MODE.get()).booleanValue() && !data.isAbilityActive()) {
                if (data.abilityCooldown > 0) {
                    data.abilityCooldown -= ((Integer)EpicFightCombatFormsCommon.COMBAT_MODE_GAIN_AMOUNT.get()).intValue();
                }
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    SoulDrift.getInstance().syncDataToClient(serverPlayer);
                }
            }
        }
    }

    @Mod.EventBusSubscriber(modid="kenjiscombatforms", bus=Mod.EventBusSubscriber.Bus.FORGE)
    public static class ServerForgeEvents {
        @SubscribeEvent
        public static void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent event) {
            Player player = event.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                SoulDrift.getInstance().getPlayerData((Player)serverPlayer);
                SoulDrift.getInstance().syncDataToClient(serverPlayer);
                SoulDrift.getInstance().deactivateAbilityOptional(serverPlayer);
            }
        }

        @SubscribeEvent
        public static void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
            Player player;
            Entity existingDecoy = SoulDrift.getInstance().playerShadowMap.remove(event.getEntity().m_20148_());
            if (existingDecoy != null) {
                existingDecoy.m_142687_(Entity.RemovalReason.DISCARDED);
            }
            if ((player = event.getEntity()) instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                SoulDrift.getInstance().setAbilityCooldown(serverPlayer, SoulDrift.getInstance().getPlayerData((Player)serverPlayer).getMAX_COOLDOWN());
                SoulDrift.getInstance().syncDataToClient(serverPlayer);
            }
        }

        @SubscribeEvent
        public static void onPlayerLogout(PlayerEvent.PlayerLoggedOutEvent event) {
            Entity existingDecoy = SoulDrift.getInstance().playerShadowMap.remove(event.getEntity().m_20148_());
            if (existingDecoy != null) {
                existingDecoy.m_142687_(Entity.RemovalReason.DISCARDED);
            }
            SoulDrift.getInstance().playerDataMap.remove(event.getEntity().m_20148_());
        }

        @SubscribeEvent
        public static void onPlayerClone(PlayerEvent.Clone event) {
            Player player = event.getOriginal();
            if (player instanceof ServerPlayer) {
                ServerPlayer originalPlayer = (ServerPlayer)player;
                player = event.getEntity();
                if (player instanceof ServerPlayer) {
                    ServerPlayer newPlayer = (ServerPlayer)player;
                    WitherPlayerDataSets.SoulDriftPlayerData originalData = SoulDrift.getInstance().getPlayerData((Player)originalPlayer);
                    WitherPlayerDataSets.SoulDriftPlayerData newData = SoulDrift.getInstance().getPlayerData((Player)newPlayer);
                    newData.abilityCooldown = originalData.abilityCooldown;
                    SoulDrift.getInstance().syncDataToClient(newPlayer);
                }
            }
        }
    }
}

