/*
 * Decompiled with CFR 0.152.
 */
package net.kenji.kenjiscombatforms.api.powers.WitherPowers;

import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.kenji.kenjiscombatforms.api.handlers.ClientEventHandler;
import net.kenji.kenjiscombatforms.api.handlers.power_data.WitherPlayerDataSets;
import net.kenji.kenjiscombatforms.api.interfaces.ability.Ability;
import net.kenji.kenjiscombatforms.api.interfaces.ability.AbstractAbilityData;
import net.kenji.kenjiscombatforms.api.managers.AbilityManager;
import net.kenji.kenjiscombatforms.config.EpicFightCombatFormsCommon;
import net.kenji.kenjiscombatforms.event.CommonFunctions;
import net.kenji.kenjiscombatforms.event.sound.SoundManager;
import net.kenji.kenjiscombatforms.network.NetworkHandler;
import net.kenji.kenjiscombatforms.network.witherform.ClientWitherData;
import net.kenji.kenjiscombatforms.network.witherform.ability1.SyncWitherDataPacket;
import net.kenji.kenjiscombatforms.network.witherform.ability1.WitherDashPacket;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.PacketDistributor;
import reascer.wom.gameasset.WOMAnimations;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;

public class WitherDash
implements Ability {
    private final WitherPlayerDataSets dataSets = WitherPlayerDataSets.getInstance();
    private final CommonFunctions dataHandlers = CommonFunctions.getInstance();
    private final Map<UUID, WitherPlayerDataSets.WitherDashPlayerData> playerDataMap;
    private static final WitherDash INSTANCE = new WitherDash();
    public GuiGraphics guiGraphics;

    @Override
    public String getName() {
        return AbilityManager.AbilityOption1.WITHER_ABILITY1.name();
    }

    WitherPlayerDataSets.WitherDashPlayerData getPlayerData(Player player) {
        return (WitherPlayerDataSets.WitherDashPlayerData)this.getAbilityData(player);
    }

    WitherPlayerDataSets.WitherMinionPlayerData getOrCreateMinionPlayerData(Player player) {
        return this.dataSets.getOrCreateMinionPlayerData(player);
    }

    public WitherDash() {
        this.playerDataMap = WitherPlayerDataSets.getInstance().A1playerDataMap;
    }

    public static WitherDash getInstance() {
        return INSTANCE;
    }

    public int getAbilityCooldown(Player player) {
        return this.getPlayerData((Player)player).abilityCooldown;
    }

    public void setAbilityCooldown(Player player) {
        this.getPlayerData((Player)player).abilityCooldown += this.getPlayerData(player).getMAX_COOLDOWN() / (Integer)EpicFightCombatFormsCommon.ABILITY1_COOLDOWN_DIVISION.get();
    }

    @Override
    public AbstractAbilityData getAbilityData(Player player) {
        return this.dataSets.getOrCreateDashPlayerData(player);
    }

    @Override
    public void fillPerSecondCooldown(Player player) {
        WitherPlayerDataSets.WitherDashPlayerData data = this.getPlayerData(player);
        int cooldown = data.abilityCooldown;
        if (cooldown > 0) {
            data.tickCount = this.dataHandlers.getTickCount(data.tickCount);
            data.abilityCooldown = this.dataHandlers.decreaseCooldown(data.abilityCooldown, data.tickCount);
        }
    }

    @Override
    public void drainPerSecondCooldown(Player player) {
    }

    @Override
    public boolean getAbilityActive(Player player) {
        return this.getAbilityData(player).isAbilityActive();
    }

    @Override
    public void sendPacketToServer(Player player) {
        WitherPlayerDataSets.WitherDashPlayerData wData = WitherDash.getInstance().dataSets.getOrCreateDashPlayerData(player);
        if (!ClientEventHandler.getInstance().getAreFinalsActive() && !ClientWitherData.getMinionsActive() && ClientWitherData.getCooldown() <= wData.getMAX_COOLDOWN() / (Integer)EpicFightCombatFormsCommon.ABILITY1_COOLDOWN_DIVISION.get()) {
            NetworkHandler.INSTANCE.sendToServer((Object)new WitherDashPacket(player.m_20148_(), player.m_20154_(), wData.MAX_SPEED));
            WitherDash.getInstance().activateClientAbility(player);
            SoundManager.playDashSound(player);
        }
    }

    public boolean getDashActive(Player player) {
        WitherPlayerDataSets.WitherDashPlayerData data = this.getPlayerData(player);
        return data.isDashActive;
    }

    public boolean getIgnoreCollide(Player player) {
        WitherPlayerDataSets.WitherDashPlayerData data = this.getPlayerData(player);
        return data.canIgnoreCollide;
    }

    @Override
    public void triggerAbility(ServerPlayer serverPlayer) {
        this.activateAbility(serverPlayer);
    }

    @Override
    public void activateAbility(ServerPlayer serverPlayer) {
        WitherPlayerDataSets.WitherDashPlayerData data = this.getPlayerData((Player)serverPlayer);
        if (data.abilityCooldown <= data.getMAX_COOLDOWN() / (Integer)EpicFightCombatFormsCommon.ABILITY1_COOLDOWN_DIVISION.get()) {
            serverPlayer.getCapability(EpicFightCapabilities.CAPABILITY_ENTITY).ifPresent(cap -> {
                if (cap instanceof PlayerPatch) {
                    PlayerPatch playerPatch = (PlayerPatch)cap;
                    playerPatch.getAnimator().playAnimation(WOMAnimations.SHADOWSTEP_FORWARD.get(), 0.0f);
                    data.abilityCooldown += data.getMAX_COOLDOWN() / (Integer)EpicFightCombatFormsCommon.ABILITY1_COOLDOWN_DIVISION.get();
                    data.isDashActive = true;
                }
            });
            Direction dashDirection = serverPlayer.m_6374_();
            BlockPos playerPos = serverPlayer.m_20183_();
            Level world = serverPlayer.m_9236_();
            data.canIgnoreCollide = serverPlayer.m_9236_().m_8055_(playerPos.m_5484_(dashDirection, 10)).m_60795_();
        }
    }

    public void activateClientAbility(Player player) {
        WitherPlayerDataSets.WitherDashPlayerData data = this.getPlayerData(player);
        if (ClientWitherData.getCooldown() <= data.getMAX_COOLDOWN() / (Integer)EpicFightCombatFormsCommon.ABILITY1_COOLDOWN_DIVISION.get()) {
            player.getCapability(EpicFightCapabilities.CAPABILITY_ENTITY).ifPresent(cap -> {
                if (cap instanceof PlayerPatch) {
                    PlayerPatch playerPatch = (PlayerPatch)cap;
                    playerPatch.getAnimator().playAnimationInstantly(WOMAnimations.SHADOWSTEP_FORWARD.get());
                }
            });
        }
    }

    @Override
    public void deactivateAbilityOptional(ServerPlayer serverPlayer) {
    }

    @Override
    public void decrementCooldown(Player player) {
        WitherPlayerDataSets.WitherMinionPlayerData mData = this.getOrCreateMinionPlayerData(player);
        if (this.isAbilityChosenOrEquipped(player) && !mData.areMinionsActive) {
            this.fillPerSecondCooldown(player);
        }
    }

    @Override
    public void tickServerAbilityData(ServerPlayer player) {
        WitherPlayerDataSets.WitherDashPlayerData data = this.getPlayerData((Player)player);
        AbilityManager.PlayerAbilityData abilityData = AbilityManager.getInstance().getPlayerAbilityData((Player)player);
        if (abilityData.chosenAbility1.name().equals(this.getName())) {
            WitherDash.getInstance().decrementCooldown((Player)player);
            player.getCapability(EpicFightCapabilities.CAPABILITY_ENTITY).ifPresent(cap -> {
                LivingEntityPatch livingEntityPatch;
                if (cap instanceof LivingEntityPatch && (livingEntityPatch = (LivingEntityPatch)cap) instanceof PlayerPatch) {
                    PlayerPatch playerPatch = (PlayerPatch)livingEntityPatch;
                    if (data.isDashActive && playerPatch.getServerAnimator().animationPlayer.getAnimation().getRealAnimation() != WOMAnimations.SHADOWSTEP_FORWARD) {
                        data.isDashActive = false;
                        data.canIgnoreCollide = false;
                    }
                }
            });
            this.syncDataToClient(player);
        }
    }

    @Override
    public void tickClientAbilityData(Player player) {
    }

    @Override
    public void syncDataToClient(ServerPlayer player) {
        WitherPlayerDataSets.WitherDashPlayerData data = this.getPlayerData((Player)player);
        if (this.isAbilityChosenOrEquipped((Player)player)) {
            NetworkHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> player), (Object)new SyncWitherDataPacket(data.abilityCooldown, data.isDashActive, data.canIgnoreCollide));
        }
    }

    public boolean isAbilityChosenOrEquipped(Player player) {
        AbilityManager.PlayerAbilityData abilityData = AbilityManager.getInstance().getPlayerAbilityData(player);
        return abilityData.chosenAbility1.name().equals(this.getName());
    }

    @Override
    public void playSound(Player player) {
        player.m_9236_().m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12500_, SoundSource.PLAYERS, 1.0f, 1.0f);
    }

    @Override
    public void playSound2(Player player) {
    }

    public void activatePause(Player player) {
        WitherPlayerDataSets.WitherDashPlayerData data = this.getPlayerData(player);
        data.isPauseActive = true;
        player.m_9236_().m_5594_(null, player.m_20183_(), SoundEvents.f_12317_, SoundSource.PLAYERS, 1.0f, 1.0f);
        player.m_20256_(Vec3.f_82478_);
        player.f_19812_ = true;
    }

    public void tickPause(Player player) {
        WitherPlayerDataSets.WitherDashPlayerData data = this.getPlayerData(player);
        if (data.isPauseActive) {
            player.m_7292_(new MobEffectInstance(MobEffects.f_19619_, 5, 1, false, false));
            player.m_7292_(new MobEffectInstance(MobEffects.f_19620_, 5, -1, false, false));
            player.m_20256_(Vec3.f_82478_);
        }
    }

    public void activateDash(Player player, Vec3 dashDirection, double dashSpeed) {
        WitherPlayerDataSets.WitherDashPlayerData data = this.getPlayerData(player);
        data.isPauseActive = false;
        data.isDashActive = true;
        data.initialPosition = player.m_20182_();
        data.distanceTraveled = 0.0;
        data.dashTicksRemaining = data.MAX_DASH_TICKS;
        data.dashDirection = dashDirection.m_82541_();
        data.currentSpeed = Math.min(dashSpeed, data.MAX_SPEED);
        player.m_9236_().m_5594_(null, player.m_20183_(), SoundEvents.f_12500_, SoundSource.PLAYERS, 1.0f, 1.0f);
        player.m_20256_(data.dashDirection.m_82490_(data.currentSpeed));
        player.f_19812_ = true;
        data.abilityCooldown += data.getMAX_COOLDOWN() / 2;
    }

    private void movePlayerThroughBlocks(Player player, Vec3 motion) {
        double newX = player.m_20185_() + motion.f_82479_;
        double newY = player.m_20186_() + motion.f_82480_;
        double newZ = player.m_20189_() + motion.f_82481_;
        BlockPos newBlockPos = new BlockPos((int)newX, (int)newY, (int)newZ);
        BlockState blockState = player.m_9236_().m_8055_(newBlockPos);
        if (!blockState.m_60795_()) {
            newY = Math.ceil(newY);
        }
        player.m_6034_(newX, newY, newZ);
    }

    public void updateDash(Player player) {
        WitherPlayerDataSets.WitherDashPlayerData data = this.getPlayerData(player);
        if (player.m_9236_().f_46443_ && data.isDashActive) {
            double remainingDistance = data.MAX_DISTANCE - data.distanceTraveled;
            if (remainingDistance < data.DECELERATION_DISTANCE) {
                double decelerationFactor = remainingDistance / data.DECELERATION_DISTANCE;
                data.currentSpeed = data.MAX_SPEED * decelerationFactor;
            }
            Vec3 motion = data.dashDirection.m_82490_(data.currentSpeed);
            this.movePlayerThroughBlocks(player, motion);
            player.m_20256_(motion);
            player.m_6478_(MoverType.SELF, motion);
            Vec3 newPosition = player.m_20182_();
            data.distanceTraveled = data.initialPosition.m_82554_(newPosition);
            --data.dashTicksRemaining;
            if (data.distanceTraveled >= data.MAX_DISTANCE || data.dashTicksRemaining <= 0) {
                this.stopDash(player);
            }
        }
    }

    private void stopDash(Player player) {
        WitherPlayerDataSets.WitherDashPlayerData data = this.getPlayerData(player);
        data.isDashActive = false;
        this.ensurePlayerStopped(player);
        data.distanceTraveled = 0.0;
        data.initialPosition = null;
        data.dashDirection = null;
        data.dashTicksRemaining = 0;
    }

    private void ensurePlayerStopped(Player player) {
        player.m_20256_(Vec3.f_82478_);
        player.f_19789_ = 0.0f;
        BlockPos playerPos = player.m_20183_();
        BlockState blockState = player.m_9236_().m_8055_(playerPos);
        if (!blockState.m_60795_()) {
            double newY = Math.ceil(player.m_20186_());
            player.m_6034_(player.m_20185_(), newY, player.m_20189_());
        }
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            serverPlayer.f_8906_.m_9774_(player.m_20185_(), player.m_20186_(), player.m_20189_(), player.m_146908_(), player.m_146909_());
            ServerLevel targetLevel = serverPlayer.m_284548_();
            double newX = serverPlayer.m_20185_();
            double newY = serverPlayer.m_20186_();
            double newZ = serverPlayer.m_20189_();
            Set relativeMovements = Set.of();
            float newYaw = serverPlayer.m_146908_();
            float newPitch = serverPlayer.m_146909_();
            serverPlayer.m_264318_(targetLevel, newX, newY, newZ, relativeMovements, newYaw, newPitch);
        }
    }

    @Mod.EventBusSubscriber(modid="kenjiscombatforms", bus=Mod.EventBusSubscriber.Bus.FORGE)
    public static class ServerForgeEvents {
        @SubscribeEvent
        public static void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent event) {
            Player player = event.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                WitherDash.getInstance().getPlayerData((Player)serverPlayer);
                WitherDash.getInstance().stopDash((Player)serverPlayer);
            }
            Player player2 = event.getEntity();
            WitherDash.getInstance().stopDash(player2);
        }

        @SubscribeEvent
        public static void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
            Player player = event.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                WitherDash.getInstance().setAbilityCooldown((Player)serverPlayer);
            }
        }

        @SubscribeEvent
        public static void onPlayerLogout(PlayerEvent.PlayerLoggedOutEvent event) {
            WitherDash.getInstance().playerDataMap.remove(event.getEntity().m_20148_());
        }

        @SubscribeEvent
        public static void onPlayerClone(PlayerEvent.Clone event) {
            Player player = event.getOriginal();
            if (player instanceof ServerPlayer) {
                ServerPlayer originalPlayer = (ServerPlayer)player;
                player = event.getEntity();
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                }
            }
        }

        @SubscribeEvent
        public void onPlayerTick(TickEvent.PlayerTickEvent event) {
            if (event.phase == TickEvent.Phase.END) {
                Player player = event.player;
                WitherPlayerDataSets.WitherDashPlayerData witherDashPlayerData = WitherDash.getInstance().getPlayerData(player);
            }
        }
    }
}

