/*
 * Decompiled with CFR 0.152.
 */
package net.kenji.kenjiscombatforms.api.powers.WitherPowers;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.UUID;
import net.kenji.kenjiscombatforms.api.capabilities.ExtraContainerCapability;
import net.kenji.kenjiscombatforms.api.handlers.ClientEventHandler;
import net.kenji.kenjiscombatforms.api.handlers.CommonEventHandler;
import net.kenji.kenjiscombatforms.api.handlers.power_data.WitherPlayerDataSets;
import net.kenji.kenjiscombatforms.api.interfaces.ability.Ability;
import net.kenji.kenjiscombatforms.api.interfaces.ability.AbilityDamageGainStrategy;
import net.kenji.kenjiscombatforms.api.interfaces.ability.AbstractAbilityData;
import net.kenji.kenjiscombatforms.api.managers.AbilityManager;
import net.kenji.kenjiscombatforms.api.managers.client_data.ClientFistData;
import net.kenji.kenjiscombatforms.config.EpicFightCombatFormsCommon;
import net.kenji.kenjiscombatforms.entity.custom.noAiEntities.EnderEntity;
import net.kenji.kenjiscombatforms.event.CommonFunctions;
import net.kenji.kenjiscombatforms.item.custom.base_items.BaseFistClass;
import net.kenji.kenjiscombatforms.item.custom.fist_forms.WitherFormItem;
import net.kenji.kenjiscombatforms.network.NetworkHandler;
import net.kenji.kenjiscombatforms.network.capability.SyncNBTPacket;
import net.kenji.kenjiscombatforms.network.capability.SyncRemovedNBTPacket;
import net.kenji.kenjiscombatforms.network.fist_forms.client_data.SyncClientFinalAbilitesPacket;
import net.kenji.kenjiscombatforms.network.particle_packets.LargeSmokeParticlesTickPacket;
import net.kenji.kenjiscombatforms.network.voidform.ClientVoidData;
import net.kenji.kenjiscombatforms.network.witherform.ClientWitherData;
import net.kenji.kenjiscombatforms.network.witherform.ability3.SyncWitherData3Packet;
import net.kenji.kenjiscombatforms.network.witherform.ability3.ToggleWitherFormPacket;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.util.thread.EffectiveSide;
import net.minecraftforge.network.PacketDistributor;
import reascer.wom.gameasset.WOMAnimations;
import reascer.wom.gameasset.WOMSkills;
import yesman.epicfight.gameasset.EpicFightSkills;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.skill.SkillSlot;
import yesman.epicfight.skill.SkillSlots;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;

public class WitherFormAbility
implements Ability {
    private static final Map<UUID, Skill> skillCache = new HashMap<UUID, Skill>();
    private final WitherPlayerDataSets dataSets = WitherPlayerDataSets.getInstance();
    private final Map<UUID, WitherPlayerDataSets.WitherFormPlayerData> playerDataMap;
    private final CommonFunctions dataHandlers;
    private Entity witherEntity;
    private static final WitherFormAbility INSTANCE = new WitherFormAbility();
    Skill currentDodgeSkill;

    @Override
    public String getName() {
        return AbilityManager.AbilityOption3.WITHER_FINAL.name();
    }

    private WitherPlayerDataSets.WitherDashPlayerData getOrCreateDashPlayerData(Player player) {
        return this.dataSets.getOrCreateDashPlayerData(player);
    }

    private WitherPlayerDataSets.SoulDriftPlayerData getOrCreateSoulDriftPlayerData(Player player) {
        return this.dataSets.getOrCreateSoulDriftPlayerData(player);
    }

    public WitherPlayerDataSets.WitherFormPlayerData getPlayerData(Player player) {
        return (WitherPlayerDataSets.WitherFormPlayerData)this.getAbilityData(player);
    }

    public WitherFormAbility() {
        this.playerDataMap = this.dataSets.A3playerDataMap;
        this.dataHandlers = CommonFunctions.getInstance();
    }

    public static WitherFormAbility getInstance() {
        return INSTANCE;
    }

    public boolean getDashActive(Player player) {
        WitherPlayerDataSets.WitherFormPlayerData data = this.getPlayerData(player);
        return data.isDashActive;
    }

    public int getAbilityCooldown(ServerPlayer player) {
        return this.getPlayerData((Player)player).abilityCooldown;
    }

    public Map<UUID, WitherPlayerDataSets.WitherFormPlayerData> getPlayerDataMap() {
        return this.playerDataMap;
    }

    public void setAbilityCooldown(ServerPlayer player, int cooldown) {
        this.getPlayerData((Player)player).abilityCooldown = Math.min(Math.max(cooldown, 0), this.getPlayerData((Player)player).getMAX_COOLDOWN());
    }

    @Override
    public AbstractAbilityData getAbilityData(Player player) {
        return this.dataSets.getOrCreateWitherFormPlayerData(player);
    }

    @Override
    public void fillPerSecondCooldown(Player player) {
        WitherPlayerDataSets.WitherFormPlayerData data = this.getPlayerData(player);
        data.tickCount = this.dataHandlers.getTickCount(data.tickCount);
        data.abilityCooldown = this.dataHandlers.decreaseCooldown(data.abilityCooldown, data.tickCount);
    }

    @Override
    public void drainPerSecondCooldown(Player player) {
        WitherPlayerDataSets.WitherFormPlayerData data = this.getPlayerData(player);
        data.tickCount = this.dataHandlers.getTickCount(data.tickCount);
        data.abilityCooldown = this.dataHandlers.increaseCooldown(data.abilityCooldown, data.tickCount);
    }

    @Override
    public boolean getAbilityActive(Player player) {
        return this.getAbilityData(player).isAbilityActive();
    }

    @Override
    public void sendPacketToServer(Player player) {
        NetworkHandler.INSTANCE.sendToServer((Object)new ToggleWitherFormPacket());
        if (!ClientEventHandler.getInstance().getAreFinalsActive()) {
            WitherFormAbility.getInstance().jumpUp(player);
        }
        WitherFormAbility.getInstance().spawnParticles(player);
    }

    public void jumpUp(Player player) {
        WitherPlayerDataSets.WitherFormPlayerData data = this.getPlayerData(player);
        if (ClientVoidData.getCooldown3() == 0) {
            Vec3 velocity = player.m_20184_();
            player.m_20334_(velocity.f_82479_, 0.5, velocity.f_82481_);
        }
    }

    public boolean isSkillActive(PlayerPatch<?> playerPatch) {
        return playerPatch.getSkill((SkillSlot)SkillSlots.DODGE).isActivated();
    }

    public static Skill getStoredSkill(Player player) {
        return skillCache.getOrDefault(player.m_20148_(), EpicFightSkills.STEP);
    }

    private void setCurrentDodgeSkill(PlayerPatch playerPatch, Skill skill, CompoundTag nbt) {
        this.currentDodgeSkill = skill;
        if (this.getSkill(playerPatch) != null) {
            nbt.m_128359_("storedDodgeSkill", Objects.requireNonNull(this.getSkill(playerPatch)).getRegistryName().toString());
        }
    }

    private Skill getCurrentDodgeSkill() {
        return this.currentDodgeSkill;
    }

    @Override
    public void triggerAbility(ServerPlayer serverPlayer) {
        WitherPlayerDataSets.WitherFormPlayerData data = this.getPlayerData((Player)serverPlayer);
        serverPlayer.getCapability(EpicFightCapabilities.CAPABILITY_ENTITY).ifPresent(cap -> {
            if (cap instanceof PlayerPatch) {
                PlayerPatch playerPatch = (PlayerPatch)cap;
                Skill skillToSet = WOMSkills.SHADOWSTEP;
                CompoundTag nbt = serverPlayer.getPersistentData();
                if (!data.isWitherActive && data.abilityCooldown == 0) {
                    this.setCurrentDodgeSkill(playerPatch, this.getSkill(playerPatch), nbt);
                    this.activateAbility(serverPlayer);
                    this.jumpUp((Player)serverPlayer);
                    this.setSkill(playerPatch, skillToSet);
                    data.hasPlayedSound = false;
                } else if (data.isWitherActive) {
                    this.deactivateAbilityOptional(serverPlayer);
                    this.restoreItem((Player)serverPlayer);
                    this.setSkill(playerPatch, this.getCurrentDodgeSkill());
                    nbt.m_128473_("storedDodgeSkill");
                }
            }
        });
    }

    private void setSkill(PlayerPatch<?> playerPatch, Skill skillToSet) {
        playerPatch.getSkill((SkillSlot)SkillSlots.DODGE).setSkill(skillToSet);
    }

    private Skill getSkill(PlayerPatch<?> playerPatch) {
        if (playerPatch.getSkill((SkillSlot)SkillSlots.DODGE) != null) {
            return playerPatch.getSkill((SkillSlot)SkillSlots.DODGE).getSkill();
        }
        return null;
    }

    @Override
    public void activateAbility(ServerPlayer serverPlayer) {
        WitherPlayerDataSets.WitherFormPlayerData data = this.getPlayerData((Player)serverPlayer);
        AbilityManager.PlayerAbilityData abilityData = AbilityManager.getInstance().getPlayerAbilityData((Player)serverPlayer);
        data.isWitherActive = true;
        abilityData.ability4 = AbilityManager.AbilityOption4.WITHER_MINIONS;
        abilityData.ability5 = AbilityManager.AbilityOption5.WITHER_IMPLODE;
        this.playSound((Player)serverPlayer);
        this.setFormItem((Player)serverPlayer);
        this.syncDataToClient(serverPlayer);
    }

    private void setFormItem(Player player) {
        int originalSlot = CommonEventHandler.getInstance().getOriginalSlot(player);
        int selectedSlot = player.m_150109_().f_35977_;
        ItemStack currentItem = player.m_150109_().m_8020_(selectedSlot);
        player.getCapability(ExtraContainerCapability.EXTRA_CONTAINER_CAP).ifPresent(container -> {
            ItemStack storedItem = container.getStoredItem();
            if (storedItem.m_41619_()) {
                if (!(currentItem.m_41720_() instanceof BaseFistClass)) {
                    CommonEventHandler.getInstance().setStoredItemNBT(player, currentItem);
                    container.setStoredItem(currentItem);
                }
                player.m_150109_().m_6836_(selectedSlot, ItemStack.f_41583_);
                player.m_150109_().m_6836_(selectedSlot, WitherFormItem.getInstance().m_7968_());
                CommonEventHandler.getInstance().setOriginalSlot(player, selectedSlot);
                container.setOriginalSlot(selectedSlot);
                NetworkHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)player), (Object)new SyncNBTPacket(storedItem, originalSlot));
                player.m_150109_().m_6596_();
                player.m_5496_(SoundEvents.f_12317_, 1.0f, 1.0f);
            }
        });
    }

    private void restoreItem(Player player) {
        int selectedSlot = player.m_150109_().f_35977_;
        ItemStack currentItem = player.m_150109_().m_8020_(selectedSlot);
        player.getCapability(ExtraContainerCapability.EXTRA_CONTAINER_CAP).ifPresent(container -> {
            ItemStack storedItem = container.getStoredItem();
            if (!storedItem.m_41619_()) {
                player.m_150109_().m_6836_(CommonEventHandler.getInstance().getOriginalSlot(player), container.getStoredItem());
                container.setStoredItem(ItemStack.f_41583_);
            } else {
                player.m_150109_().m_6836_(CommonEventHandler.getInstance().getOriginalSlot(player), ItemStack.f_41583_);
            }
            NetworkHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)player), (Object)new SyncRemovedNBTPacket(storedItem, CommonEventHandler.getInstance().getOriginalSlot(player)));
            container.setOriginalSlot(-1);
            player.m_5496_(SoundEvents.f_12317_, 1.0f, 1.0f);
        });
    }

    public boolean getWitherFormActive(Player player) {
        WitherPlayerDataSets.WitherFormPlayerData data = this.getPlayerData(player);
        return data.isWitherActive;
    }

    @Override
    public void deactivateAbilityOptional(ServerPlayer serverPlayer) {
        WitherPlayerDataSets.WitherFormPlayerData data = this.getPlayerData((Player)serverPlayer);
        data.isWitherActive = false;
        serverPlayer.m_21195_(MobEffects.f_19609_);
        serverPlayer.m_21195_(MobEffects.f_19620_);
        Entity existingWither = data.playerWitherMap.remove(serverPlayer.m_20148_());
        if (existingWither != null) {
            existingWither.m_142687_(Entity.RemovalReason.DISCARDED);
        }
        this.syncDataToClient(serverPlayer);
    }

    @Override
    public void decrementCooldown(Player player) {
        WitherPlayerDataSets.WitherFormPlayerData data = this.playerDataMap.computeIfAbsent(player.m_20148_(), k -> new WitherPlayerDataSets.WitherFormPlayerData());
        AbilityManager.PlayerAbilityData abilityData = AbilityManager.getInstance().getPlayerAbilityData(player);
        if (this.isAbilityChosenOrEquipped(player) && EffectiveSide.get() == LogicalSide.SERVER && player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (data.abilityCooldown > 0 && !data.isWitherActive && !((Boolean)EpicFightCombatFormsCommon.ABILITY3_COMBAT_MODE.get()).booleanValue()) {
                WitherPlayerDataSets.WitherDashPlayerData sData = this.getOrCreateDashPlayerData((Player)serverPlayer);
                WitherPlayerDataSets.SoulDriftPlayerData bData = this.getOrCreateSoulDriftPlayerData((Player)serverPlayer);
                if (abilityData.chosenFinal == AbilityManager.AbilityOption3.WITHER_FINAL) {
                    this.fillPerSecondCooldown(player);
                }
            }
            if (data.abilityCooldown < data.getMAX_COOLDOWN() && data.isWitherActive) {
                this.drainPerSecondCooldown(player);
            }
            if (data.abilityCooldown >= data.getMAX_COOLDOWN() && data.isWitherActive) {
                this.deactivateAbilityOptional(serverPlayer);
                Entity existingShadow = data.playerWitherMap.remove(player.m_20148_());
                if (existingShadow != null) {
                    existingShadow.m_142687_(Entity.RemovalReason.DISCARDED);
                }
                if (!data.hasPlayedSound) {
                    data.hasPlayedSound = true;
                    this.playSound(player);
                }
            }
        }
    }

    @Override
    public void tickServerAbilityData(ServerPlayer player) {
        WitherPlayerDataSets.WitherFormPlayerData data = this.getPlayerData((Player)player);
        AbilityManager.PlayerAbilityData abilityData = AbilityManager.getInstance().getPlayerAbilityData((Player)player);
        if (AbilityManager.getInstance().getPlayerAbilityData((Player)player).chosenFinal.name().equals(this.getName())) {
            player.getCapability(EpicFightCapabilities.CAPABILITY_ENTITY).ifPresent(cap -> {
                if (cap instanceof PlayerPatch) {
                    PlayerPatch playerPatch = (PlayerPatch)cap;
                    if (abilityData.chosenFinal.name().equals(this.getName())) {
                        WitherFormAbility.getInstance().decrementCooldown((Player)player);
                    }
                    this.syncDataToClient(player);
                    if (data.isWitherActive) {
                        data.isDashActive = playerPatch.getServerAnimator().animationPlayer.getAnimation().getRealAnimation() == WOMAnimations.SHADOWSTEP_FORWARD;
                        player.m_7292_(new MobEffectInstance(MobEffects.f_19620_, 5, -1, false, false));
                        NetworkHandler.INSTANCE.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> player), (Object)new LargeSmokeParticlesTickPacket(player.m_20185_(), player.m_20186_(), player.m_20189_(), player.m_20145_()));
                    }
                }
            });
        }
    }

    public void upDown(Player player, boolean sneak, boolean jump) {
        Vec3 velocity = player.m_20184_();
        if (jump) {
            player.m_20334_(velocity.f_82479_, 0.2, velocity.f_82481_);
        }
        if (sneak) {
            player.m_20334_(velocity.f_82479_, -0.2, velocity.f_82481_);
        }
    }

    @Override
    public void tickClientAbilityData(Player player) {
        WitherPlayerDataSets.WitherFormPlayerData data = WitherFormAbility.getInstance().playerDataMap.computeIfAbsent(player.m_20148_(), k -> new WitherPlayerDataSets.WitherFormPlayerData());
        if (ClientFistData.getChosenAbility3().name().equals(this.getName())) {
            if (ClientWitherData.getIsWitherActive()) {
                // empty if block
            }
            if (!ClientWitherData.getIsWitherActive()) {
                // empty if block
            }
        }
    }

    @Override
    public void syncDataToClient(ServerPlayer player) {
        WitherPlayerDataSets.WitherFormPlayerData data = this.getPlayerData((Player)player);
        AbilityManager.PlayerAbilityData abilityData = AbilityManager.getInstance().getPlayerAbilityData((Player)player);
        NetworkHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> player), (Object)new SyncWitherData3Packet(data.abilityCooldown, data.isWitherActive, data.isDashActive, player.m_20148_()));
        NetworkHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> player), (Object)new SyncClientFinalAbilitesPacket(abilityData.ability4, abilityData.ability5));
    }

    public boolean isAbilityChosenOrEquipped(Player player) {
        AbilityManager.PlayerAbilityData abilityData = AbilityManager.getInstance().getPlayerAbilityData(player);
        return abilityData.chosenFinal.name().equals(this.getName());
    }

    private Entity getNearestEntity(Player player) {
        double searchRadius = 10.0;
        AABB searchBox = player.m_20191_().m_82400_(searchRadius);
        List nearbyEntities = player.m_9236_().m_45933_((Entity)player, searchBox);
        Entity closestEntity = null;
        double closestDistanceSq = Double.MAX_VALUE;
        for (Entity entity : nearbyEntities) {
            double distanceSq;
            if (entity instanceof EnderEntity || !((distanceSq = player.m_20280_(entity)) < closestDistanceSq)) continue;
            closestDistanceSq = distanceSq;
            closestEntity = entity;
        }
        return closestEntity;
    }

    @Override
    public void playSound(Player player) {
        player.m_9236_().m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12554_, SoundSource.PLAYERS, 1.0f, 1.0f);
    }

    @Override
    public void playSound2(Player player) {
    }

    @OnlyIn(value=Dist.CLIENT)
    public void spawnParticles(Player player) {
        int currentVoidCooldown = ClientVoidData.getCooldown3();
        BlockParticleOption whiteFallingDust = new BlockParticleOption(ParticleTypes.f_123814_, Blocks.f_50041_.m_49966_());
        Random random = new Random();
        int particleCount = 100;
        double x = player.m_20185_();
        double y = player.m_20186_();
        double z = player.m_20189_();
        for (int i = 0; i < particleCount; ++i) {
            double offsetX = (random.nextDouble() - 0.5) * 2.0;
            double offsetY = (random.nextDouble() - 0.5) * 2.0;
            double offsetZ = (random.nextDouble() - 0.5) * 2.0;
            double velocityX = (random.nextDouble() - 0.5) * 0.5;
            double velocityY = random.nextDouble() * 0.5;
            double velocityZ = (random.nextDouble() - 0.5) * 0.5;
            player.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123760_, x + offsetX, y + 1.0 + offsetY, z + offsetZ, velocityX, velocityY, velocityZ);
        }
    }

    public static class CurrentDamageGainStrategy
    implements AbilityDamageGainStrategy {
        @Override
        public void fillDamageCooldown(Player player) {
            WitherPlayerDataSets.WitherFormPlayerData data = WitherFormAbility.getInstance().playerDataMap.computeIfAbsent(player.m_20148_(), k -> new WitherPlayerDataSets.WitherFormPlayerData());
            if (((Boolean)EpicFightCombatFormsCommon.ABILITY3_COMBAT_MODE.get()).booleanValue()) {
                if (!data.isAbilityActive()) {
                    if (data.abilityCooldown > 0) {
                        data.abilityCooldown -= ((Integer)EpicFightCombatFormsCommon.COMBAT_MODE_GAIN_AMOUNT.get()).intValue();
                    }
                } else if (data.abilityCooldown > 0) {
                    data.abilityCooldown -= (Integer)EpicFightCombatFormsCommon.COMBAT_MODE_GAIN_AMOUNT.get() / 2;
                }
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    WitherFormAbility.getInstance().syncDataToClient(serverPlayer);
                }
            }
        }
    }

    @Mod.EventBusSubscriber(modid="kenjiscombatforms", bus=Mod.EventBusSubscriber.Bus.FORGE)
    public static class ServerForgeEvents {
        @SubscribeEvent
        public static void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent event) {
            System.out.println("Player Joined");
            Player player = event.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                WitherFormAbility.getInstance().getPlayerData((Player)serverPlayer);
                WitherFormAbility.getInstance().syncDataToClient(serverPlayer);
                WitherFormAbility.getInstance().deactivateAbilityOptional(serverPlayer);
            }
        }

        @SubscribeEvent
        public static void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
            Player player;
            Entity existingDecoy = WitherFormAbility.getInstance().getPlayerData((Player)event.getEntity()).playerWitherMap.remove(event.getEntity().m_20148_());
            if (existingDecoy != null) {
                existingDecoy.m_142687_(Entity.RemovalReason.DISCARDED);
            }
            if ((player = event.getEntity()) instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                WitherFormAbility.getInstance().setAbilityCooldown(serverPlayer, WitherFormAbility.getInstance().getPlayerData((Player)serverPlayer).getMAX_COOLDOWN());
                WitherFormAbility.getInstance().syncDataToClient(serverPlayer);
            }
        }

        @SubscribeEvent
        public static void onPlayerLogout(PlayerEvent.PlayerLoggedOutEvent event) {
            Entity existingDecoy = WitherFormAbility.getInstance().getPlayerData((Player)event.getEntity()).playerWitherMap.remove(event.getEntity().m_20148_());
            if (existingDecoy != null) {
                existingDecoy.m_142687_(Entity.RemovalReason.DISCARDED);
            }
            WitherFormAbility.getInstance().playerDataMap.remove(event.getEntity().m_20148_());
        }

        @SubscribeEvent
        public static void onPlayerClone(PlayerEvent.Clone event) {
            Player player = event.getOriginal();
            if (player instanceof ServerPlayer) {
                ServerPlayer originalPlayer = (ServerPlayer)player;
                player = event.getEntity();
                if (player instanceof ServerPlayer) {
                    ServerPlayer newPlayer = (ServerPlayer)player;
                    WitherPlayerDataSets.WitherFormPlayerData originalData = WitherFormAbility.getInstance().getPlayerData((Player)originalPlayer);
                    WitherPlayerDataSets.WitherFormPlayerData newData = WitherFormAbility.getInstance().getPlayerData((Player)newPlayer);
                    newData.abilityCooldown = originalData.abilityCooldown;
                    WitherFormAbility.getInstance().syncDataToClient(newPlayer);
                }
            }
        }
    }
}

