/*
 * Decompiled with CFR 0.152.
 */
package net.kenji.kenjiscombatforms.api.powers.WitherPowers;

import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.kenji.kenjiscombatforms.api.handlers.power_data.WitherPlayerDataSets;
import net.kenji.kenjiscombatforms.api.interfaces.ability.AbstractAbilityData;
import net.kenji.kenjiscombatforms.api.interfaces.ability.FinalAbility;
import net.kenji.kenjiscombatforms.api.managers.AbilityManager;
import net.kenji.kenjiscombatforms.event.CommonFunctions;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;

public class WitherFormDashAbility
implements FinalAbility {
    private final WitherPlayerDataSets dataSets = WitherPlayerDataSets.getInstance();
    private final Map<UUID, WitherPlayerDataSets.WitherFormDashPlayerData> playerDataMap;
    private static final WitherFormDashAbility INSTANCE = new WitherFormDashAbility();
    private final CommonFunctions dataHandlers;

    @Override
    public String getName() {
        return AbilityManager.AltAbilityOption.WITHER_DASH.name();
    }

    @Override
    public String getFinalAbilityName() {
        return AbilityManager.AbilityOption3.WITHER_FINAL.name();
    }

    public WitherPlayerDataSets.WitherFormDashPlayerData getPlayerData(Player player) {
        return (WitherPlayerDataSets.WitherFormDashPlayerData)this.getAbilityData(player);
    }

    public WitherPlayerDataSets.WitherFormPlayerData getOrCreateWitherFormPlayerData(Player player) {
        return this.dataSets.getOrCreateWitherFormPlayerData(player);
    }

    public WitherFormDashAbility() {
        this.playerDataMap = this.dataSets.A6playerDataMap;
        this.dataHandlers = CommonFunctions.getInstance();
    }

    public static WitherFormDashAbility getInstance() {
        return INSTANCE;
    }

    public float getAbilityCooldown(Player player) {
        return this.getPlayerData((Player)player).abilityCooldown;
    }

    public void setAbilityCooldown(Player player) {
        this.getPlayerData((Player)player).abilityCooldown += this.getPlayerData(player).getMAX_COOLDOWN() / 2;
    }

    @Override
    public AbstractAbilityData getAbilityData(Player player) {
        return this.dataSets.getOrCreateWitherFormDashPlayerData(player);
    }

    @Override
    public boolean getFinalAbilityActive(Player player) {
        return false;
    }

    @Override
    public boolean getAbilityActive(Player player) {
        return this.getAbilityData(player).isAbilityActive();
    }

    @Override
    public void fillPerSecondCooldown(Player player) {
        WitherPlayerDataSets.WitherFormDashPlayerData data = this.getPlayerData(player);
        int cooldown = data.abilityCooldown;
        if (cooldown > 0) {
            data.tickCount = this.dataHandlers.getTickCount(data.tickCount);
            data.abilityCooldown = this.dataHandlers.decreaseCooldown(data.abilityCooldown, data.tickCount);
        }
    }

    @Override
    public void drainPerSecondCooldown(Player player) {
    }

    @Override
    public void sendPacketToServer(Player player) {
    }

    @Override
    public void triggerAbility(ServerPlayer serverPlayer) {
        long currentTime = System.currentTimeMillis();
        serverPlayer.getCapability(EpicFightCapabilities.CAPABILITY_ENTITY).ifPresent(cap -> {
            PlayerPatch playerPatch;
            if (!(cap instanceof PlayerPatch) || !((playerPatch = (PlayerPatch)cap).getStamina() >= playerPatch.getMaxStamina()) || this.getPlayerData((Player)serverPlayer).abilityCooldown <= this.getPlayerData((Player)serverPlayer).getMAX_COOLDOWN()) {
                // empty if block
            }
        });
    }

    @Override
    public void activateAbility(ServerPlayer serverPlayer) {
    }

    @Override
    public void deactivateAbilityOptional(ServerPlayer serverPlayer) {
    }

    @Override
    public void decrementCooldown(Player player) {
        WitherPlayerDataSets.WitherFormPlayerData wData = this.dataSets.getOrCreateWitherFormPlayerData(player);
        WitherPlayerDataSets.WitherFormDashPlayerData eData = this.getPlayerData(player);
        long currentTime = System.currentTimeMillis();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            serverPlayer.getCapability(EpicFightCapabilities.CAPABILITY_ENTITY).ifPresent(cap -> {
                PlayerPatch playerPatch;
                if (cap instanceof PlayerPatch && (playerPatch = (PlayerPatch)cap).getStamina() >= playerPatch.getMaxStamina() && this.getPlayerData((Player)serverPlayer).abilityCooldown <= this.getPlayerData((Player)serverPlayer).getMAX_COOLDOWN() && wData.isWitherActive && eData.abilityCooldown <= eData.getMAX_COOLDOWN()) {
                    this.fillPerSecondCooldown(player);
                }
            });
        }
    }

    @Override
    public void tickServerAbilityData(ServerPlayer player) {
        this.decrementCooldown((Player)player);
        this.updateDash((Player)player);
    }

    @Override
    public void tickClientAbilityData(Player player) {
    }

    @Override
    public void syncDataToClient(ServerPlayer player) {
    }

    @Override
    public void playSound(Player player) {
        player.m_9236_().m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12558_, SoundSource.PLAYERS, 0.8f, 0.8f);
    }

    @Override
    public void playSound2(Player player) {
    }

    public void activateDash(Player player, Vec3 dashDirection, double dashSpeed) {
        WitherPlayerDataSets.WitherFormDashPlayerData data = this.getPlayerData(player);
        WitherPlayerDataSets.WitherFormPlayerData wData = this.getOrCreateWitherFormPlayerData(player);
        data.isDashActive = true;
        data.initialPosition = player.m_20182_();
        data.distanceTraveled = 0.0;
        data.dashTicksRemaining = data.MAX_DASH_TICKS;
        data.dashDirection = dashDirection.m_82541_();
        data.currentSpeed = Math.min(dashSpeed, data.MAX_SPEED);
        player.m_20256_(data.dashDirection.m_82490_(data.currentSpeed));
        player.f_19812_ = true;
    }

    private void moveWitherEntityThroughBlocks(Player player, Vec3 motion) {
        WitherPlayerDataSets.WitherFormPlayerData wData = this.getOrCreateWitherFormPlayerData(player);
        double newX = player.m_20185_() + motion.f_82479_;
        double newY = player.m_20186_() + motion.f_82480_;
        double newZ = player.m_20189_() + motion.f_82481_;
        BlockPos newBlockPos = new BlockPos((int)newX, (int)newY, (int)newZ);
        BlockState blockState = player.m_9236_().m_8055_(newBlockPos);
        if (!blockState.m_60795_()) {
            newY = Math.ceil(newY);
        }
        player.m_6034_(newX, newY, newZ);
    }

    public void updateDash(Player player) {
        WitherPlayerDataSets.WitherFormDashPlayerData data = this.getPlayerData(player);
        WitherPlayerDataSets.WitherFormPlayerData wData = this.getOrCreateWitherFormPlayerData(player);
        if (data.isDashActive) {
            double remainingDistance = data.MAX_DISTANCE - data.distanceTraveled;
            if (remainingDistance < data.DECELERATION_DISTANCE) {
                double decelerationFactor = remainingDistance / data.DECELERATION_DISTANCE;
                data.currentSpeed = data.MAX_SPEED * decelerationFactor;
            }
            Vec3 motion = data.dashDirection.m_82490_(data.currentSpeed);
            this.moveWitherEntityThroughBlocks(player, motion);
            player.m_20256_(motion);
            player.m_6478_(MoverType.SELF, motion);
            Vec3 newPosition = player.m_20182_();
            data.distanceTraveled = data.initialPosition.m_82554_(newPosition);
            --data.dashTicksRemaining;
            if (data.distanceTraveled >= data.MAX_DISTANCE || data.dashTicksRemaining <= 0) {
                this.stopDash(player);
            }
        }
    }

    private void stopDash(Player player) {
        WitherPlayerDataSets.WitherFormDashPlayerData data = this.getPlayerData(player);
        WitherPlayerDataSets.WitherFormPlayerData wData = this.getOrCreateWitherFormPlayerData(player);
        data.isDashActive = false;
        this.ensureWitherStopped(player);
        data.distanceTraveled = 0.0;
        data.initialPosition = null;
        data.dashDirection = null;
        data.dashTicksRemaining = 0;
    }

    private void ensureWitherStopped(Player player) {
        WitherPlayerDataSets.WitherFormPlayerData wData = this.getOrCreateWitherFormPlayerData(player);
        player.m_20256_(Vec3.f_82478_);
        player.f_19789_ = 0.0f;
        BlockPos witherPos = player.m_20183_();
        BlockState blockState = player.m_9236_().m_8055_(witherPos);
        if (!blockState.m_60795_()) {
            double newY = Math.ceil(player.m_20186_());
            player.m_6034_(player.m_20185_(), newY, player.m_20189_());
        }
        ServerLevel targetLevel = (ServerLevel)player.m_9236_();
        double newX = player.m_20185_();
        double newY = player.m_20186_();
        double newZ = player.m_20189_();
        Set relativeMovements = Set.of();
        float newYaw = player.m_146908_();
        float newPitch = player.m_146909_();
        player.m_264318_(targetLevel, newX, newY, newZ, relativeMovements, newYaw, newPitch);
    }

    @Mod.EventBusSubscriber(modid="kenjiscombatforms", bus=Mod.EventBusSubscriber.Bus.FORGE)
    public static class ServerForgeEvents {
        @SubscribeEvent
        public static void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent event) {
            Player player = event.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                WitherFormDashAbility.getInstance().getPlayerData((Player)serverPlayer);
                WitherFormDashAbility.getInstance().syncDataToClient(serverPlayer);
            }
        }

        @SubscribeEvent
        public static void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
            Player player = event.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                WitherFormDashAbility.getInstance().setAbilityCooldown((Player)serverPlayer);
                WitherFormDashAbility.getInstance().syncDataToClient(serverPlayer);
            }
        }

        @SubscribeEvent
        public static void onPlayerLogout(PlayerEvent.PlayerLoggedOutEvent event) {
            WitherFormDashAbility.getInstance().playerDataMap.remove(event.getEntity().m_20148_());
        }

        @SubscribeEvent
        public static void onPlayerClone(PlayerEvent.Clone event) {
            Player player = event.getOriginal();
            if (player instanceof ServerPlayer) {
                ServerPlayer originalPlayer = (ServerPlayer)player;
                player = event.getEntity();
                if (player instanceof ServerPlayer) {
                    ServerPlayer newPlayer = (ServerPlayer)player;
                    WitherPlayerDataSets.WitherFormDashPlayerData originalData = WitherFormDashAbility.getInstance().getPlayerData((Player)originalPlayer);
                    WitherPlayerDataSets.WitherFormDashPlayerData newData = WitherFormDashAbility.getInstance().getPlayerData((Player)newPlayer);
                    newData.abilityCooldown = originalData.abilityCooldown;
                    WitherFormDashAbility.getInstance().syncDataToClient(newPlayer);
                }
            }
        }
    }
}

