/*
 * Decompiled with CFR 0.152.
 */
package net.kenji.kenjiscombatforms.api.powers.WitherPowers;

import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.kenji.kenjiscombatforms.api.handlers.power_data.WitherPlayerDataSets;
import net.kenji.kenjiscombatforms.api.interfaces.ability.AbstractAbilityData;
import net.kenji.kenjiscombatforms.api.interfaces.ability.FinalAbility;
import net.kenji.kenjiscombatforms.api.managers.AbilityManager;
import net.kenji.kenjiscombatforms.event.CommonFunctions;
import net.kenji.kenjiscombatforms.network.NetworkHandler;
import net.kenji.kenjiscombatforms.network.witherform.wither_abilites.ability5.SyncWitherData5Packet;
import net.kenji.kenjiscombatforms.network.witherform.wither_abilites.ability5.WitherImplodePacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.PacketDistributor;

public class WitherImplode
implements FinalAbility {
    private final WitherPlayerDataSets dataSets = WitherPlayerDataSets.getInstance();
    private final Map<UUID, WitherPlayerDataSets.WitherImplodePlayerData> playerDataMap;
    private final CommonFunctions dataHandlers;
    private static final WitherImplode INSTANCE = new WitherImplode();

    @Override
    public String getName() {
        return AbilityManager.AbilityOption5.WITHER_IMPLODE.name();
    }

    @Override
    public String getFinalAbilityName() {
        return AbilityManager.AbilityOption3.WITHER_FINAL.name();
    }

    public WitherPlayerDataSets.WitherImplodePlayerData getPlayerData(Player player) {
        return (WitherPlayerDataSets.WitherImplodePlayerData)this.getAbilityData(player);
    }

    public WitherPlayerDataSets.WitherFormPlayerData getOrCreateWitherFormPlayerData(Player player) {
        return this.dataSets.getOrCreateWitherFormPlayerData(player);
    }

    public WitherImplode() {
        this.playerDataMap = WitherPlayerDataSets.getInstance().A5playerDataMap;
        this.dataHandlers = CommonFunctions.getInstance();
    }

    public static WitherImplode getInstance() {
        return INSTANCE;
    }

    public int getAbilityCooldown(Player player) {
        return this.getPlayerData((Player)player).abilityCooldown;
    }

    public void setAbilityCooldown(Player player) {
        this.getPlayerData((Player)player).abilityCooldown += this.getPlayerData(player).getMAX_COOLDOWN() / 2;
    }

    @Override
    public AbstractAbilityData getAbilityData(Player player) {
        return this.dataSets.getOrCreateWitherImplodePlayerData(player);
    }

    @Override
    public boolean getFinalAbilityActive(Player player) {
        return AbilityManager.getInstance().getAbility(this.getFinalAbilityName()).getAbilityData(player).isAbilityActive();
    }

    @Override
    public boolean getAbilityActive(Player player) {
        return this.getAbilityData(player).isAbilityActive();
    }

    @Override
    public void fillPerSecondCooldown(Player player) {
        WitherPlayerDataSets.WitherImplodePlayerData data = this.getPlayerData(player);
        int cooldown = data.abilityCooldown;
        if (cooldown > 0) {
            data.tickCount = this.dataHandlers.getTickCount(data.tickCount);
            data.abilityCooldown = this.dataHandlers.decreaseCooldown(data.abilityCooldown, data.tickCount);
        }
    }

    @Override
    public void drainPerSecondCooldown(Player player) {
    }

    @Override
    public void sendPacketToServer(Player player) {
        NetworkHandler.INSTANCE.sendToServer((Object)new WitherImplodePacket());
    }

    @Override
    public void triggerAbility(ServerPlayer serverPlayer) {
        WitherPlayerDataSets.WitherImplodePlayerData data = this.getPlayerData((Player)serverPlayer);
        WitherPlayerDataSets.WitherFormPlayerData wData = this.getOrCreateWitherFormPlayerData((Player)serverPlayer);
        long currentTime = System.currentTimeMillis();
        if (data.abilityCooldown <= 0 && wData.isWitherActive) {
            this.playSound((Player)serverPlayer);
            this.activateAbility(serverPlayer);
        }
    }

    @Override
    public void activateAbility(ServerPlayer serverPlayer) {
        WitherPlayerDataSets.WitherImplodePlayerData data = this.getPlayerData((Player)serverPlayer);
        data.hasActivated = true;
        data.abilityCooldown = data.getMAX_COOLDOWN();
    }

    @Override
    public void deactivateAbilityOptional(ServerPlayer serverPlayer) {
    }

    @Override
    public void decrementCooldown(Player player) {
        WitherPlayerDataSets.WitherImplodePlayerData data = this.getPlayerData(player);
        WitherPlayerDataSets.WitherMinionPlayerData mData = this.dataSets.getOrCreateMinionPlayerData(player);
        WitherPlayerDataSets.WitherFormPlayerData wData = this.dataSets.getOrCreateWitherFormPlayerData(player);
        if (this.isAbilityChosenOrEquipped(player) && !mData.areMinionsActive && wData.isWitherActive) {
            this.fillPerSecondCooldown(player);
        }
    }

    @Override
    public void tickServerAbilityData(ServerPlayer player) {
        WitherImplode.getInstance().decrementCooldown((Player)player);
        WitherPlayerDataSets.WitherImplodePlayerData data = this.getPlayerData((Player)player);
        this.handleNearbyEntities((Player)player);
        this.syncDataToClient(player);
    }

    @Override
    public void tickClientAbilityData(Player player) {
        WitherPlayerDataSets.WitherImplodePlayerData data = this.getPlayerData(player);
    }

    @Override
    public void syncDataToClient(ServerPlayer player) {
        WitherPlayerDataSets.WitherImplodePlayerData data = this.getPlayerData((Player)player);
        if (this.getFinalAbilityActive((Player)player)) {
            NetworkHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> player), (Object)new SyncWitherData5Packet(data.abilityCooldown));
        }
    }

    public boolean isAbilityChosenOrEquipped(Player player) {
        AbilityManager.PlayerAbilityData abilityData = AbilityManager.getInstance().getPlayerAbilityData(player);
        return abilityData.chosenFinal.name().equals(this.getName());
    }

    private void handleNearbyEntities(Player player) {
        WitherPlayerDataSets.WitherImplodePlayerData data = this.getPlayerData(player);
        double radius = 10.0;
        AABB searchArea = new AABB(player.m_20097_()).m_82400_(radius);
        TargetingConditions targetingConditions = TargetingConditions.m_148352_();
        List nearbyEntities = player.m_9236_().m_45971_(LivingEntity.class, targetingConditions, (LivingEntity)player, searchArea);
        for (LivingEntity entity : nearbyEntities) {
            if (!data.hasActivated) continue;
            ++data.countTicker;
            entity.m_7292_(new MobEffectInstance(MobEffects.f_19620_, 30, 0, false, false));
            entity.m_7292_(new MobEffectInstance(MobEffects.f_19619_, 30, 0, false, false));
            if (data.countTicker <= 30) continue;
            entity.m_9236_().m_254849_((Entity)entity, entity.m_20182_().f_82479_, entity.m_20182_().f_82480_, entity.m_20182_().f_82481_, (float)data.EXPLOSION_DAMAGE, Level.ExplosionInteraction.MOB).m_46061_();
            entity.m_7292_(new MobEffectInstance(MobEffects.f_19615_, 40, 0, false, false));
            data.hasActivated = false;
            data.countTicker = 0;
        }
    }

    @Override
    public void playSound(Player player) {
        player.m_9236_().m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12500_, SoundSource.PLAYERS, 1.0f, 1.0f);
    }

    @Override
    public void playSound2(Player player) {
    }

    @Mod.EventBusSubscriber(modid="kenjiscombatforms", bus=Mod.EventBusSubscriber.Bus.FORGE)
    public static class ServerForgeEvents {
        @SubscribeEvent
        public static void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent event) {
            Player player = event.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                WitherImplode.getInstance().getPlayerData((Player)serverPlayer);
                WitherImplode.getInstance().syncDataToClient(serverPlayer);
            }
            Player player2 = event.getEntity();
        }

        @SubscribeEvent
        public static void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
            Player player = event.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                WitherImplode.getInstance().setAbilityCooldown((Player)serverPlayer);
                WitherImplode.getInstance().syncDataToClient(serverPlayer);
            }
        }

        @SubscribeEvent
        public static void onPlayerLogout(PlayerEvent.PlayerLoggedOutEvent event) {
            WitherImplode.getInstance().playerDataMap.remove(event.getEntity().m_20148_());
        }

        @SubscribeEvent
        public static void onPlayerClone(PlayerEvent.Clone event) {
            Player player = event.getOriginal();
            if (player instanceof ServerPlayer) {
                ServerPlayer originalPlayer = (ServerPlayer)player;
                player = event.getEntity();
                if (player instanceof ServerPlayer) {
                    ServerPlayer newPlayer = (ServerPlayer)player;
                    WitherPlayerDataSets.WitherImplodePlayerData originalData = WitherImplode.getInstance().getPlayerData((Player)originalPlayer);
                    WitherPlayerDataSets.WitherImplodePlayerData newData = WitherImplode.getInstance().getPlayerData((Player)newPlayer);
                    newData.abilityCooldown = originalData.abilityCooldown;
                    WitherImplode.getInstance().syncDataToClient(newPlayer);
                }
            }
        }

        @SubscribeEvent
        public void onPlayerTick(TickEvent.PlayerTickEvent event) {
            if (event.phase == TickEvent.Phase.END) {
                Player player = event.player;
                WitherPlayerDataSets.WitherImplodePlayerData witherImplodePlayerData = WitherImplode.getInstance().getPlayerData(player);
            }
        }
    }
}

