/*
 * Decompiled with CFR 0.152.
 */
package net.kenji.kenjiscombatforms.api.powers.WitherPowers;

import java.util.Map;
import java.util.UUID;
import net.kenji.kenjiscombatforms.api.handlers.power_data.WitherPlayerDataSets;
import net.kenji.kenjiscombatforms.api.interfaces.ability.AbstractAbilityData;
import net.kenji.kenjiscombatforms.api.interfaces.ability.FinalAbility;
import net.kenji.kenjiscombatforms.api.managers.AbilityManager;
import net.kenji.kenjiscombatforms.entity.ModEntities;
import net.kenji.kenjiscombatforms.entity.custom.noAiEntities.WitherMinionEntity;
import net.kenji.kenjiscombatforms.event.CommonFunctions;
import net.kenji.kenjiscombatforms.network.NetworkHandler;
import net.kenji.kenjiscombatforms.network.particle_packets.MinionSummonParticlesPacket;
import net.kenji.kenjiscombatforms.network.witherform.ClientWitherData;
import net.kenji.kenjiscombatforms.network.witherform.wither_abilites.ability4.SummonWitherMinionsPacket;
import net.kenji.kenjiscombatforms.network.witherform.wither_abilites.ability4.SyncWitherData4Packet;
import net.minecraft.ChatFormatting;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.scores.PlayerTeam;
import net.minecraft.world.scores.Scoreboard;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.util.thread.EffectiveSide;
import net.minecraftforge.network.PacketDistributor;

public class WitherMinions
implements FinalAbility {
    WitherPlayerDataSets dataSets = WitherPlayerDataSets.getInstance();
    private final Map<UUID, WitherPlayerDataSets.WitherMinionPlayerData> playerDataMap;
    public String teamName;
    private final CommonFunctions dataHandlers;
    private static final WitherMinions INSTANCE = new WitherMinions();

    @Override
    public String getName() {
        return AbilityManager.AbilityOption4.WITHER_MINIONS.name();
    }

    @Override
    public String getFinalAbilityName() {
        return AbilityManager.AbilityOption3.WITHER_FINAL.name();
    }

    private WitherPlayerDataSets.WitherMinionPlayerData getPlayerData(Player player) {
        return (WitherPlayerDataSets.WitherMinionPlayerData)this.getAbilityData(player);
    }

    private WitherPlayerDataSets.WitherDashPlayerData getOrCreateDashPlayerData(Player player) {
        return this.dataSets.getOrCreateDashPlayerData(player);
    }

    private WitherPlayerDataSets.WitherFormPlayerData getOrCreateWitherFormPlayerData(Player player) {
        return this.dataSets.getOrCreateWitherFormPlayerData(player);
    }

    public void witherMinionRemove(ServerPlayer player) {
        WitherPlayerDataSets.WitherMinionPlayerData data = this.getPlayerData((Player)player);
        Entity existingMinion = data.playerMinionMap.remove(player.m_20148_());
        Entity existingMinion2 = data.playerMinion2Map.remove(player.m_20148_());
        Entity existingMinion3 = data.playerMinion3Map.remove(player.m_20148_());
        Entity existingMinion4 = data.playerMinion4Map.remove(player.m_20148_());
        if (existingMinion != null) {
            existingMinion.m_142687_(Entity.RemovalReason.DISCARDED);
        }
        if (existingMinion2 != null) {
            existingMinion2.m_142687_(Entity.RemovalReason.DISCARDED);
        }
        if (existingMinion3 != null) {
            existingMinion3.m_142687_(Entity.RemovalReason.DISCARDED);
        }
        if (existingMinion4 != null) {
            existingMinion4.m_142687_(Entity.RemovalReason.DISCARDED);
        }
        ClientWitherData.setAreMinionsActive(false);
    }

    public WitherMinions() {
        this.playerDataMap = WitherPlayerDataSets.getInstance().A4playerDataMap;
        this.teamName = "active_minions";
        this.dataHandlers = CommonFunctions.getInstance();
    }

    public static WitherMinions getInstance() {
        return INSTANCE;
    }

    public int getAbilityCooldown(ServerPlayer player) {
        return this.getOrCreateDashPlayerData((Player)player).abilityCooldown;
    }

    public void setAbilityCooldown(ServerPlayer player, int cooldown) {
        this.getOrCreateDashPlayerData((Player)player).abilityCooldown = Math.min(Math.max(cooldown, 0), this.getPlayerData((Player)player).getMAX_COOLDOWN());
    }

    @OnlyIn(value=Dist.CLIENT)
    public void clientChangeActive(Player player) {
        int currentMinionCooldown = ClientWitherData.getMinionCooldown();
        WitherPlayerDataSets.WitherMinionPlayerData data = this.getPlayerData(player);
        if (currentMinionCooldown == 0) {
            data.areMinionsActive = true;
        }
    }

    private void timerMinionSummon(ServerPlayer player) {
        WitherPlayerDataSets.WitherMinionPlayerData data = this.getPlayerData((Player)player);
        WitherPlayerDataSets.WitherFormPlayerData bData = this.getOrCreateWitherFormPlayerData((Player)player);
        if (data.canCount) {
            ++data.timerCount;
            if (data.timerCount > 100) {
                Entity entity;
                this.playSound2((Player)player);
                if (data.MINION_COUNT == 1) {
                    data.minionEntity = ((EntityType)ModEntities.WITHER_MINION.get()).m_262496_(player.m_284548_(), player.m_20183_().m_7918_(0, 0, -1), MobSpawnType.TRIGGERED);
                    if (data.minionEntity != null) {
                        data.playerMinionMap.put(player.m_20148_(), data.minionEntity);
                    }
                } else if (data.MINION_COUNT == 2) {
                    data.minionEntity = ((EntityType)ModEntities.WITHER_MINION.get()).m_262496_(player.m_284548_(), player.m_20183_().m_7918_(1, 0, 0), MobSpawnType.TRIGGERED);
                    data.minionEntity2 = ((EntityType)ModEntities.WITHER_MINION.get()).m_262496_(player.m_284548_(), player.m_20183_().m_7918_(-1, 0, 0), MobSpawnType.TRIGGERED);
                    if (data.minionEntity != null && data.minionEntity2 != null) {
                        data.playerMinionMap.put(player.m_20148_(), data.minionEntity);
                        data.playerMinion2Map.put(player.m_20148_(), data.minionEntity2);
                    }
                } else if (data.MINION_COUNT == 3) {
                    data.minionEntity = ((EntityType)ModEntities.WITHER_MINION.get()).m_262496_(player.m_284548_(), player.m_20183_().m_7918_(1, 0, 0), MobSpawnType.TRIGGERED);
                    data.minionEntity2 = ((EntityType)ModEntities.WITHER_MINION.get()).m_262496_(player.m_284548_(), player.m_20183_().m_7918_(-1, 0, 0), MobSpawnType.TRIGGERED);
                    data.minionEntity3 = ((EntityType)ModEntities.WITHER_MINION.get()).m_262496_(player.m_284548_(), player.m_20183_().m_7918_(0, 0, -1), MobSpawnType.TRIGGERED);
                    if (data.minionEntity != null && data.minionEntity2 != null && data.minionEntity3 != null) {
                        data.playerMinionMap.put(player.m_20148_(), data.minionEntity);
                        data.playerMinion2Map.put(player.m_20148_(), data.minionEntity2);
                        data.playerMinion3Map.put(player.m_20148_(), data.minionEntity3);
                    }
                } else if (data.MINION_COUNT == 4) {
                    data.minionEntity = ((EntityType)ModEntities.WITHER_MINION.get()).m_262496_(player.m_284548_(), player.m_20183_().m_7918_(1, 0, 0), MobSpawnType.TRIGGERED);
                    data.minionEntity2 = ((EntityType)ModEntities.WITHER_MINION.get()).m_262496_(player.m_284548_(), player.m_20183_().m_7918_(-1, 0, 0), MobSpawnType.TRIGGERED);
                    data.minionEntity3 = ((EntityType)ModEntities.WITHER_MINION.get()).m_262496_(player.m_284548_(), player.m_20183_().m_7918_(0, 0, -1), MobSpawnType.TRIGGERED);
                    data.minionEntity4 = ((EntityType)ModEntities.WITHER_MINION.get()).m_262496_(player.m_284548_(), player.m_20183_().m_7918_(0, 0, 1), MobSpawnType.TRIGGERED);
                    if (data.minionEntity != null && data.minionEntity2 != null && data.minionEntity3 != null && data.minionEntity4 != null) {
                        data.playerMinionMap.put(player.m_20148_(), data.minionEntity);
                        data.playerMinion2Map.put(player.m_20148_(), data.minionEntity2);
                        data.playerMinion3Map.put(player.m_20148_(), data.minionEntity3);
                        data.playerMinion4Map.put(player.m_20148_(), data.minionEntity4);
                    }
                }
                Scoreboard scoreboard = player.m_9236_().m_6188_();
                bData.isDelayPause = false;
                PlayerTeam team = scoreboard.m_83489_(this.teamName);
                if (team == null) {
                    team = scoreboard.m_83492_(this.teamName);
                    team.m_83351_(ChatFormatting.DARK_GRAY);
                    team.m_83355_(false);
                }
                if ((entity = data.minionEntity) instanceof WitherMinionEntity) {
                    WitherMinionEntity minionEntity = (WitherMinionEntity)entity;
                    minionEntity.m_21816_(data.playerUUID);
                    scoreboard.m_6546_(minionEntity.m_20149_(), team);
                }
                if ((entity = data.minionEntity2) instanceof WitherMinionEntity) {
                    WitherMinionEntity minionEntity2 = (WitherMinionEntity)entity;
                    minionEntity2.m_21816_(data.playerUUID);
                    scoreboard.m_6546_(minionEntity2.m_20149_(), team);
                }
                if ((entity = data.minionEntity3) instanceof WitherMinionEntity) {
                    WitherMinionEntity minionEntity3 = (WitherMinionEntity)entity;
                    minionEntity3.m_21816_(data.playerUUID);
                    scoreboard.m_6546_(minionEntity3.m_20149_(), team);
                }
                if ((entity = data.minionEntity4) instanceof WitherMinionEntity) {
                    WitherMinionEntity minionEntity4 = (WitherMinionEntity)entity;
                    minionEntity4.m_21816_(data.playerUUID);
                    scoreboard.m_6546_(minionEntity4.m_20149_(), team);
                }
                data.timerCount = 0;
                data.canCount = false;
            }
        }
    }

    @Override
    public AbstractAbilityData getAbilityData(Player player) {
        return this.dataSets.getOrCreateMinionPlayerData(player);
    }

    @Override
    public boolean getFinalAbilityActive(Player player) {
        return AbilityManager.getInstance().getAbility(this.getFinalAbilityName()).getAbilityData(player).isAbilityActive();
    }

    @Override
    public boolean getAbilityActive(Player player) {
        return this.getAbilityData(player).isAbilityActive();
    }

    @Override
    public void fillPerSecondCooldown(Player player) {
        WitherPlayerDataSets.WitherMinionPlayerData data = this.getPlayerData(player);
        int cooldown = data.abilityCooldown;
        if (cooldown > 0) {
            data.tickCount = this.dataHandlers.getTickCount(data.tickCount);
            data.abilityCooldown = this.dataHandlers.decreaseCooldown(data.abilityCooldown, data.tickCount);
        }
    }

    @Override
    public void drainPerSecondCooldown(Player player) {
        WitherPlayerDataSets.WitherMinionPlayerData data = this.getPlayerData(player);
        data.tickCount = this.dataHandlers.getTickCount(data.tickCount);
        data.abilityCooldown = this.dataHandlers.increaseCooldown(data.abilityCooldown, data.tickCount);
    }

    @Override
    public void sendPacketToServer(Player player) {
        if (ClientWitherData.getIsWitherActive() || ClientWitherData.getMinionsActive()) {
            NetworkHandler.INSTANCE.sendToServer((Object)new SummonWitherMinionsPacket());
            WitherMinions.getInstance().clientChangeActive(player);
        }
    }

    @Override
    public void triggerAbility(ServerPlayer serverPlayer) {
        WitherPlayerDataSets.WitherMinionPlayerData data = this.getPlayerData((Player)serverPlayer);
        WitherPlayerDataSets.WitherDashPlayerData aData = this.dataSets.getOrCreateDashPlayerData((Player)serverPlayer);
        WitherPlayerDataSets.WitherFormPlayerData bData = WitherMinions.getInstance().getOrCreateWitherFormPlayerData((Player)serverPlayer);
        long currentTime = System.currentTimeMillis();
        if (data.abilityCooldown == 0) {
            this.activateAbility(serverPlayer);
            bData.isDelayPause = true;
            data.playerUUID = serverPlayer.m_20148_();
        } else {
            this.deactivateAbilityOptional(serverPlayer);
        }
    }

    @Override
    public void activateAbility(ServerPlayer serverPlayer) {
        WitherPlayerDataSets.WitherMinionPlayerData data = this.getPlayerData((Player)serverPlayer);
        data.areMinionsActive = true;
        ClientWitherData.setAreMinionsActive(true);
        data.canCount = true;
        WitherPlayerDataSets.WitherDashPlayerData aData = this.getOrCreateDashPlayerData((Player)serverPlayer);
        this.playSound((Player)serverPlayer);
        NetworkHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new MinionSummonParticlesPacket(serverPlayer.m_20183_(), 4, 64, 24));
    }

    @Override
    public void deactivateAbilityOptional(ServerPlayer serverPlayer) {
        WitherPlayerDataSets.WitherMinionPlayerData data = this.getPlayerData((Player)serverPlayer);
        Entity existingMinion = data.playerMinionMap.remove(serverPlayer.m_20148_());
        Entity existingMinion2 = data.playerMinion2Map.remove(serverPlayer.m_20148_());
        Entity existingMinion3 = data.playerMinion3Map.remove(serverPlayer.m_20148_());
        Entity existingMinion4 = data.playerMinion4Map.remove(serverPlayer.m_20148_());
        if (existingMinion != null) {
            existingMinion.m_142687_(Entity.RemovalReason.DISCARDED);
        }
        if (existingMinion2 != null) {
            existingMinion2.m_142687_(Entity.RemovalReason.DISCARDED);
        }
        if (existingMinion3 != null) {
            existingMinion3.m_142687_(Entity.RemovalReason.DISCARDED);
        }
        if (existingMinion4 != null) {
            existingMinion4.m_142687_(Entity.RemovalReason.DISCARDED);
        }
        data.areMinionsActive = false;
        WitherMinions.getInstance().witherMinionRemove(serverPlayer);
        WitherMinions.getInstance().playerDataMap.remove(serverPlayer.m_20148_());
        ClientWitherData.setAreMinionsActive(false);
    }

    @Override
    public void decrementCooldown(Player player) {
        WitherPlayerDataSets.WitherMinionPlayerData data = this.getPlayerData(player);
        WitherPlayerDataSets.WitherFormPlayerData bData = WitherMinions.getInstance().getOrCreateWitherFormPlayerData(player);
        if (this.getFinalAbilityActive(player) && player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (EffectiveSide.get() == LogicalSide.SERVER) {
                if (!data.areMinionsActive && !ClientWitherData.getMinionsActive() && bData.isWitherActive) {
                    this.fillPerSecondCooldown(player);
                    this.fillPerSecondCooldown(player);
                    this.fillPerSecondCooldown(player);
                    this.fillPerSecondCooldown(player);
                    this.fillPerSecondCooldown(player);
                    this.fillPerSecondCooldown(player);
                } else if (data.areMinionsActive || ClientWitherData.getMinionsActive()) {
                    this.drainPerSecondCooldown(player);
                }
                if (data.abilityCooldown >= data.getMAX_COOLDOWN() && data.areMinionsActive) {
                    this.deactivateAbilityOptional(serverPlayer);
                    if (!data.hasPlayedSound) {
                        data.hasPlayedSound = true;
                        this.playSound(player);
                    }
                }
            }
        }
    }

    @Override
    public void tickServerAbilityData(ServerPlayer player) {
        WitherMinions.getInstance().decrementCooldown((Player)player);
        this.syncDataToClient(player);
        this.timerMinionSummon(player);
    }

    @Override
    public void tickClientAbilityData(Player player) {
    }

    @Override
    public void syncDataToClient(ServerPlayer player) {
        WitherPlayerDataSets.WitherMinionPlayerData data = this.getPlayerData((Player)player);
        if (this.getFinalAbilityActive((Player)player)) {
            NetworkHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> player), (Object)new SyncWitherData4Packet(data.abilityCooldown, data.areMinionsActive));
        }
    }

    public boolean isAbilityChosenOrEquipped(Player player) {
        AbilityManager.PlayerAbilityData abilityData = AbilityManager.getInstance().getPlayerAbilityData(player);
        return abilityData.chosenFinal.name().equals(this.getName());
    }

    @Override
    public void playSound(Player player) {
        player.m_9236_().m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12554_, SoundSource.PLAYERS, 1.0f, 1.0f);
    }

    @Override
    public void playSound2(Player player) {
        player.m_9236_().m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12052_, SoundSource.PLAYERS, 1.0f, 1.0f);
    }

    @Mod.EventBusSubscriber(modid="kenjiscombatforms", bus=Mod.EventBusSubscriber.Bus.FORGE)
    public static class ServerForgeEvents {
        @SubscribeEvent
        public static void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent event) {
            Player player = event.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                WitherMinions.getInstance().getPlayerData((Player)serverPlayer);
                WitherMinions.getInstance().syncDataToClient(serverPlayer);
            }
        }

        @SubscribeEvent
        public static void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
            Player player = event.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                WitherMinions.getInstance().setAbilityCooldown(serverPlayer, WitherMinions.getInstance().getPlayerData((Player)serverPlayer).getMAX_COOLDOWN());
                WitherMinions.getInstance().syncDataToClient(serverPlayer);
            }
        }
    }
}

