/*
 * Decompiled with CFR 0.152.
 */
package net.kenji.kenjiscombatforms.api.powers.power_powers;

import java.util.Map;
import java.util.UUID;
import net.kenji.kenjiscombatforms.api.handlers.ClientEventHandler;
import net.kenji.kenjiscombatforms.api.handlers.power_data.PowerPlayerDataSets;
import net.kenji.kenjiscombatforms.api.interfaces.ability.Ability;
import net.kenji.kenjiscombatforms.api.interfaces.ability.AbstractAbilityData;
import net.kenji.kenjiscombatforms.api.managers.AbilityManager;
import net.kenji.kenjiscombatforms.event.CommonFunctions;
import net.kenji.kenjiscombatforms.network.NetworkHandler;
import net.kenji.kenjiscombatforms.network.power_form.ClientPowerData;
import net.kenji.kenjiscombatforms.network.power_form.ability1.StrengthBoostPacket;
import net.kenji.kenjiscombatforms.network.power_form.ability1.SyncPowerDataPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.PacketDistributor;

public class StrengthBoost
implements Ability {
    private final PowerPlayerDataSets dataSets = PowerPlayerDataSets.getInstance();
    private final Map<UUID, PowerPlayerDataSets.StrengthPlayerData> playerDataMap;
    private static final StrengthBoost INSTANCE = new StrengthBoost();
    private final CommonFunctions dataHandlers;

    @Override
    public String getName() {
        return AbilityManager.AbilityOption1.POWER_ABILITY1.name();
    }

    PowerPlayerDataSets.StrengthPlayerData getPlayerData(Player player) {
        return (PowerPlayerDataSets.StrengthPlayerData)this.getAbilityData(player);
    }

    public StrengthBoost() {
        this.playerDataMap = this.dataSets.A1playerDataMap;
        this.dataHandlers = CommonFunctions.getInstance();
    }

    public static StrengthBoost getInstance() {
        return INSTANCE;
    }

    public float getAbilityCooldown(Player player) {
        PowerPlayerDataSets.StrengthPlayerData data = this.getPlayerData(player);
        return data.abilityCooldown;
    }

    public void setAbilityCooldown(Player player) {
        PowerPlayerDataSets.StrengthPlayerData data = this.getPlayerData(player);
        data.abilityCooldown += data.getMAX_COOLDOWN() / 2;
    }

    @Override
    public AbstractAbilityData getAbilityData(Player player) {
        return this.dataSets.getOrCreateStrengthPlayerData(player);
    }

    @Override
    public void fillPerSecondCooldown(Player player) {
        PowerPlayerDataSets.StrengthPlayerData data = this.getPlayerData(player);
        int cooldown = data.abilityCooldown;
        if (cooldown > 0) {
            data.tickCount = this.dataHandlers.getTickCount(data.tickCount);
            data.abilityCooldown = this.dataHandlers.decreaseCooldown(data.abilityCooldown, data.tickCount);
        }
    }

    @Override
    public void drainPerSecondCooldown(Player player) {
    }

    @Override
    public boolean getAbilityActive(Player player) {
        return this.getAbilityData(player).isAbilityActive();
    }

    @Override
    public void sendPacketToServer(Player player) {
        if (!ClientEventHandler.getInstance().getAreFinalsActive()) {
            NetworkHandler.INSTANCE.sendToServer((Object)new StrengthBoostPacket());
        }
    }

    @Override
    public void triggerAbility(ServerPlayer serverPlayer) {
        long currentTime = System.currentTimeMillis();
        PowerPlayerDataSets.StrengthPlayerData data = this.getPlayerData((Player)serverPlayer);
        if (data.abilityCooldown <= 0) {
            this.activateAbility(serverPlayer);
            this.playSound((Player)serverPlayer);
        }
    }

    @Override
    public void activateAbility(ServerPlayer player) {
        PowerPlayerDataSets.StrengthPlayerData data = this.getPlayerData((Player)player);
        player.m_7292_(new MobEffectInstance(MobEffects.f_19600_, 600, 1, false, true));
    }

    @Override
    public void deactivateAbilityOptional(ServerPlayer serverPlayer) {
    }

    @Override
    public void decrementCooldown(Player player) {
        PowerPlayerDataSets.StrengthPlayerData data = this.playerDataMap.computeIfAbsent(player.m_20148_(), k -> new PowerPlayerDataSets.StrengthPlayerData());
        if (!player.m_21023_(MobEffects.f_19600_)) {
            this.fillPerSecondCooldown(player);
            ClientPowerData.setCooldown(data.abilityCooldown);
        }
        if (player.m_21023_(MobEffects.f_19600_)) {
            data.abilityCooldown = data.getMAX_COOLDOWN();
        }
    }

    @Override
    public void tickServerAbilityData(ServerPlayer player) {
        AbilityManager.PlayerAbilityData abilityData = AbilityManager.getInstance().getPlayerAbilityData((Player)player);
        if (abilityData.chosenAbility1.name().equals(this.getName())) {
            StrengthBoost.getInstance().decrementCooldown((Player)player);
        }
    }

    @Override
    public void tickClientAbilityData(Player player) {
    }

    @Override
    public void syncDataToClient(ServerPlayer player) {
        PowerPlayerDataSets.StrengthPlayerData data = this.getPlayerData((Player)player);
        if (this.isAbilityChosenOrEquipped((Player)player)) {
            NetworkHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> player), (Object)new SyncPowerDataPacket(data.abilityCooldown));
        }
    }

    public boolean isAbilityChosenOrEquipped(Player player) {
        AbilityManager.PlayerAbilityData abilityData = AbilityManager.getInstance().getPlayerAbilityData(player);
        return abilityData.chosenAbility1.name().equals(this.getName());
    }

    @Override
    public void playSound(Player player) {
        player.m_9236_().m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12049_, SoundSource.PLAYERS, 1.0f, 1.0f);
    }

    @Override
    public void playSound2(Player player) {
    }

    @Mod.EventBusSubscriber(modid="kenjiscombatforms", bus=Mod.EventBusSubscriber.Bus.FORGE)
    public static class ServerForgeEvents {
        @SubscribeEvent
        public static void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent event) {
            Player player = event.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                StrengthBoost.getInstance().getPlayerData((Player)serverPlayer);
                StrengthBoost.getInstance().syncDataToClient(serverPlayer);
            }
        }

        @SubscribeEvent
        public static void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
            Player player = event.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                StrengthBoost.getInstance().setAbilityCooldown((Player)serverPlayer);
                StrengthBoost.getInstance().syncDataToClient(serverPlayer);
            }
        }

        @SubscribeEvent
        public static void onPlayerLogout(PlayerEvent.PlayerLoggedOutEvent event) {
            StrengthBoost.getInstance().playerDataMap.remove(event.getEntity().m_20148_());
        }

        @SubscribeEvent
        public static void onPlayerClone(PlayerEvent.Clone event) {
            Player player = event.getOriginal();
            if (player instanceof ServerPlayer) {
                ServerPlayer originalPlayer = (ServerPlayer)player;
                player = event.getEntity();
                if (player instanceof ServerPlayer) {
                    ServerPlayer newPlayer = (ServerPlayer)player;
                    PowerPlayerDataSets.StrengthPlayerData originalData = StrengthBoost.getInstance().getPlayerData((Player)originalPlayer);
                    PowerPlayerDataSets.StrengthPlayerData newData = StrengthBoost.getInstance().getPlayerData((Player)newPlayer);
                    StrengthBoost.getInstance().syncDataToClient(newPlayer);
                }
            }
        }
    }
}

