/*
 * Decompiled with CFR 0.152.
 */
package net.kenji.kenjiscombatforms.api.powers.swift_powers;

import java.util.Map;
import java.util.UUID;
import net.kenji.kenjiscombatforms.api.handlers.ClientEventHandler;
import net.kenji.kenjiscombatforms.api.handlers.power_data.SwiftPlayerDataSets;
import net.kenji.kenjiscombatforms.api.interfaces.ability.Ability;
import net.kenji.kenjiscombatforms.api.interfaces.ability.AbstractAbilityData;
import net.kenji.kenjiscombatforms.api.managers.AbilityManager;
import net.kenji.kenjiscombatforms.event.CommonFunctions;
import net.kenji.kenjiscombatforms.network.NetworkHandler;
import net.kenji.kenjiscombatforms.network.swift_form.ClientSwiftData;
import net.kenji.kenjiscombatforms.network.swift_form.ability1.SpeedBoostPacket;
import net.kenji.kenjiscombatforms.network.swift_form.ability1.SyncSwiftDataPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.PacketDistributor;

public class SpeedBoost
implements Ability {
    private final SwiftPlayerDataSets dataSets = SwiftPlayerDataSets.getInstance();
    private final Map<UUID, SwiftPlayerDataSets.SpeedPlayerData> playerDataMap;
    private static final SpeedBoost INSTANCE = new SpeedBoost();
    private final CommonFunctions dataHandlers;

    @Override
    public String getName() {
        return AbilityManager.AbilityOption1.SWIFT_ABILITY1.name();
    }

    SwiftPlayerDataSets.SpeedPlayerData getPlayerData(Player player) {
        return (SwiftPlayerDataSets.SpeedPlayerData)this.getAbilityData(player);
    }

    public SpeedBoost() {
        this.playerDataMap = this.dataSets.A1playerDataMap;
        this.dataHandlers = CommonFunctions.getInstance();
    }

    public static SpeedBoost getInstance() {
        return INSTANCE;
    }

    public float getAbilityCooldown(Player player) {
        SwiftPlayerDataSets.SpeedPlayerData data = this.getPlayerData(player);
        return data.abilityCooldown;
    }

    public void setAbilityCooldown(Player player) {
        SwiftPlayerDataSets.SpeedPlayerData data = this.getPlayerData(player);
        data.abilityCooldown += data.getMAX_COOLDOWN() / 2;
    }

    @Override
    public AbstractAbilityData getAbilityData(Player player) {
        return this.dataSets.getOrCreateSpeedPlayerData(player);
    }

    @Override
    public void fillPerSecondCooldown(Player player) {
        SwiftPlayerDataSets.SpeedPlayerData data = this.getPlayerData(player);
        int cooldown = data.abilityCooldown;
        if (cooldown > 0) {
            data.tickCount = this.dataHandlers.getTickCount(data.tickCount);
            data.abilityCooldown = this.dataHandlers.decreaseCooldown(data.abilityCooldown, data.tickCount);
        }
    }

    @Override
    public void drainPerSecondCooldown(Player player) {
    }

    @Override
    public boolean getAbilityActive(Player player) {
        return this.getAbilityData(player).isAbilityActive();
    }

    @Override
    public void sendPacketToServer(Player player) {
        if (!ClientEventHandler.getInstance().getAreFinalsActive()) {
            NetworkHandler.INSTANCE.sendToServer((Object)new SpeedBoostPacket());
        }
    }

    @Override
    public void triggerAbility(ServerPlayer serverPlayer) {
        long currentTime = System.currentTimeMillis();
        SwiftPlayerDataSets.SpeedPlayerData data = this.getPlayerData((Player)serverPlayer);
        if (data.abilityCooldown <= 0) {
            this.activateAbility(serverPlayer);
            this.playSound((Player)serverPlayer);
        }
        if (serverPlayer.m_21023_(MobEffects.f_19596_)) {
            data.abilityCooldown = data.getMAX_COOLDOWN();
        }
    }

    @Override
    public void activateAbility(ServerPlayer player) {
        SwiftPlayerDataSets.SpeedPlayerData data = this.getPlayerData((Player)player);
        player.m_7292_(new MobEffectInstance(MobEffects.f_19596_, 600, 1, false, true));
    }

    @Override
    public void deactivateAbilityOptional(ServerPlayer serverPlayer) {
    }

    @Override
    public void decrementCooldown(Player player) {
        SwiftPlayerDataSets.SpeedPlayerData data = this.playerDataMap.computeIfAbsent(player.m_20148_(), k -> new SwiftPlayerDataSets.SpeedPlayerData());
        if (!player.m_21023_(MobEffects.f_19596_)) {
            this.fillPerSecondCooldown(player);
            ClientSwiftData.setCooldown(data.abilityCooldown);
        }
        if (player.m_21023_(MobEffects.f_19596_)) {
            data.abilityCooldown = data.getMAX_COOLDOWN();
        }
    }

    @Override
    public void tickServerAbilityData(ServerPlayer player) {
        AbilityManager.PlayerAbilityData abilityData = AbilityManager.getInstance().getPlayerAbilityData((Player)player);
        if (abilityData.chosenAbility1.name().equals(this.getName())) {
            SpeedBoost.getInstance().decrementCooldown((Player)player);
        }
    }

    @Override
    public void tickClientAbilityData(Player player) {
    }

    @Override
    public void syncDataToClient(ServerPlayer player) {
        SwiftPlayerDataSets.SpeedPlayerData data = this.getPlayerData((Player)player);
        if (this.isAbilityChosenOrEquipped((Player)player)) {
            NetworkHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> player), (Object)new SyncSwiftDataPacket(data.abilityCooldown));
        }
    }

    public boolean isAbilityChosenOrEquipped(Player player) {
        AbilityManager.PlayerAbilityData abilityData = AbilityManager.getInstance().getPlayerAbilityData(player);
        return abilityData.chosenAbility1.name().equals(this.getName());
    }

    @Override
    public void playSound(Player player) {
        player.m_9236_().m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12049_, SoundSource.PLAYERS, 1.0f, 1.0f);
    }

    @Override
    public void playSound2(Player player) {
    }

    @Mod.EventBusSubscriber(modid="kenjiscombatforms", bus=Mod.EventBusSubscriber.Bus.FORGE)
    public static class ServerForgeEvents {
        @SubscribeEvent
        public static void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent event) {
            Player player = event.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                SpeedBoost.getInstance().getPlayerData((Player)serverPlayer);
                SpeedBoost.getInstance().syncDataToClient(serverPlayer);
            }
        }

        @SubscribeEvent
        public static void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
            Player player = event.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                SpeedBoost.getInstance().setAbilityCooldown((Player)serverPlayer);
                SpeedBoost.getInstance().syncDataToClient(serverPlayer);
            }
        }

        @SubscribeEvent
        public static void onPlayerLogout(PlayerEvent.PlayerLoggedOutEvent event) {
            SpeedBoost.getInstance().playerDataMap.remove(event.getEntity().m_20148_());
        }

        @SubscribeEvent
        public static void onPlayerClone(PlayerEvent.Clone event) {
            Player player = event.getOriginal();
            if (player instanceof ServerPlayer) {
                ServerPlayer originalPlayer = (ServerPlayer)player;
                player = event.getEntity();
                if (player instanceof ServerPlayer) {
                    ServerPlayer newPlayer = (ServerPlayer)player;
                    SwiftPlayerDataSets.SpeedPlayerData originalData = SpeedBoost.getInstance().getPlayerData((Player)originalPlayer);
                    SwiftPlayerDataSets.SpeedPlayerData newData = SpeedBoost.getInstance().getPlayerData((Player)newPlayer);
                    SpeedBoost.getInstance().syncDataToClient(newPlayer);
                }
            }
        }
    }
}

