/*
 * Decompiled with CFR 0.152.
 */
package net.kenji.kenjiscombatforms.api.powers.swift_powers;

import java.util.Map;
import java.util.UUID;
import net.kenji.kenjiscombatforms.api.handlers.ClientEventHandler;
import net.kenji.kenjiscombatforms.api.handlers.power_data.SwiftPlayerDataSets;
import net.kenji.kenjiscombatforms.api.interfaces.ability.Ability;
import net.kenji.kenjiscombatforms.api.interfaces.ability.AbilityDamageGainStrategy;
import net.kenji.kenjiscombatforms.api.interfaces.ability.AbstractAbilityData;
import net.kenji.kenjiscombatforms.api.managers.AbilityManager;
import net.kenji.kenjiscombatforms.config.EpicFightCombatFormsCommon;
import net.kenji.kenjiscombatforms.event.CommonFunctions;
import net.kenji.kenjiscombatforms.network.NetworkHandler;
import net.kenji.kenjiscombatforms.network.swift_form.ability2.SwiftEffectInflictPacket;
import net.kenji.kenjiscombatforms.network.swift_form.ability2.SyncSwiftData2Packet;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.util.thread.EffectiveSide;
import net.minecraftforge.network.PacketDistributor;

public class SwiftEffectInflict
implements Ability {
    private final SwiftPlayerDataSets dataSets = SwiftPlayerDataSets.getInstance();
    private final Map<UUID, SwiftPlayerDataSets.SwiftInflictPlayerData> playerDataMap;
    private static final SwiftEffectInflict INSTANCE = new SwiftEffectInflict();
    private final CommonFunctions dataHandlers;

    @Override
    public String getName() {
        return AbilityManager.AbilityOption2.SWIFT_ABILITY2.name();
    }

    SwiftPlayerDataSets.SwiftInflictPlayerData getPlayerData(Player player) {
        return (SwiftPlayerDataSets.SwiftInflictPlayerData)this.getAbilityData(player);
    }

    public SwiftEffectInflict() {
        this.playerDataMap = this.dataSets.A2playerDataMap;
        this.dataHandlers = CommonFunctions.getInstance();
    }

    public static SwiftEffectInflict getInstance() {
        return INSTANCE;
    }

    public float getAbilityCooldown(Player player) {
        SwiftPlayerDataSets.SwiftInflictPlayerData data = this.getPlayerData(player);
        return data.abilityCooldown;
    }

    public void setAbilityCooldown(Player player) {
        SwiftPlayerDataSets.SwiftInflictPlayerData data = this.getPlayerData(player);
        data.abilityCooldown = data.getMAX_COOLDOWN();
    }

    @Override
    public AbstractAbilityData getAbilityData(Player player) {
        return this.dataSets.getOrCreateSwiftInflictPlayerData(player);
    }

    @Override
    public void fillPerSecondCooldown(Player player) {
        SwiftPlayerDataSets.SwiftInflictPlayerData data = this.getPlayerData(player);
        int cooldown = data.abilityCooldown;
        if (cooldown > 0) {
            data.tickCount = this.dataHandlers.getTickCount(data.tickCount);
            data.abilityCooldown = this.dataHandlers.decreaseCooldown(data.abilityCooldown, data.tickCount);
        }
    }

    @Override
    public void drainPerSecondCooldown(Player player) {
        SwiftPlayerDataSets.SwiftInflictPlayerData data = this.getPlayerData(player);
        data.tickCount = this.dataHandlers.getTickCount(data.tickCount);
        data.abilityCooldown = this.dataHandlers.increaseCooldown(data.abilityCooldown, data.tickCount);
    }

    @Override
    public boolean getAbilityActive(Player player) {
        return this.getAbilityData(player).isAbilityActive();
    }

    @Override
    public void sendPacketToServer(Player player) {
        if (!ClientEventHandler.getInstance().getAreFinalsActive()) {
            NetworkHandler.INSTANCE.sendToServer((Object)new SwiftEffectInflictPacket());
        }
    }

    @Override
    public void triggerAbility(ServerPlayer serverPlayer) {
        long currentTime = System.currentTimeMillis();
        SwiftPlayerDataSets.SwiftInflictPlayerData data = this.getPlayerData((Player)serverPlayer);
        if (data.abilityCooldown <= 0 && !data.isInflictActive) {
            this.activateAbility(serverPlayer);
            this.playSound((Player)serverPlayer);
        } else if (data.isInflictActive) {
            this.deactivateAbilityOptional(serverPlayer);
        }
    }

    @Override
    public void activateAbility(ServerPlayer player) {
        SwiftPlayerDataSets.SwiftInflictPlayerData data = this.getPlayerData((Player)player);
        data.isInflictActive = true;
    }

    @Override
    public void deactivateAbilityOptional(ServerPlayer serverPlayer) {
        SwiftPlayerDataSets.SwiftInflictPlayerData data = this.getPlayerData((Player)serverPlayer);
        if (data.isInflictActive) {
            data.isInflictActive = false;
        }
    }

    @Override
    public void decrementCooldown(Player player) {
        SwiftPlayerDataSets.SwiftInflictPlayerData data = this.playerDataMap.computeIfAbsent(player.m_20148_(), k -> new SwiftPlayerDataSets.SwiftInflictPlayerData());
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (EffectiveSide.get() == LogicalSide.SERVER) {
                if (!((Boolean)EpicFightCombatFormsCommon.ABILITY2_COMBAT_MODE.get()).booleanValue() && !data.isInflictActive) {
                    this.fillPerSecondCooldown(player);
                }
                if (data.abilityCooldown < data.getMAX_COOLDOWN() && data.isInflictActive) {
                    this.drainPerSecondCooldown(player);
                }
                if (data.abilityCooldown >= data.getMAX_COOLDOWN() && data.isInflictActive) {
                    this.deactivateAbilityOptional(serverPlayer);
                }
            }
        }
    }

    @Override
    public void tickServerAbilityData(ServerPlayer player) {
        SwiftPlayerDataSets.SwiftInflictPlayerData data = this.getPlayerData((Player)player);
        AbilityManager.PlayerAbilityData abilityData = AbilityManager.getInstance().getPlayerAbilityData((Player)player);
        if (abilityData.chosenAbility2.name().equals(this.getName())) {
            SwiftEffectInflict.getInstance().decrementCooldown((Player)player);
            this.syncDataToClient(player);
        }
    }

    @Override
    public void tickClientAbilityData(Player player) {
    }

    @Override
    public void syncDataToClient(ServerPlayer player) {
        SwiftPlayerDataSets.SwiftInflictPlayerData data = this.getPlayerData((Player)player);
        if (this.isAbilityChosenOrEquipped((Player)player)) {
            NetworkHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> player), (Object)new SyncSwiftData2Packet(data.abilityCooldown));
        }
    }

    public boolean isAbilityChosenOrEquipped(Player player) {
        AbilityManager.PlayerAbilityData abilityData = AbilityManager.getInstance().getPlayerAbilityData(player);
        return abilityData.chosenAbility2.name().equals(this.getName());
    }

    @Override
    public void playSound(Player player) {
        player.m_9236_().m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12049_, SoundSource.PLAYERS, 1.0f, 1.0f);
    }

    @Override
    public void playSound2(Player player) {
    }

    public static class CurrentDamageGainStrategy
    implements AbilityDamageGainStrategy {
        @Override
        public void fillDamageCooldown(Player player) {
            SwiftPlayerDataSets.SwiftInflictPlayerData data = SwiftEffectInflict.getInstance().getPlayerData(player);
            if (((Boolean)EpicFightCombatFormsCommon.ABILITY2_COMBAT_MODE.get()).booleanValue() && !data.isAbilityActive()) {
                if (data.abilityCooldown > 0) {
                    data.abilityCooldown -= ((Integer)EpicFightCombatFormsCommon.COMBAT_MODE_GAIN_AMOUNT.get()).intValue();
                }
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    SwiftEffectInflict.getInstance().syncDataToClient(serverPlayer);
                }
            }
        }
    }

    @Mod.EventBusSubscriber(modid="kenjiscombatforms", bus=Mod.EventBusSubscriber.Bus.FORGE)
    public static class ServerForgeEvents {
        @SubscribeEvent
        public static void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent event) {
            Player player = event.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                SwiftEffectInflict.getInstance().getPlayerData((Player)serverPlayer);
                SwiftEffectInflict.getInstance().syncDataToClient(serverPlayer);
            }
        }

        @SubscribeEvent
        public static void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
            Player player = event.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                SwiftEffectInflict.getInstance().setAbilityCooldown((Player)serverPlayer);
                SwiftEffectInflict.getInstance().syncDataToClient(serverPlayer);
            }
        }

        @SubscribeEvent
        public static void onPlayerLogout(PlayerEvent.PlayerLoggedOutEvent event) {
            SwiftEffectInflict.getInstance().playerDataMap.remove(event.getEntity().m_20148_());
        }

        @SubscribeEvent
        public static void onPlayerClone(PlayerEvent.Clone event) {
            Player player = event.getOriginal();
            if (player instanceof ServerPlayer) {
                ServerPlayer originalPlayer = (ServerPlayer)player;
                player = event.getEntity();
                if (player instanceof ServerPlayer) {
                    ServerPlayer newPlayer = (ServerPlayer)player;
                    SwiftPlayerDataSets.SwiftInflictPlayerData originalData = SwiftEffectInflict.getInstance().getPlayerData((Player)originalPlayer);
                    SwiftPlayerDataSets.SwiftInflictPlayerData newData = SwiftEffectInflict.getInstance().getPlayerData((Player)newPlayer);
                    SwiftEffectInflict.getInstance().syncDataToClient(newPlayer);
                }
            }
        }

        @SubscribeEvent
        public static void onLivingEntityHurt(LivingHurtEvent event) {
            LivingEntity entity = event.getEntity();
            Entity entity2 = event.getSource().m_7639_();
            if (entity2 instanceof Player) {
                Player player = (Player)entity2;
                SwiftPlayerDataSets.SwiftInflictPlayerData data = SwiftEffectInflict.getInstance().getPlayerData(player);
                if (data.isInflictActive) {
                    entity.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 200, 1, true, true));
                }
            }
        }
    }
}

