/*
 * Decompiled with CFR 0.152.
 */
package net.kenji.kenjiscombatforms.block.custom;

import java.util.List;
import net.kenji.kenjiscombatforms.network.NetworkHandler;
import net.kenji.kenjiscombatforms.network.particle_packets.RiftParticlesTickPacket;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;

public class VoidRiftBlock
extends Block {
    public static final VoxelShape SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)6.0, (double)6.0, (double)6.0);
    public static final int PULL_RADIUS = 10;

    public VoidRiftBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
    }

    @NotNull
    public VoxelShape m_5940_(@NotNull BlockState p_60555_, @NotNull BlockGetter p_60556_, @NotNull BlockPos p_60557_, @NotNull CollisionContext p_60558_) {
        return SHAPE;
    }

    @NotNull
    public RenderShape m_7514_(@NotNull BlockState p_49232_) {
        return RenderShape.MODEL;
    }

    public boolean canEntityDestroy(BlockState state, BlockGetter level, BlockPos pos, Entity entity) {
        return true;
    }

    public boolean onDestroyedByPlayer(BlockState state, Level level, BlockPos pos, Player player, boolean willHarvest, FluidState fluid) {
        return level.m_7731_(pos, fluid.m_76188_(), level.f_46443_ ? 11 : 3);
    }

    public void m_214162_(BlockState state, Level level, BlockPos pos, RandomSource random) {
        if (level.f_46443_) {
            // empty if block
        }
    }

    public void m_6807_(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean isMoving) {
        if (!level.f_46443_) {
            level.m_186460_(pos, (Block)this, 20);
        }
    }

    public void m_213897_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        this.pullNearbyEntities(level, pos);
        level.m_186460_(pos, (Block)this, 2);
        this.sendParticlePacket(level, pos);
    }

    private void pullNearbyEntities(ServerLevel level, BlockPos pos) {
        AABB pullArea = new AABB(pos).m_82400_(10.0);
        List entities = level.m_6443_(Entity.class, pullArea, entity -> !(entity instanceof Player) || !((Player)entity).m_150110_().f_35935_);
        for (Entity entity2 : entities) {
            this.applyPull(entity2, pos);
        }
    }

    private void sendParticlePacket(ServerLevel level, BlockPos pos) {
        for (ServerPlayer player : level.m_7654_().m_6846_().m_11314_()) {
            if (player.m_9236_() != level) continue;
            int viewDistance = player.m_20194_().m_6846_().m_11312_() * 16;
            if (!player.m_20183_().m_123314_((Vec3i)pos, (double)viewDistance)) continue;
            NetworkHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> player), (Object)new RiftParticlesTickPacket(pos, 10, 4, 1));
        }
    }

    private void applyPull(Entity entity, BlockPos riftPos) {
        Vec3 pullVector = Vec3.m_82512_((Vec3i)riftPos).m_82546_(entity.m_20182_()).m_82541_();
        double strength = 0.1;
        entity.m_20256_(entity.m_20184_().m_82549_(pullVector.m_82490_(strength)));
    }
}

