/*
 * Decompiled with CFR 0.152.
 */
package net.kenji.kenjiscombatforms.block.entity;

import java.util.List;
import java.util.Optional;
import net.kenji.kenjiscombatforms.block.entity.ModBlockEntities;
import net.kenji.kenjiscombatforms.recipe.ScrollFormingRecipe;
import net.kenji.kenjiscombatforms.screen.ScrollFormingMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ScrollFormingBlockEntity
extends BlockEntity
implements MenuProvider {
    public final ItemStackHandler handler = new ItemStackHandler(5);
    private final int INPUT_SLOT = 0;
    private final int INPUT_SLOT2 = 2;
    private final int INPUT_SLOT3 = 3;
    private final int FUEL_SLOT = 4;
    private final int OUTPUT_SLOT = 1;
    private Player interactPlayer;
    TagKey<Item> fuelItemsTag = ItemTags.create((ResourceLocation)new ResourceLocation("kenjiscombatforms", "ability_fuel_items"));
    private LazyOptional<IItemHandler> LazyItemHandler = LazyOptional.empty();
    protected final ContainerData data;
    private int progress = 0;
    private int progress_max = 120;
    int fuelCounter = 0;
    int fuelCounterMax = 8;
    public boolean hasPlayedSound = false;
    boolean fuelBoolean = false;
    ItemStack fuelSlotVar = this.handler.getStackInSlot(4);
    boolean canContinue = false;

    public ScrollFormingBlockEntity(BlockPos p_155229_, BlockState p_155230_) {
        super((BlockEntityType)ModBlockEntities.SCROLL_FORMING_TABLE_BE.get(), p_155229_, p_155230_);
        this.data = new ContainerData(){

            public int m_6413_(int pIndex) {
                return switch (pIndex) {
                    case 0 -> ScrollFormingBlockEntity.this.progress;
                    case 1 -> ScrollFormingBlockEntity.this.progress_max;
                    case 2 -> ScrollFormingBlockEntity.this.fuelCounter;
                    case 3 -> ScrollFormingBlockEntity.this.fuelCounterMax;
                    default -> 0;
                };
            }

            public void m_8050_(int pIndex, int pValue) {
                switch (pIndex) {
                    case 0: {
                        ScrollFormingBlockEntity.this.progress = pValue;
                        break;
                    }
                    case 1: {
                        ScrollFormingBlockEntity.this.progress_max = pValue;
                        break;
                    }
                    case 2: {
                        ScrollFormingBlockEntity.this.fuelCounter = pValue;
                        break;
                    }
                    case 3: {
                        ScrollFormingBlockEntity.this.fuelCounterMax = pValue;
                    }
                }
            }

            public int m_6499_() {
                return 4;
            }
        };
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.LazyItemHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    public void onLoad() {
        super.onLoad();
        this.LazyItemHandler = LazyOptional.of(() -> this.handler);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.LazyItemHandler.invalidate();
    }

    public void drops() {
        SimpleContainer Inventory2 = new SimpleContainer(this.handler.getSlots());
        for (int i = 0; i < this.handler.getSlots(); ++i) {
            Inventory2.m_6836_(i, this.handler.getStackInSlot(i));
        }
        Containers.m_19002_((Level)this.f_58857_, (BlockPos)this.f_58858_, (Container)Inventory2);
    }

    @NotNull
    public Component m_5446_() {
        return Component.m_237115_((String)"block.scroll_forming_table");
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int pContainer, Inventory pInventory, Player player) {
        this.interactPlayer = player;
        return new ScrollFormingMenu(pContainer, pInventory, this, this.data);
    }

    public Player getInteractPlayer() {
        return this.interactPlayer;
    }

    protected void m_183515_(CompoundTag pTag) {
        pTag.m_128365_("inventory", (Tag)this.handler.serializeNBT());
        pTag.m_128405_("scroll_forming_table.progress", this.progress);
        super.m_183515_(pTag);
    }

    public void m_142466_(CompoundTag pTag) {
        super.m_142466_(pTag);
        this.handler.deserializeNBT(pTag.m_128469_("inventory"));
        this.progress = pTag.m_128451_("scroll_forming_table.progress");
    }

    public void tick(Level level1, BlockPos blockPos, BlockState blockState1) {
        this.serverSideLogic(level1, blockPos, blockState1);
    }

    private void serverSideLogic(Level level1, BlockPos blockPos, BlockState blockState1) {
        if (this.isCraftingValid().booleanValue()) {
            ScrollFormingBlockEntity.m_155232_((Level)level1, (BlockPos)blockPos, (BlockState)blockState1);
            this.showCraftItem();
        }
    }

    public Boolean isCraftingValid() {
        return this.hasRecipe();
    }

    private void showCraftItem() {
        Optional<ScrollFormingRecipe> recipe = this.getCurrentRecipe();
        ItemStack result = recipe.get().m_8043_(null);
        this.handler.setStackInSlot(1, new ItemStack((ItemLike)result.m_41720_(), this.handler.getStackInSlot(1).m_41613_() + result.m_41613_()));
    }

    public void removeCraftItem() {
        this.handler.setStackInSlot(1, ItemStack.f_41583_);
    }

    public void craftItem() {
        Optional<ScrollFormingRecipe> recipe = this.getCurrentRecipe();
        if (recipe.isPresent()) {
            ScrollFormingRecipe currentRecipe = recipe.get();
            List<Integer> counts = currentRecipe.getCounts();
            this.handler.extractItem(0, counts.get(0).intValue(), false);
            this.handler.extractItem(2, counts.get(1).intValue(), false);
            this.handler.extractItem(3, counts.get(2).intValue(), false);
        }
    }

    public boolean hasRecipe() {
        Optional<ScrollFormingRecipe> recipe = this.getCurrentRecipe();
        if (recipe.isEmpty()) {
            return false;
        }
        ItemStack result = recipe.get().m_8043_(this.m_58904_().m_9598_());
        return this.canInsertAmountInOutputSlot(result.m_41613_()) && this.canInsertItemInOutputSlot(result.m_41720_());
    }

    private Optional<ScrollFormingRecipe> getCurrentRecipe() {
        SimpleContainer inventory = new SimpleContainer(this.handler.getSlots());
        for (int i = 0; i < this.handler.getSlots(); ++i) {
            inventory.m_6836_(i, this.handler.getStackInSlot(i));
        }
        return this.f_58857_.m_7465_().m_44015_((RecipeType)ScrollFormingRecipe.Type.INSTANCE, (Container)inventory, this.f_58857_);
    }

    private boolean canInsertItemInOutputSlot(Item item) {
        return this.handler.getStackInSlot(1).m_41619_() || this.handler.getStackInSlot(1).m_150930_(item);
    }

    private boolean canInsertAmountInOutputSlot(int count) {
        return this.handler.getStackInSlot(1).m_41613_() + count <= this.handler.getStackInSlot(1).m_41741_();
    }
}

