/*
 * Decompiled with CFR 0.152.
 */
package net.kenji.kenjiscombatforms.commands;

import com.mojang.brigadier.Message;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import net.kenji.kenjiscombatforms.api.interfaces.form.AbstractFormData;
import net.kenji.kenjiscombatforms.api.interfaces.form.Form;
import net.kenji.kenjiscombatforms.api.managers.FormLevelManager;
import net.kenji.kenjiscombatforms.api.managers.FormManager;
import net.kenji.kenjiscombatforms.config.EpicFightCombatFormsCommon;
import net.kenji.kenjiscombatforms.network.NetworkHandler;
import net.kenji.kenjiscombatforms.network.fist_forms.form_level.SyncServerFormLevelPacket;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public class LevelUpCurrentForm {
    private static final SimpleCommandExceptionType RESET_FAILED = new SimpleCommandExceptionType((Message)Component.m_237113_((String)"Failed to level up"));

    public static LiteralArgumentBuilder<CommandSourceStack> register() {
        return (LiteralArgumentBuilder)Commands.m_82127_((String)"kenjiscombatforms").then(((LiteralArgumentBuilder)Commands.m_82127_((String)"level_up_form").requires(source -> source.m_6761_(2))).executes(context -> LevelUpCurrentForm.resetFormLevels((CommandSourceStack)context.getSource())));
    }

    private static int resetFormLevels(CommandSourceStack source) throws CommandSyntaxException {
        ServerPlayer player = source.m_230896_();
        if (player != null) {
            FormManager.PlayerFormData formData = FormManager.getInstance().getOrCreatePlayerFormData((Player)player);
            FormManager.FormSelectionOption currentForm = formData.selectedForm;
            Form form = FormManager.getInstance().getForm(currentForm.name());
            AbstractFormData currentFormData = form.getFormData(player.m_20148_());
            int addedXPMAX = currentFormData.getCurrentFormXpMAX() * (Integer)EpicFightCombatFormsCommon.LEVEL2_FORM_MAX_XP_ADDITION.get();
            switch (currentFormData.getCurrentFormLevel()) {
                case LEVEL1: {
                    NetworkHandler.INSTANCE.sendToServer((Object)new SyncServerFormLevelPacket(form.getName(), currentFormData.getCurrentFormXp(), addedXPMAX, FormLevelManager.FormLevel.LEVEL2));
                    break;
                }
                case LEVEL2: {
                    NetworkHandler.INSTANCE.sendToServer((Object)new SyncServerFormLevelPacket(form.getName(), currentFormData.getCurrentFormXp(), currentFormData.getCurrentFormXpMAX(), FormLevelManager.FormLevel.LEVEL3));
                }
            }
        }
        source.m_288197_(() -> Component.m_237113_((String)"You have leveled up your current form"), true);
        return 1;
    }
}

