/*
 * Decompiled with CFR 0.152.
 */
package net.kenji.kenjiscombatforms.commands;

import com.mojang.brigadier.Message;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import net.kenji.kenjiscombatforms.api.handlers.power_data.EnderPlayerDataSets;
import net.kenji.kenjiscombatforms.api.handlers.power_data.WitherPlayerDataSets;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;

public class RefillAllAbilityCooldowns {
    private static final SimpleCommandExceptionType RESET_FAILED = new SimpleCommandExceptionType((Message)Component.m_237113_((String)"Failed to refill cooldowns"));

    public static LiteralArgumentBuilder<CommandSourceStack> register() {
        return (LiteralArgumentBuilder)Commands.m_82127_((String)"kenjiscombatforms").then(((LiteralArgumentBuilder)Commands.m_82127_((String)"refill_ability_cooldowns").requires(source -> source.m_6761_(2))).executes(context -> RefillAllAbilityCooldowns.refillAbilityCooldowns((CommandSourceStack)context.getSource())));
    }

    private static int refillAbilityCooldowns(CommandSourceStack source) throws CommandSyntaxException {
        EnderPlayerDataSets enderPlayerDataSets = EnderPlayerDataSets.getInstance();
        WitherPlayerDataSets witherPlayerDataSets = WitherPlayerDataSets.getInstance();
        RefillAllAbilityCooldowns.resetAllCooldowns((Player)source.m_230896_(), enderPlayerDataSets, witherPlayerDataSets);
        source.m_288197_(() -> Component.m_237113_((String)"Have refilled all cooldowns to max value"), true);
        return 1;
    }

    private static void resetAllCooldowns(Player player, EnderPlayerDataSets enderDataSets, WitherPlayerDataSets witherDataSets) {
        EnderPlayerDataSets.TeleportPlayerData tData = enderDataSets.getOrCreateTeleportPlayerData(player);
        EnderPlayerDataSets.VoidRiftPlayerData vData = enderDataSets.getOrCreateVoidRiftPlayerData(player);
        EnderPlayerDataSets.EnderFormPlayerData eData = enderDataSets.getOrCreateEnderFormPlayerData(player);
        WitherPlayerDataSets.WitherDashPlayerData dData = witherDataSets.getOrCreateDashPlayerData(player);
        WitherPlayerDataSets.SoulDriftPlayerData sData = witherDataSets.getOrCreateSoulDriftPlayerData(player);
        WitherPlayerDataSets.WitherFormPlayerData wData = witherDataSets.getOrCreateWitherFormPlayerData(player);
        EnderPlayerDataSets.VoidGrabPlayerData vgData = enderDataSets.getOrCreateVoidGrabPlayerData(player);
        WitherPlayerDataSets.WitherMinionPlayerData wmData = witherDataSets.getOrCreateMinionPlayerData(player);
        WitherPlayerDataSets.WitherImplodePlayerData wiData = witherDataSets.getOrCreateWitherImplodePlayerData(player);
        tData.abilityCooldown = tData.getMAX_COOLDOWN();
        vData.abilityCooldown = vData.getMAX_COOLDOWN();
        eData.abilityCooldown = eData.getMAX_COOLDOWN();
        dData.abilityCooldown = dData.getMAX_COOLDOWN();
        sData.abilityCooldown = sData.getMAX_COOLDOWN();
        wData.abilityCooldown = wData.getMAX_COOLDOWN();
        vgData.abilityCooldown = vgData.getMAX_COOLDOWN();
        wmData.abilityCooldown = wmData.getMAX_COOLDOWN();
        wiData.abilityCooldown = wiData.getMAX_COOLDOWN();
    }
}

