/*
 * Decompiled with CFR 0.152.
 */
package net.kenji.kenjiscombatforms.entity.custom.SenseiEntities;

import java.util.List;
import java.util.Objects;
import java.util.Random;
import net.kenji.kenjiscombatforms.config.EpicFightCombatFormsCommon;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExiledDevilEntity
extends PathfinderMob {
    boolean hasBeenDamaged = false;
    private float lastHealth;
    public static final Random RANDOM = new Random();

    public ExiledDevilEntity(EntityType<? extends PathfinderMob> p_34368_, Level p_34369_) {
        super(p_34368_, p_34369_);
    }

    void damageDetect() {
        float currentHealth = this.m_21223_();
        if (currentHealth < this.lastHealth) {
            this.hasBeenDamaged = true;
        }
        this.lastHealth = currentHealth;
    }

    public void m_7380_(@NotNull CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128379_("hasBeenDamaged", this.hasBeenDamaged);
    }

    public void m_7378_(@NotNull CompoundTag compound) {
        super.m_7378_(compound);
        this.hasBeenDamaged = compound.m_128471_("hasBeenDamaged");
    }

    private static boolean isCompatDifficulty() {
        return (Boolean)EpicFightCombatFormsCommon.DIFFICULTY_COMPAT_MODE.get();
    }

    public void onAddedToWorld() {
        if (!ExiledDevilEntity.isCompatDifficulty()) {
            Objects.requireNonNull(this.m_21051_(Attributes.f_22276_)).m_22100_((double)((Integer)EpicFightCombatFormsCommon.EXILED_DEVIL_HEALTH.get()).intValue());
            if (!this.hasBeenDamaged) {
                this.m_21153_(this.m_21233_());
            }
        } else {
            Objects.requireNonNull(this.m_21051_(Attributes.f_22276_)).m_22100_((double)((Integer)EpicFightCombatFormsCommon.COMPAT_MODE_EXILED_DEVIL_HEALTH.get()).intValue());
            if (!this.hasBeenDamaged) {
                this.m_21153_(this.m_21233_());
            }
        }
    }

    public void m_6703_(@Nullable LivingEntity entity) {
        double chance = RANDOM.nextDouble();
        if (entity != null && chance < 0.15) {
            entity.m_7292_(new MobEffectInstance(MobEffects.f_19610_, 45, 0, true, true));
            entity.m_7292_(new MobEffectInstance(MobEffects.f_19614_, 55, 0, true, true));
        }
        super.m_6703_(entity);
    }

    public void m_21335_(@Nullable Entity entity) {
        double chance = RANDOM.nextDouble();
        LivingEntity lEntity = (LivingEntity)entity;
        if (lEntity != null) {
            if (chance > 0.25 && chance < 0.35) {
                entity.m_20254_(4);
            } else if (chance < 0.25) {
                lEntity.m_7292_(new MobEffectInstance(MobEffects.f_19615_, 80, 0, true, true));
                lEntity.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 160, 0, true, true));
            } else {
                entity.m_20254_(0);
            }
        }
        assert (entity != null);
        super.m_21335_(entity);
    }

    public boolean m_7252_(@NotNull ItemStack stack) {
        return false;
    }

    public SoundEvent m_7515_() {
        return SoundEvents.f_12307_;
    }

    public SoundEvent m_7975_(@NotNull DamageSource p_34327_) {
        return SoundEvents.f_12310_;
    }

    public SoundEvent m_5592_() {
        return SoundEvents.f_12309_;
    }

    public float m_6113_() {
        if (this.m_5448_() != null) {
            return 0.13f;
        }
        return 0.1f;
    }

    public boolean m_21531_() {
        return false;
    }

    public boolean m_7066_(ItemStack p_21522_) {
        return false;
    }

    protected boolean m_21527_() {
        return false;
    }

    public boolean m_5825_() {
        return true;
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.addBehaviourGoals();
    }

    protected void addBehaviourGoals() {
        this.f_21345_.m_25352_(1, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        if (this.m_271686_() != null) {
            this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, this.m_271686_().getClass(), true));
        }
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
    }

    public void m_21008_(@NotNull InteractionHand p_21009_, @NotNull ItemStack p_21010_) {
        super.m_21008_(p_21009_, p_21010_);
    }

    public void m_8119_() {
        super.m_8119_();
        this.damageDetect();
    }

    public boolean m_21515_() {
        return super.m_21515_();
    }

    public boolean m_142389_() {
        return super.m_142389_();
    }

    public static boolean checkSpawnRules(EntityType<? extends ExiledDevilEntity> entityType, ServerLevelAccessor level, MobSpawnType spawnType, BlockPos pos, RandomSource random) {
        double chance = RANDOM.nextDouble();
        if (level.m_6042_().f_63857_() && level.m_46791_() != Difficulty.PEACEFUL && level.m_8055_(pos.m_7495_()).m_280296_() && level.m_8055_(pos).m_60795_() && level.m_8055_(pos.m_7494_()).m_60795_()) {
            int searchRadius = (Integer)EpicFightCombatFormsCommon.EXILED_DEVIL_SPAWNDIST.get();
            List nearbyEntities = level.m_6443_(ExiledDevilEntity.class, new AABB(pos).m_82400_((double)searchRadius), e -> true);
            if (chance < (Double)EpicFightCombatFormsCommon.EXILED_DEVIL_SPAWN_CHANCE.get() && nearbyEntities.isEmpty()) {
                return true;
            }
        }
        return false;
    }
}

