/*
 * Decompiled with CFR 0.152.
 */
package net.kenji.kenjiscombatforms.entity.custom.SenseiEntities;

import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.UUID;
import net.kenji.kenjiscombatforms.config.EpicFightCombatFormsCommon;
import net.kenji.kenjiscombatforms.entity.ModEntities;
import net.kenji.kenjiscombatforms.entity.custom.SenseiEntities.UndeadSenseiEntity;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.FollowOwnerGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtTargetGoal;
import net.minecraft.world.entity.monster.Evoker;
import net.minecraft.world.entity.monster.Pillager;
import net.minecraft.world.entity.monster.Vindicator;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExiledSenseiEntity
extends TamableAnimal
implements NeutralMob {
    boolean isStaying = false;
    boolean canWander = false;
    boolean isDefensive = false;
    int healDelayThresh = 120;
    @Nullable
    private Boolean isAfraidCache = false;
    @Nullable
    private Boolean isAngryCache = false;
    private Boolean isAngryCacheLock = true;
    int waitNumb = 0;
    boolean hasInteracted = false;
    private boolean canInteract = true;
    private long lastInteractionTime = 0L;
    private static final long INTERACTION_COOLDOWN = 250L;
    private int interactionCooldownTicks = 0;
    int healTimeInt = 0;
    int healDelayInt = 0;
    boolean healTickAllow;
    boolean canRegen = true;
    boolean hasBeenDamaged = false;
    private final RandomStrollGoal wanderGoal = new RandomStrollGoal((PathfinderMob)this, 0.5, 1);
    private final FollowOwnerGoal followGoal = new FollowOwnerGoal((TamableAnimal)this, 1.25, 5.0f, 3.0f, true);
    private final SitWhenOrderedToGoal stayGoal = new SitWhenOrderedToGoal((TamableAnimal)this);
    private final OwnerHurtTargetGoal targetOwnerAttacker = new OwnerHurtTargetGoal((TamableAnimal)this);
    private final AvoidEntityGoal<Player> avoidPlayerGoal = new AvoidEntityGoal((PathfinderMob)this, Player.class, 6.0f, 1.4, 1.0);
    boolean isAfraidCacheLock = false;
    private float lastHealth;
    public static final Random RANDOM = new Random();
    Player playerEntity;
    Entity undeadSensei;
    private int interactionState = 0;
    private int interactionState2 = 0;
    Player interactPlayer;
    int tameProgress = 0;
    private String lastMessage = "";
    private long lastMessageTime = 0L;

    public ExiledSenseiEntity(EntityType<? extends TamableAnimal> p_34368_, Level p_34369_) {
        super(p_34368_, p_34369_);
    }

    public int m_6784_() {
        return 0;
    }

    public void m_7870_(int i) {
    }

    @Nullable
    public UUID m_6120_() {
        return null;
    }

    public void m_6925_(@Nullable UUID uuid) {
    }

    public void m_6825_() {
    }

    public void m_21676_(@NotNull Player p_21677_) {
        super.m_21676_(p_21677_);
    }

    public boolean m_7252_(ItemStack stack) {
        return false;
    }

    public SoundEvent m_7515_() {
        return SoundEvents.f_12307_;
    }

    public SoundEvent m_7975_(DamageSource p_34327_) {
        return SoundEvents.f_12310_;
    }

    public SoundEvent m_5592_() {
        return SoundEvents.f_12309_;
    }

    public float m_6113_() {
        if (this.m_5448_() != null) {
            return 0.13f;
        }
        return 0.1f;
    }

    protected boolean m_21527_() {
        return false;
    }

    public boolean m_21531_() {
        return false;
    }

    public boolean m_7066_(ItemStack p_21522_) {
        return false;
    }

    public boolean m_21674_(@NotNull LivingEntity livingEntity) {
        Player player = (Player)livingEntity;
        return super.m_21674_((LivingEntity)player);
    }

    public void m_7380_(@NotNull CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("interactionState", this.interactionState);
        compound.m_128405_("interactionState2", this.interactionState2);
        compound.m_128379_("isDefensive", this.isDefensive);
        compound.m_128379_("isStaying", this.isStaying);
        compound.m_128379_("canWander", this.canWander);
        compound.m_128379_("hasBeenDamaged", this.hasBeenDamaged);
        compound.m_128359_("lastMessage", this.lastMessage);
        compound.m_128356_("lastMessageTime", this.lastMessageTime);
        if (Boolean.TRUE.equals(this.isAfraidCache)) {
            compound.m_128379_("isAfraidCache", this.isAfraidCache.booleanValue());
        }
    }

    public void m_7378_(@NotNull CompoundTag compound) {
        super.m_7378_(compound);
        this.interactionState = compound.m_128451_("interactionState");
        this.interactionState2 = compound.m_128451_("interactionState2");
        this.isDefensive = compound.m_128471_("isDefensive");
        this.isStaying = compound.m_128471_("isStaying");
        this.canWander = compound.m_128471_("canWander");
        this.hasBeenDamaged = compound.m_128471_("hasBeenDamaged");
        this.lastMessage = compound.m_128461_("lastMessage");
        this.lastMessageTime = compound.m_128454_("lastMessageTime");
        this.isAfraidCache = compound.m_128471_("isAfraidCache");
    }

    public void resetState() {
        this.isStaying = false;
        this.canWander = false;
        this.lastInteractionTime = 0L;
    }

    private static boolean isCompatDifficulty() {
        return (Boolean)EpicFightCombatFormsCommon.DIFFICULTY_COMPAT_MODE.get();
    }

    public void onAddedToWorld() {
        if (this.m_21824_()) {
            Objects.requireNonNull(this.m_21051_(Attributes.f_22276_)).m_22100_((double)((Integer)EpicFightCombatFormsCommon.TAMED_EXILED_SENSEI_HEALTH.get()).intValue());
        } else if (!this.m_21824_()) {
            Objects.requireNonNull(this.m_21051_(Attributes.f_22276_)).m_22100_((double)((Integer)EpicFightCombatFormsCommon.EXILED_SENSEI_HEALTH.get()).intValue());
        }
        if (!this.hasBeenDamaged) {
            this.m_21153_(this.m_21233_());
        }
        super.onAddedToWorld();
    }

    public boolean canHeal() {
        if (this.healDelayInt >= this.healDelayThresh) {
            this.canRegen = true;
            return true;
        }
        this.canRegen = false;
        return false;
    }

    public void healFunc() {
        if (this.canHeal() && this.canRegen && this.m_21824_()) {
            this.m_21153_(this.m_21223_() + 0.08f);
        }
    }

    void resetHealing() {
        float currentHealth = this.m_21223_();
        if (currentHealth < this.lastHealth) {
            this.healDelayInt = 0;
            this.tameProgress = 0;
            this.regenSwitch();
            this.resetTameProgress();
            this.hasBeenDamaged = true;
        }
        this.lastHealth = currentHealth;
    }

    public void healDelayTime() {
        if (this.healDelayInt <= this.healDelayThresh) {
            ++this.healDelayInt;
        }
    }

    void regenSwitch() {
        this.canRegen = false;
    }

    void resetTameProgress() {
        this.canRegen = false;
    }

    void isAfraidFunc() {
        double chance = RANDOM.nextDouble();
        float currentHealth = this.m_21223_();
        if (this.m_271686_() != null && currentHealth < (float)((Integer)EpicFightCombatFormsCommon.IS_AFRAID_MIN_HEALTH.get()).intValue() && !this.m_21824_() && !this.isAfraidCacheLock && this.m_271686_().m_7306_((Entity)this.playerEntity)) {
            this.isAfraidCacheLock = true;
            if (chance < (Double)EpicFightCombatFormsCommon.IS_AFRAID_CHANCE.get()) {
                this.isAfraidCache = true;
                System.out.println("Scared Success");
            } else if (chance > (Double)EpicFightCombatFormsCommon.IS_AFRAID_CHANCE.get()) {
                this.isAfraidCache = false;
                System.out.println("Scared Failed");
            }
        }
        this.lastHealth = currentHealth;
        if (Boolean.TRUE.equals(this.isAfraidCache)) {
            this.m_7292_(new MobEffectInstance(MobEffects.f_19619_, 5, 1, true, true));
        }
    }

    protected void m_8099_() {
        this.randomGoals();
        this.commandGoals();
        this.attackingGoals();
        this.naturalAggroGoals();
    }

    void commandGoals() {
        this.sitGoalFunc();
        this.followGoalFunc();
        this.wanderGoalFunc();
        this.attackOwnerAttacker();
    }

    void interactDelay() {
        if (this.interactionCooldownTicks > 0) {
            --this.interactionCooldownTicks;
            if (this.interactionCooldownTicks == 0) {
                this.canInteract = true;
            }
        }
    }

    public void removeAfraid() {
        if (this.tameProgress != 0 && !this.m_21824_()) {
            this.f_21345_.m_25363_(this.avoidPlayerGoal);
        }
        if (this.tameProgress >= 1 && !this.m_21824_()) {
            this.f_21345_.m_25352_(2, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 5.0f));
        }
    }

    Boolean isStayingAction() {
        return this.isStaying && this.m_21824_();
    }

    Boolean isFollowing() {
        return !this.isStaying && !this.canWander && this.m_21824_();
    }

    Boolean isWandering() {
        return this.canWander && this.m_21824_();
    }

    public void resetAfraidState() {
        this.isAfraidCache = false;
    }

    public void m_8119_() {
        super.m_8119_();
        this.resetHealing();
        this.removeAfraid();
        this.interactDelay();
        this.commandGoals();
        this.healDelayTime();
        this.canHeal();
        this.healFunc();
        this.isAfraidFunc();
    }

    public boolean m_21660_() {
        return !Boolean.TRUE.equals(this.isAfraidCache);
    }

    public boolean m_21824_() {
        return super.m_21824_();
    }

    public void m_6703_(@Nullable LivingEntity entity) {
        double chance = RANDOM.nextDouble();
        if (entity instanceof Player) {
            this.playerEntity = (Player)entity;
        }
        if (entity instanceof UndeadSenseiEntity) {
            this.undeadSensei = (UndeadSenseiEntity)entity;
        }
        if (entity != null) {
            if (chance < 0.3) {
                entity.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 180, 0, true, true));
            }
            if (chance < 0.12 && !this.m_21824_() && entity instanceof UndeadSenseiEntity) {
                this.m_21406_((EntityType)ModEntities.UNDEAD_SENSEI.get(), true);
            }
        }
        super.m_6703_(entity);
    }

    public void m_6598_(@Nullable Player player) {
        boolean randomBool = this.m_217043_().m_188499_();
        boolean randomBool2 = this.m_217043_().m_188499_();
        String message = "";
        if (player instanceof Player) {
            String name = this.m_7755_().getString();
            String redName = Component.m_237113_((String)name).m_130940_(ChatFormatting.RED).getString();
            if (Boolean.FALSE.equals(this.isAngryCache) && randomBool && this.m_21223_() > 50.0f && !this.m_21824_()) {
                this.isAngryCache = true;
                this.isAngryCacheLock = true;
                message = "How dare you!";
            }
            if (Boolean.FALSE.equals(this.isAngryCache) && !randomBool && this.m_21223_() > 50.0f && !this.m_21824_()) {
                this.isAngryCache = true;
                this.isAngryCacheLock = true;
                message = "You will die.";
            }
            if (this.isAngryCacheLock.booleanValue() && this.m_21223_() > 50.0f && !this.m_21824_()) {
                String whiteMessage = "\u00a7f" + message;
                player.m_213846_((Component)Component.m_237113_((String)("\u00a7c[" + redName + "\u00a7c]" + whiteMessage)));
                this.isAngryCacheLock = false;
            }
            if (!this.m_21824_()) {
                this.tameProgress = 0;
            }
        }
        super.m_6598_(player);
    }

    public void m_21335_(@Nullable Entity entity) {
        double chance = RANDOM.nextDouble();
        LivingEntity lEntity = (LivingEntity)entity;
        if (entity != null && chance < 0.2) {
            lEntity.m_7292_(new MobEffectInstance(MobEffects.f_19613_, 180, 0, true, true));
        }
        assert (entity != null);
        super.m_21335_(entity);
    }

    protected void m_5834_() {
        this.healDelayInt = 0;
        this.regenSwitch();
        this.m_21195_(MobEffects.f_19605_);
        super.m_5834_();
    }

    protected void randomGoals() {
        this.f_21345_.m_25352_(1, (Goal)new AvoidEntityGoal((PathfinderMob)this, UndeadSenseiEntity.class, 6.0f, 1.4, 1.0));
        if (!this.m_21824_()) {
            this.f_21345_.m_25352_(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
            this.f_21345_.m_25352_(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
            if (Boolean.FALSE.equals(this.isAfraidCache)) {
                this.f_21345_.m_25352_(2, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.5));
            }
        }
    }

    protected void attackingGoals() {
        if (!this.m_21824_()) {
            this.f_21346_.m_25352_(2, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[0]));
            if (this.m_271686_() != null && Boolean.FALSE.equals(this.isAfraidCache)) {
                this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, this.m_271686_().getClass(), 10, true, false, this::m_21674_));
            }
        } else if (this.m_21824_() && this.m_269323_() != null) {
            this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Objects.requireNonNull(Objects.requireNonNull(this.m_269323_()).m_271686_()).getClass(), 10, true, false, this::m_21674_));
        }
    }

    protected void naturalAggroGoals() {
        if (!this.isStaying) {
            this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Pillager.class, true, false));
            this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Vindicator.class, true, false));
            this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Evoker.class, true, false));
        }
    }

    void attackOwnerAttacker() {
        if (this.m_21824_() && this.isDefensive) {
            this.f_21346_.m_25352_(2, (Goal)this.targetOwnerAttacker);
        } else if (this.m_21824_() && !this.isDefensive) {
            this.f_21345_.m_25363_((Goal)this.targetOwnerAttacker);
        }
    }

    void sitGoalFunc() {
        if (this.isStayingAction().booleanValue() && this.m_21824_()) {
            this.f_21345_.m_25352_(2, (Goal)this.stayGoal);
            this.f_21345_.m_25363_((Goal)this.wanderGoal);
            this.f_21345_.m_25363_((Goal)this.followGoal);
            this.m_21839_(true);
        }
    }

    void followGoalFunc() {
        if (this.isFollowing().booleanValue() && this.m_21824_()) {
            this.f_21345_.m_25352_(1, (Goal)this.followGoal);
            this.f_21345_.m_25363_((Goal)this.wanderGoal);
            this.f_21345_.m_25363_((Goal)this.stayGoal);
            this.m_21839_(false);
        }
    }

    void wanderGoalFunc() {
        if (this.isWandering().booleanValue() && this.m_21824_()) {
            this.f_21345_.m_25352_(2, (Goal)this.wanderGoal);
            this.f_21345_.m_25363_((Goal)this.followGoal);
            this.f_21345_.m_25363_((Goal)this.stayGoal);
        }
    }

    void deleteFormItem(Player player) {
        player.m_21205_().m_41764_(0);
    }

    public InteractionResult m_6071_(@NotNull Player player, @NotNull InteractionHand interactionHand) {
        return this.mobInteract2(player, interactionHand, this.m_9236_(), this.m_20183_());
    }

    void playTameSoundEvent(Level level) {
        level.m_5594_(null, this.m_20183_(), SoundEvents.f_12509_, SoundSource.AMBIENT, 4.0f, 0.65f);
    }

    void playTamingProcessEvent(Level level) {
        level.m_5594_(null, this.m_20183_(), SoundEvents.f_12508_, SoundSource.AMBIENT, 4.0f, 0.65f);
    }

    void playCommandSoundEvent(Level level, Player player) {
        level.m_5594_(null, this.m_20183_(), SoundEvents.f_12307_, SoundSource.AMBIENT, 4.0f, 1.25f);
    }

    public InteractionResult mobInteract2(Player player, InteractionHand hand, Level level, BlockPos pos) {
        if (this.m_9236_().f_46443_) {
            return InteractionResult.SUCCESS;
        }
        if (hand != InteractionHand.MAIN_HAND) {
            return InteractionResult.PASS;
        }
        boolean emeraldItem = player.m_21205_().m_150930_(Items.f_42616_);
        boolean formItem = player.m_21205_().m_150930_(EpicFightCombatFormsCommon.getSenseiTameItem());
        int itemCount = player.m_21205_().m_41613_();
        this.interactPlayer = player;
        long currentTime = System.currentTimeMillis();
        if (this.interactPlayer != null && !this.m_9236_().f_46443_ && emeraldItem && itemCount >= (Integer)EpicFightCombatFormsCommon.TAMING_EMERALDS_MIN.get() && this.tameProgress == 0 && Boolean.TRUE.equals(this.isAfraidCache) && !this.m_21824_() && ((Boolean)EpicFightCombatFormsCommon.IS_SENSEI_TAMABLE.get()).booleanValue()) {
            player.m_21205_().m_41764_(itemCount - (Integer)EpicFightCombatFormsCommon.TAMING_EMERALDS_MIN.get());
            this.tameProgress = 1;
            this.playTamingProcessEvent(level);
            return InteractionResult.SUCCESS;
        }
        if (Boolean.TRUE.equals(this.isAfraidCache) && !this.m_21824_() && formItem && this.tameProgress == 1 && ((Boolean)EpicFightCombatFormsCommon.IS_SENSEI_TAMABLE.get()).booleanValue()) {
            String messageTameString = "messages.kenjiscombatforms.tame_message";
            this.m_21828_(player);
            this.deleteFormItem(player);
            this.tameProgress = 2;
            this.isStaying = true;
            this.m_21839_(true);
            this.canWander = false;
            this.resetAfraidState();
            this.tameMessage(player, messageTameString);
            this.lastInteractionTime = currentTime;
            Objects.requireNonNull(this.m_21051_(Attributes.f_22276_)).m_22100_((double)((Integer)EpicFightCombatFormsCommon.TAMED_EXILED_SENSEI_HEALTH.get()).intValue());
            this.m_21153_(this.m_21233_());
            this.m_21195_(MobEffects.f_19619_);
            this.playTameSoundEvent(level);
            return InteractionResult.SUCCESS;
        }
        if (currentTime - this.lastInteractionTime < 250L) {
            return InteractionResult.PASS;
        }
        this.lastInteractionTime = currentTime;
        this.interactionState = (this.interactionState + 1) % 3;
        this.interactionState2 = (this.interactionState2 + 1) % 2;
        String message = null;
        if (this.m_21824_() && !player.m_6047_()) {
            switch (this.interactionState) {
                case 0: {
                    this.isStaying = true;
                    this.canWander = false;
                    this.playCommandSoundEvent(level, player);
                    message = "messages.kenjiscombatforms.stay_message";
                    break;
                }
                case 1: {
                    this.isStaying = false;
                    this.canWander = false;
                    this.playCommandSoundEvent(level, player);
                    message = "messages.kenjiscombatforms.follow_message";
                    break;
                }
                case 2: {
                    this.isStaying = false;
                    this.canWander = true;
                    this.playCommandSoundEvent(level, player);
                    message = "messages.kenjiscombatforms.wander_message";
                }
            }
        }
        if (this.m_21824_() && player.m_6047_()) {
            switch (this.interactionState2) {
                case 0: {
                    this.isDefensive = true;
                    this.playCommandSoundEvent(level, player);
                    message = "messages.kenjiscombatforms.defend_message";
                    break;
                }
                case 1: {
                    this.isDefensive = false;
                    this.playCommandSoundEvent(level, player);
                    message = "messages.kenjiscombatforms.passive_message";
                }
            }
        }
        if (!message.isEmpty()) {
            this.sendUniqueMessage(player, message);
        }
        return InteractionResult.SUCCESS;
    }

    private void resetInteraction() {
        this.canInteract = true;
    }

    private void sendUniqueMessage(Player player, String translationKey) {
        MutableComponent translatedMessage = Component.m_237115_((String)translationKey).m_130940_(ChatFormatting.WHITE);
        String name = this.m_7755_().getString();
        MutableComponent greenName = Component.m_237113_((String)name).m_130940_(ChatFormatting.GREEN);
        MutableComponent fullMessage = Component.m_237113_((String)"\u00a7a [").m_7220_((Component)greenName).m_7220_((Component)Component.m_237113_((String)"\u00a7a]: ")).m_7220_((Component)translatedMessage);
        long currentTime = System.currentTimeMillis();
        if (currentTime - this.lastMessageTime > 250L) {
            player.m_213846_((Component)fullMessage);
            this.lastMessageTime = currentTime;
        }
    }

    private void tameMessage(Player player, String translationKey) {
        MutableComponent translatedMessage = Component.m_237115_((String)translationKey).m_130940_(ChatFormatting.WHITE);
        String name = this.m_7755_().getString();
        String greenName = Component.m_237113_((String)name).m_130940_(ChatFormatting.GREEN).getString();
        MutableComponent fullMessage = Component.m_237113_((String)"\u00a7a [").m_130946_(greenName).m_7220_((Component)Component.m_237113_((String)"\u00a7a]: ")).m_7220_((Component)translatedMessage);
        player.m_213846_((Component)fullMessage);
    }

    public void m_6710_(@Nullable LivingEntity lEntity) {
        if (this.m_21188_() != null) {
            if (this.m_21223_() > (float)((Integer)EpicFightCombatFormsCommon.IS_AFRAID_MIN_HEALTH.get()).intValue() && !this.isStaying && !this.m_21188_().m_7306_(this.undeadSensei) && Boolean.FALSE.equals(this.isAfraidCache)) {
                this.m_6703_(lEntity);
            } else if (this.m_21223_() > (float)((Integer)EpicFightCombatFormsCommon.IS_AFRAID_MIN_HEALTH.get()).intValue() && !this.isStaying && this.m_21188_().m_7306_(this.undeadSensei)) {
                this.f_21345_.m_25352_(1, (Goal)new AvoidEntityGoal((PathfinderMob)this, UndeadSenseiEntity.class, 6.0f, 1.4, 1.0));
            }
        }
        if (Boolean.TRUE.equals(this.isAfraidCache) && !this.m_21824_() && !this.isStaying) {
            lEntity = null;
            this.m_7292_(new MobEffectInstance(MobEffects.f_19619_, 300, 0, true, true));
            if (this.tameProgress == 0) {
                this.f_21345_.m_25352_(1, this.avoidPlayerGoal);
            }
        } else if (this.m_21824_() && this.isDefensive && this.m_269323_() != null) {
            this.m_269323_().m_6703_(lEntity);
        } else if (this.m_21824_() && !this.isDefensive) {
            lEntity = null;
        }
        super.m_6710_(lEntity);
    }

    public static boolean checkSpawnRules(EntityType<? extends ExiledSenseiEntity> entityType, ServerLevelAccessor level, MobSpawnType spawnType, BlockPos pos, RandomSource random) {
        double chance = RANDOM.nextDouble();
        if (level instanceof ServerLevel && ((ServerLevel)level).m_46472_() == Level.f_46428_ && level.m_46791_() != Difficulty.PEACEFUL && level.m_8055_(pos.m_7495_()).m_280296_() && level.m_8055_(pos).m_60795_() && level.m_8055_(pos.m_7494_()).m_60795_() && level.m_45517_(LightLayer.BLOCK, pos) > 8) {
            if (level.m_45517_(LightLayer.SKY, pos) < 8) {
                return false;
            }
            int searchRadius = (Integer)EpicFightCombatFormsCommon.EXILED_SENSEI_SPAWNDIST.get();
            List nearbyEntities = level.m_6443_(ExiledSenseiEntity.class, new AABB(pos).m_82400_((double)searchRadius), e -> true);
            if (chance < (Double)EpicFightCombatFormsCommon.EXILED_SENSEI_SPAWN_CHANCE.get() && nearbyEntities.isEmpty()) {
                return true;
            }
        }
        return false;
    }

    public boolean m_21515_() {
        return super.m_21515_();
    }

    public boolean m_142389_() {
        return super.m_142389_();
    }

    protected void m_6475_(@NotNull DamageSource p_21240_, float p_21241_) {
        super.m_6475_(p_21240_, p_21241_);
    }

    public void m_21008_(@NotNull InteractionHand p_21009_, @NotNull ItemStack p_21010_) {
        super.m_21008_(p_21009_, p_21010_);
    }

    @Nullable
    public AgeableMob m_142606_(@NotNull ServerLevel serverLevel, @NotNull AgeableMob ageableMob) {
        return null;
    }
}

