/*
 * Decompiled with CFR 0.152.
 */
package net.kenji.kenjiscombatforms.entity.custom.noAiEntities;

import java.util.List;
import net.kenji.kenjiscombatforms.entity.custom.noAiEntities.EnderEntity;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.entity.monster.Endermite;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;

public class WitherPlayerEntity
extends PathfinderMob {
    private static WitherPlayerEntity INSTANCE;
    private static final EntityDataAccessor<Float> DATA_OPACITY;
    private Vec3 movementInput = Vec3.f_82478_;
    private boolean isMoving;
    private ServerPlayer controllingPlayer;
    private static final float MAX_SPEED = 0.2f;
    private static final float ACCELERATION = 0.05f;
    private static final float DECELERATION = 0.03f;
    private Vec3 currentVelocity = Vec3.f_82478_;
    private double currentVerticalVelocity = 0.0;
    private static final double VERTICAL_ACCELERATION = 0.05;
    private static final double VERTICAL_DECELERATION = 0.03;
    private static final double START_WALKING_THRESHOLD = 0.06;
    private static final double STOP_WALKING_THRESHOLD = 0.1;
    private boolean isWalking = false;

    public WitherPlayerEntity(EntityType<? extends PathfinderMob> p_27403_, Level p_27404_) {
        super(p_27403_, p_27404_);
        if (INSTANCE == null) {
            INSTANCE = this;
        }
    }

    public void onAddedToWorld() {
        this.setOpacity(0.7f);
        super.onAddedToWorld();
    }

    public static WitherPlayerEntity getInstance() {
        return INSTANCE;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_OPACITY, (Object)Float.valueOf(1.0f));
    }

    public void setOpacity(float opacity) {
        this.f_19804_.m_135381_(DATA_OPACITY, (Object)Float.valueOf(Mth.m_14036_((float)opacity, (float)0.0f, (float)1.0f)));
    }

    public float getOpacity() {
        return ((Float)this.f_19804_.m_135370_(DATA_OPACITY)).floatValue();
    }

    public void setMovementInput(ServerPlayer player, boolean forward, boolean backward, boolean left, boolean right, boolean up, boolean down) {
        float strafeInput;
        float forwardInput;
        this.controllingPlayer = player;
        float f = forward ? 1.0f : (forwardInput = (float)(backward ? -1 : 0));
        float f2 = left ? 1.0f : (strafeInput = (float)(right ? -1 : 0));
        float verticalInput = up ? 1.0f : (float)(down ? -1 : 0);
        this.movementInput = new Vec3((double)strafeInput, (double)verticalInput, (double)forwardInput);
    }

    public void m_7023_(Vec3 travelVector) {
        this.getCapability(EpicFightCapabilities.CAPABILITY_ENTITY).ifPresent(cap -> {
            if (cap instanceof LivingEntityPatch) {
                LivingEntityPatch livingEntityPatch = (LivingEntityPatch)cap;
                if (!livingEntityPatch.getEntityState().attacking()) {
                    if (this.controllingPlayer != null && !this.movementInput.equals((Object)Vec3.f_82478_)) {
                        double speed = 0.1;
                        float yaw = this.controllingPlayer.m_146908_();
                        float pitch = this.controllingPlayer.m_146909_();
                        this.m_146922_(yaw);
                        this.m_146926_(pitch);
                        double motionX = -Math.sin((double)yaw * Math.PI / 180.0) * this.movementInput.f_82481_ + Math.cos((double)yaw * Math.PI / 180.0) * this.movementInput.f_82479_;
                        double motionZ = Math.cos((double)yaw * Math.PI / 180.0) * this.movementInput.f_82481_ + Math.sin((double)yaw * Math.PI / 180.0) * this.movementInput.f_82479_;
                        double motionY = this.movementInput.f_82480_;
                        Vec3 motion = new Vec3(motionX, motionY, motionZ).m_82541_().m_82490_(speed);
                        this.m_20256_(motion);
                        this.m_6478_(MoverType.SELF, this.m_20184_());
                    } else {
                        Vec3 currentMotion = this.m_20184_();
                        double airResistance = 0.98;
                        this.m_20256_(currentMotion.m_82542_(airResistance, airResistance, airResistance));
                        if (this.m_20184_().m_82556_() < 1.0E-4) {
                            this.m_20256_(Vec3.f_82478_);
                        }
                    }
                } else if (livingEntityPatch.getEntityState().attacking()) {
                    this.currentVelocity = Vec3.f_82478_;
                }
            }
        });
    }

    public boolean m_20068_() {
        return true;
    }

    public void m_8119_() {
        super.m_8119_();
        this.handleMovementAnimations();
        this.m_7023_(Vec3.f_82478_);
        this.updateMovement();
        this.monsterAttractTick();
    }

    private void updateMovement() {
        this.getCapability(EpicFightCapabilities.CAPABILITY_ENTITY).ifPresent(cap -> {
            if (cap instanceof LivingEntityPatch) {
                LivingEntityPatch livingEntityPatch = (LivingEntityPatch)cap;
                if (!livingEntityPatch.getEntityState().attacking()) {
                    if (this.controllingPlayer != null) {
                        float yaw = this.controllingPlayer.m_146908_();
                        float pitch = this.controllingPlayer.m_146909_();
                        double motionX = -Math.sin((double)yaw * Math.PI / 180.0) * this.movementInput.f_82481_ + Math.cos((double)yaw * Math.PI / 180.0) * this.movementInput.f_82479_;
                        double motionZ = Math.cos((double)yaw * Math.PI / 180.0) * this.movementInput.f_82481_ + Math.sin((double)yaw * Math.PI / 180.0) * this.movementInput.f_82479_;
                        double targetVerticalVelocity = this.movementInput.f_82480_ * (double)0.2f;
                        Vec3 targetHorizontalVelocity = new Vec3(motionX, 0.0, motionZ).m_82541_().m_82490_((double)0.2f);
                        Vec3 newHorizontalVelocity = new Vec3(this.currentVelocity.f_82479_ + (targetHorizontalVelocity.f_82479_ - this.currentVelocity.f_82479_) * (double)0.05f, 0.0, this.currentVelocity.f_82481_ + (targetHorizontalVelocity.f_82481_ - this.currentVelocity.f_82481_) * (double)0.05f);
                        this.currentVerticalVelocity = Math.abs(targetVerticalVelocity) > 0.001 ? (this.currentVerticalVelocity += (targetVerticalVelocity - this.currentVerticalVelocity) * 0.05) : (this.currentVerticalVelocity *= 0.97);
                        this.currentVelocity = new Vec3(newHorizontalVelocity.f_82479_, this.currentVerticalVelocity, newHorizontalVelocity.f_82481_);
                        this.m_20256_(this.currentVelocity);
                        this.m_6478_(MoverType.SELF, this.m_20184_());
                        this.m_146922_(yaw);
                        this.m_146926_(pitch);
                    } else {
                        this.currentVelocity = this.currentVelocity.m_82490_((double)0.97f);
                        this.currentVerticalVelocity *= 0.97;
                        if (this.currentVelocity.m_82556_() < 1.0E-4 && Math.abs(this.currentVerticalVelocity) < 1.0E-4) {
                            this.currentVelocity = Vec3.f_82478_;
                            this.currentVerticalVelocity = 0.0;
                        }
                        this.m_20256_(this.currentVelocity.m_82520_(0.0, this.currentVerticalVelocity, 0.0));
                        this.m_6478_(MoverType.SELF, this.m_20184_());
                    }
                } else if (livingEntityPatch.getEntityState().attacking()) {
                    this.currentVelocity = Vec3.f_82478_;
                }
            }
        });
    }

    private void handleMovementAnimations() {
        Vec3 forward = Vec3.m_82498_((float)0.0f, (float)this.m_146908_());
        double forwardMotion = this.m_20184_().m_82526_(forward);
        this.m_267689_(0.0f);
        if (forwardMotion > 0.06) {
            this.isWalking = true;
            this.m_267689_(1.0f);
        }
        if (this.isWalking && forwardMotion < 0.1) {
            this.m_267689_(0.0f);
        }
        if (forwardMotion == 0.065) {
            this.isWalking = false;
        }
    }

    private void monsterAttractTick() {
        double radius = 30.0;
        AABB searchArea = new AABB(this.m_20097_()).m_82400_(radius);
        TargetingConditions targetingConditions = TargetingConditions.m_148352_();
        List nearbyEntities = this.m_9236_().m_45971_(Monster.class, targetingConditions, (LivingEntity)this, searchArea);
        for (Monster monster : nearbyEntities) {
            if (!this.monsterTypeCheck(monster)) continue;
            monster.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)monster, EnderEntity.class, 8, true, true, this::isAlive));
        }
    }

    private boolean monsterTypeCheck(Monster monster) {
        return !(monster instanceof Endermite) && !(monster instanceof EnderMan) && !(monster instanceof Creeper);
    }

    private boolean isAlive(LivingEntity livingEntity) {
        return this.m_6084_();
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (source.m_276093_(DamageTypes.f_268566_) || source.m_276093_(DamageTypes.f_268464_) || source.m_276093_(DamageTypes.f_268448_)) {
            float reducedDamage = amount * 0.65f;
            float finalDamage = Math.min(reducedDamage, 10.0f);
            return super.m_6469_(source, finalDamage);
        }
        return false;
    }

    public boolean m_7301_(MobEffectInstance effectInstance) {
        return false;
    }

    static {
        DATA_OPACITY = SynchedEntityData.m_135353_(EnderEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    }
}

