/*
 * Decompiled with CFR 0.152.
 */
package net.kenji.kenjiscombatforms.entity.custom.traders;

import java.util.EnumSet;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import net.kenji.kenjiscombatforms.block.ModBlocks;
import net.kenji.kenjiscombatforms.config.EpicFightCombatFormsCommon;
import net.kenji.kenjiscombatforms.item.ModItems;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.InteractGoal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.LookAtTradingPlayerGoal;
import net.minecraft.world.entity.ai.goal.MoveTowardsRestrictionGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.npc.WanderingTrader;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.item.trading.MerchantOffers;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ScrollTraderEntity
extends WanderingTrader
implements NeutralMob {
    private BlockPos wanderTarget;
    @Nullable
    private Boolean isAngryCache = false;
    private Boolean isAngryCacheLock = true;
    private boolean hasBeenProvoked = false;
    private static final Random RANDOM = new Random();
    private static final UniformInt PERSISTENT_ANGER_TIME = TimeUtil.m_145020_((int)20, (int)39);
    private int remainingPersistentAngerTime;
    @Nullable
    private UUID persistentAngerTarget;

    public ScrollTraderEntity(EntityType<? extends WanderingTrader> p_35843_, Level p_35844_) {
        super(p_35843_, p_35844_);
    }

    public void m_7380_(@NotNull CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128379_("hasBeenProvoked", this.hasBeenProvoked);
    }

    public void m_7378_(@NotNull CompoundTag compound) {
        super.m_7378_(compound);
        this.hasBeenProvoked = compound.m_128471_("hasBeenProvoked");
    }

    public InteractionResult m_6071_(Player pPlayer, InteractionHand pHand) {
        boolean randomBool = this.m_217043_().m_188499_();
        String message = "";
        String name = this.m_7755_().getString();
        String blueName = Component.m_237113_((String)name).m_130940_(ChatFormatting.AQUA).getString();
        if (this.m_9236_().f_46443_ && this.m_5448_() == null && !this.m_21660_()) {
            return InteractionResult.SUCCESS;
        }
        if (this.m_5448_() != null || this.m_21660_() || this.hasBeenProvoked) {
            return InteractionResult.PASS;
        }
        if (pHand != InteractionHand.MAIN_HAND) {
            return InteractionResult.PASS;
        }
        if (this.m_6084_() && !this.m_35306_() && !this.m_6162_() && !this.m_6616_().isEmpty()) {
            this.m_7189_(pPlayer);
            this.m_45301_(pPlayer, this.m_5446_(), 1);
            if (randomBool) {
                message = "How can I help you?";
            } else if (!randomBool) {
                message = "How's your day my good sir?";
            }
            String whiteMessage = "\u00a7f" + message;
            pPlayer.m_213846_((Component)Component.m_237113_((String)("\u00a7b[" + blueName + "\u00a7b]" + whiteMessage)));
            return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
        }
        return super.m_6071_(pPlayer, pHand);
    }

    public float m_6113_() {
        if (this.m_5448_() != null || this.m_21660_()) {
            return 0.15f;
        }
        return 0.13f;
    }

    protected void m_8099_() {
        this.traderGoals();
    }

    public MerchantOffers m_6616_() {
        MerchantOffers offers = new MerchantOffers();
        offers.add((Object)this.createTrade2(Items.f_42616_, 35, ((Block)ModBlocks.ESSENCE_CHANNELING_STATION.get()).m_5456_(), 1, ((Block)ModBlocks.SCROLL_FORMING_STATION.get()).m_5456_(), 1));
        offers.add((Object)this.createTrade2(Items.f_42616_, 16, Items.f_42516_, 12, (Item)ModItems.BLANK_FORM_SCROLL.get(), 1));
        offers.add((Object)this.createTrade2(Items.f_42616_, 12, Items.f_42516_, 6, (Item)ModItems.BLANK_ABILITY_SCROLL.get(), 1));
        offers.add((Object)this.createTrade(Items.f_42616_, 3, Items.f_151056_, 2));
        offers.add((Object)this.createTrade2(Items.f_42616_, 64, (Item)ModItems.POWERESSENCE_TIER2.get(), 2, (Item)ModItems.ABILITY_ESSENCE.get(), 1));
        return offers;
    }

    protected void traderGoals() {
        this.f_21345_.m_25352_(1, (Goal)new LookAtTradingPlayerGoal((AbstractVillager)this));
        this.f_21345_.m_25352_(2, (Goal)new WanderToPositionGoal(this, 2.0, 0.35));
        this.f_21345_.m_25352_(4, (Goal)new MoveTowardsRestrictionGoal((PathfinderMob)this, 0.35));
        this.f_21345_.m_25352_(8, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.35));
        this.f_21345_.m_25352_(9, (Goal)new InteractGoal((Mob)this, Player.class, 3.0f, 1.0f));
        this.f_21345_.m_25352_(10, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 8.0f));
        this.f_21345_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 10, true, false, this::m_21674_));
    }

    public void m_35883_(@javax.annotation.Nullable BlockPos p_35884_) {
        this.wanderTarget = p_35884_;
    }

    BlockPos m_35878_() {
        return this.wanderTarget;
    }

    public boolean m_6469_(DamageSource pSource, float pAmount) {
        Entity entity = pSource.m_7639_();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            this.m_6710_((LivingEntity)pSource.m_7639_());
            boolean randomBool = this.m_217043_().m_188499_();
            boolean randomBool2 = this.m_217043_().m_188499_();
            this.hasBeenProvoked = true;
            String message = "";
            String name = this.m_7755_().getString();
            String redName = Component.m_237113_((String)name).m_130940_(ChatFormatting.RED).getString();
            if (Boolean.FALSE.equals(this.isAngryCache) && randomBool && this.m_21223_() > 50.0f) {
                this.isAngryCache = true;
                this.isAngryCacheLock = true;
                message = "Tf did I do to you?!";
            }
            if (Boolean.FALSE.equals(this.isAngryCache) && !randomBool && this.m_21223_() > 50.0f) {
                this.isAngryCache = true;
                this.isAngryCacheLock = true;
                message = "I would have helped you...";
            }
            if (this.isAngryCacheLock.booleanValue() && this.m_21223_() > 50.0f) {
                String whiteMessage = "\u00a7f" + message;
                player.m_213846_((Component)Component.m_237113_((String)("\u00a7c[" + redName + "\u00a7c]" + whiteMessage)));
                this.isAngryCacheLock = false;
            }
        }
        return super.m_6469_(pSource, pAmount);
    }

    public boolean m_21674_(LivingEntity pTarget) {
        return super.m_21674_(pTarget);
    }

    public void m_6710_(@Nullable LivingEntity pTarget) {
        super.m_6710_(pTarget);
        if (pTarget instanceof Player) {
            this.m_6703_(pTarget);
            this.m_6925_(pTarget.m_20148_());
            this.m_7870_(PERSISTENT_ANGER_TIME.m_214085_(this.f_19796_));
        }
    }

    MerchantOffer createTrade2(Item buyItem, int buyCount, Item buyItem2, int buyCount2, Item sellItem, int sellCount) {
        return new MerchantOffer(new ItemStack((ItemLike)buyItem2, buyCount2), new ItemStack((ItemLike)buyItem, buyCount), new ItemStack((ItemLike)sellItem, sellCount), 2, 3, 0.5f);
    }

    MerchantOffer createTrade(Item buyItem, int buyCount, Item sellItem, int sellCount) {
        return new MerchantOffer(new ItemStack((ItemLike)buyItem, buyCount), new ItemStack((ItemLike)sellItem, sellCount), 2, 3, 0.5f);
    }

    public static boolean checkSpawnRules(EntityType<? extends ScrollTraderEntity> entityType, ServerLevelAccessor level, MobSpawnType spawnType, BlockPos pos, RandomSource random) {
        double chance = RANDOM.nextDouble();
        if (level instanceof ServerLevel && ((ServerLevel)level).m_46472_() == Level.f_46428_ && level.m_45517_(LightLayer.BLOCK, pos) >= 8) {
            if (level.m_45517_(LightLayer.SKY, pos) < 8) {
                return false;
            }
            int playerSearchRadius = (Integer)EpicFightCombatFormsCommon.ABILITY_TRADER_PLAYER_SPAWNDIST.get();
            int traderSearchRadius = (Integer)EpicFightCombatFormsCommon.ABILITY_TRADER_SPAWNDIST.get();
            List nearbyPlayers = level.m_6443_(Player.class, new AABB(pos).m_82400_((double)playerSearchRadius), e -> true);
            List nearbyTraders = level.m_6443_(ScrollTraderEntity.class, new AABB(pos).m_82400_((double)traderSearchRadius), e -> true);
            if (chance < (Double)EpicFightCombatFormsCommon.ABILITY_TRADER_SPAWN_CHANCE.get() && !nearbyPlayers.isEmpty() && nearbyTraders.isEmpty()) {
                return true;
            }
        }
        return false;
    }

    public void m_8119_() {
        super.m_8119_();
    }

    public boolean m_21515_() {
        return super.m_21515_();
    }

    public int m_6784_() {
        return this.remainingPersistentAngerTime;
    }

    public void m_7870_(int pTime) {
        this.remainingPersistentAngerTime = pTime;
    }

    @Nullable
    public UUID m_6120_() {
        return this.persistentAngerTarget;
    }

    public void m_6925_(@Nullable UUID pTarget) {
        this.persistentAngerTarget = pTarget;
    }

    public void m_6825_() {
        this.m_7870_(PERSISTENT_ANGER_TIME.m_214085_(this.f_19796_));
    }

    class WanderToPositionGoal
    extends Goal {
        final ScrollTraderEntity trader;
        final double stopDistance;
        final double speedModifier;

        WanderToPositionGoal(ScrollTraderEntity p_35899_, double p_35900_, double p_35901_) {
            this.trader = p_35899_;
            this.stopDistance = p_35900_;
            this.speedModifier = p_35901_;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public void m_8041_() {
            this.trader.m_35883_(null);
            ScrollTraderEntity.this.f_21344_.m_26573_();
        }

        public boolean m_8036_() {
            BlockPos $$0 = this.trader.m_35878_();
            return $$0 != null && this.isTooFarAway($$0, this.stopDistance);
        }

        public void m_8037_() {
            BlockPos $$0 = this.trader.m_35878_();
            if ($$0 != null && ScrollTraderEntity.this.f_21344_.m_26571_()) {
                if (this.isTooFarAway($$0, 10.0)) {
                    Vec3 $$1 = new Vec3((double)$$0.m_123341_() - this.trader.m_20185_(), (double)$$0.m_123342_() - this.trader.m_20186_(), (double)$$0.m_123343_() - this.trader.m_20189_()).m_82541_();
                    Vec3 $$2 = $$1.m_82490_(10.0).m_82520_(this.trader.m_20185_(), this.trader.m_20186_(), this.trader.m_20189_());
                    ScrollTraderEntity.this.f_21344_.m_26519_($$2.f_82479_, $$2.f_82480_, $$2.f_82481_, this.speedModifier);
                } else {
                    ScrollTraderEntity.this.f_21344_.m_26519_((double)$$0.m_123341_(), (double)$$0.m_123342_(), (double)$$0.m_123343_(), this.speedModifier);
                }
            }
        }

        private boolean isTooFarAway(BlockPos p_35904_, double p_35905_) {
            return !p_35904_.m_203195_((Position)this.trader.m_20182_(), p_35905_);
        }
    }
}

