/*
 * Decompiled with CFR 0.152.
 */
package net.kenji.kenjiscombatforms.event;

import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.kenji.kenjiscombatforms.api.PowerControl;
import net.kenji.kenjiscombatforms.api.handlers.power_data.EnderPlayerDataSets;
import net.kenji.kenjiscombatforms.api.handlers.power_data.WitherPlayerDataSets;
import net.kenji.kenjiscombatforms.api.managers.AbilityManager;
import net.kenji.kenjiscombatforms.api.managers.client_data.ClientFistData;
import net.kenji.kenjiscombatforms.config.EpicFightCombatFormsCommon;
import net.kenji.kenjiscombatforms.item.custom.scrolls.BaseUseItem;
import net.kenji.kenjiscombatforms.keybinds.ModKeybinds;
import net.kenji.kenjiscombatforms.network.voidform.ClientVoidData;
import net.kenji.kenjiscombatforms.network.witherform.ClientWitherData;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ComputeFovModifierEvent;
import net.minecraftforge.client.event.ViewportEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="kenjiscombatforms", value={Dist.CLIENT})
public class FOVEvents {
    private static final FOVEvents INSTANCE = new FOVEvents();
    public Map<UUID, PowerControl.controlRelatedEvents.PlayerData> playerDataMap = new ConcurrentHashMap<UUID, PowerControl.controlRelatedEvents.PlayerData>();
    WitherPlayerDataSets witherDataSets = WitherPlayerDataSets.getInstance();
    EnderPlayerDataSets enderDataSets = EnderPlayerDataSets.getInstance();
    private static final float MAX_ZOOM_OUT = 112.0f;
    private static final float MAX_ZOOM_IN = 40.0f;
    private static final int INITIAL_PRESS_COUNTER = 90;
    private static final int ENDER_FOV = 80;
    private static final float MIN_FOV_MODIFIER = 0.7f;
    private static final int CHARGE_DURATION = 40;

    public static FOVEvents getInstance() {
        return INSTANCE;
    }

    private PowerControl.controlRelatedEvents.PlayerData getOrCreatePlayerData(Player player) {
        return PowerControl.controlRelatedEvents.getInstance().playerDataMap.computeIfAbsent(player.m_20148_(), k -> new PowerControl.controlRelatedEvents.PlayerData());
    }

    private WitherPlayerDataSets.WitherMinionPlayerData getOrCreateMinionPlayerData(Player player) {
        return this.witherDataSets.getOrCreateMinionPlayerData(player);
    }

    private WitherPlayerDataSets.WitherFormPlayerData getOrCreateWitherFormPlayerData(Player player) {
        return this.witherDataSets.getOrCreateWitherFormPlayerData(player);
    }

    private EnderPlayerDataSets.EnderFormPlayerData getOrCreateEnderFormPlayerData(Player player) {
        return this.enderDataSets.getOrCreateEnderFormPlayerData(player);
    }

    @SubscribeEvent
    public static void onComputeFov(ViewportEvent.ComputeFov event) {
        double DEFAULT_FOV = event.getFOV();
        LocalPlayer clientPlayer = Minecraft.m_91087_().f_91074_;
        if (clientPlayer != null) {
            PowerControl.controlRelatedEvents.PlayerData data = FOVEvents.getInstance().getOrCreatePlayerData((Player)clientPlayer);
            WitherPlayerDataSets.WitherDashPlayerData wData = FOVEvents.getInstance().witherDataSets.getOrCreateDashPlayerData((Player)clientPlayer);
            WitherPlayerDataSets.WitherMinionPlayerData wmPlayerData = FOVEvents.getInstance().getOrCreateMinionPlayerData((Player)clientPlayer);
            EnderPlayerDataSets.EnderFormPlayerData ePlayerData = FOVEvents.getInstance().getOrCreateEnderFormPlayerData((Player)clientPlayer);
            EnderPlayerDataSets.TeleportPlayerData tpData = FOVEvents.getInstance().enderDataSets.getOrCreateTeleportPlayerData((Player)clientPlayer);
            int currentWitherCooldown = ClientWitherData.getCooldown();
            ItemStack itemInUse = clientPlayer.m_21211_();
            if ((ModKeybinds.ABILITY1_KEY.m_90857_() || ModKeybinds.ACTIVATE_CURRENT_ABILITY_KEY.m_90857_() && ((Boolean)EpicFightCombatFormsCommon.ABILITY_SELECTION_MODE.get()).booleanValue()) && (AbilityManager.getInstance().getPlayerAbilityData((Player)clientPlayer).chosenAbility1 == AbilityManager.AbilityOption1.VOID_ABILITY1 || ClientFistData.getChosenAbility1() == AbilityManager.AbilityOption1.VOID_ABILITY1)) {
                if (ClientVoidData.getCooldown() <= EnderPlayerDataSets.getInstance().getOrCreateTeleportPlayerData((Player)clientPlayer).getMAX_COOLDOWN() / 2) {
                    float zoomProgress = 1.0f - (float)tpData.tpPressCounter / 90.0f;
                    double halfZoomOut = DEFAULT_FOV + (40.0 - DEFAULT_FOV);
                    double targetFOV = DEFAULT_FOV + (halfZoomOut - DEFAULT_FOV) * (double)Math.min(zoomProgress * 1.0f, 1.0f);
                    event.setFOV(targetFOV);
                } else if (!clientPlayer.m_6117_()) {
                    event.setFOV(DEFAULT_FOV);
                }
            }
            if (ePlayerData.isEnderActive) {
                event.setFOV(80.0);
            }
        }
    }

    @SubscribeEvent
    public static void onComputeFovModifier(ComputeFovModifierEvent event) {
        Player player = event.getPlayer();
        ItemStack itemInUse = player.m_21211_();
        if (itemInUse.m_41720_() instanceof BaseUseItem && player.m_6117_()) {
            int useTime = itemInUse.m_41779_() - player.m_21212_();
            float chargeProgress = Math.min(1.0f, (float)useTime / 40.0f);
            float newFovModifier = 1.0f - chargeProgress * 0.3f;
            event.setNewFovModifier(newFovModifier);
        }
    }
}

