/*
 * Decompiled with CFR 0.152.
 */
package net.kenji.kenjiscombatforms.event.ticking;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.kenji.kenjiscombatforms.api.handlers.CommonEventHandler;
import net.kenji.kenjiscombatforms.api.handlers.FormChangeHandler;
import net.kenji.kenjiscombatforms.api.handlers.LevelHandler;
import net.kenji.kenjiscombatforms.api.handlers.power_data.EnderPlayerDataSets;
import net.kenji.kenjiscombatforms.api.handlers.power_data.WitherPlayerDataSets;
import net.kenji.kenjiscombatforms.api.interfaces.form.AbstractFormData;
import net.kenji.kenjiscombatforms.api.managers.FormLevelManager;
import net.kenji.kenjiscombatforms.api.managers.forms.BasicForm;
import net.kenji.kenjiscombatforms.api.managers.forms.PowerForm;
import net.kenji.kenjiscombatforms.api.managers.forms.SwiftForm;
import net.kenji.kenjiscombatforms.api.managers.forms.VoidForm;
import net.kenji.kenjiscombatforms.api.managers.forms.WitherForm;
import net.kenji.kenjiscombatforms.item.custom.fist_forms.basic_form.BasicFist2Item;
import net.kenji.kenjiscombatforms.item.custom.fist_forms.basic_form.BasicFist3Item;
import net.kenji.kenjiscombatforms.item.custom.fist_forms.basic_form.BasicFistItem;
import net.kenji.kenjiscombatforms.item.custom.fist_forms.power_form.PowerFist2Item;
import net.kenji.kenjiscombatforms.item.custom.fist_forms.power_form.PowerFist3Item;
import net.kenji.kenjiscombatforms.item.custom.fist_forms.power_form.PowerFistItem;
import net.kenji.kenjiscombatforms.item.custom.fist_forms.swift_form.SwiftFist2Item;
import net.kenji.kenjiscombatforms.item.custom.fist_forms.swift_form.SwiftFist3Item;
import net.kenji.kenjiscombatforms.item.custom.fist_forms.swift_form.SwiftFistItem;
import net.kenji.kenjiscombatforms.item.custom.fist_forms.void_form.VoidFist2Item;
import net.kenji.kenjiscombatforms.item.custom.fist_forms.void_form.VoidFistItem;
import net.kenji.kenjiscombatforms.item.custom.fist_forms.wither_form.WitherFist2Item;
import net.kenji.kenjiscombatforms.item.custom.fist_forms.wither_form.WitherFist3Item;
import net.kenji.kenjiscombatforms.item.custom.fist_forms.wither_form.WitherFistItem;
import net.kenji.kenjiscombatforms.item.custom.forms.BaseFormClass;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="kenjiscombatforms", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class FormChangeTick {
    private static final Set<UUID> playersWithOpenGui = new HashSet<UUID>();
    private static final Map<UUID, Boolean> playerGuiStates = new ConcurrentHashMap<UUID, Boolean>();
    private static final Map<UUID, Boolean> playerCombatStates = new ConcurrentHashMap<UUID, Boolean>();

    public static boolean isGuiOpen(Player player) {
        return playerGuiStates.getOrDefault(player.m_20148_(), false);
    }

    public static void setGuiOpen(UUID playerUUID, boolean value) {
        playerGuiStates.put(playerUUID, value);
    }

    public static boolean isHandCombat(Player player) {
        return playerCombatStates.getOrDefault(player.m_20148_(), true);
    }

    public static void setHandCombat(UUID playerUUID, boolean value) {
        playerCombatStates.put(playerUUID, value);
    }

    @SubscribeEvent
    public static void onLevelTick(TickEvent.LevelTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            Level level = event.level;
            LevelHandler levelHandler = LevelHandler.getInstance();
            BasicFistItem defaultFistItem = BasicFistItem.getInstance();
            for (Player player : level.m_6907_()) {
                boolean areFinalActive;
                WitherPlayerDataSets.WitherFormPlayerData wData = WitherPlayerDataSets.getInstance().getOrCreateWitherFormPlayerData(player);
                EnderPlayerDataSets.EnderFormPlayerData eData = EnderPlayerDataSets.getInstance().getOrCreateEnderFormPlayerData(player);
                boolean isWitherActive = wData.isAbilityActive();
                boolean isEnderActive = eData.isAbilityActive();
                boolean bl = areFinalActive = isWitherActive || isEnderActive;
                if (!(player instanceof ServerPlayer)) continue;
                ServerPlayer serverPlayer = (ServerPlayer)player;
                List itemEntities = level.m_45976_(ItemEntity.class, player.m_20191_().m_82400_(5.0));
                for (ItemEntity entity : itemEntities) {
                    ItemStack itemStack = entity.m_32055_();
                    if (!(itemStack.m_41720_() instanceof BaseFormClass)) continue;
                    entity.m_6074_();
                }
            }
        }
    }

    private static boolean basicSelected(Player player) {
        return FormChangeHandler.getInstance().getBasicSelected(player);
    }

    private static boolean voidSelected(Player player) {
        return FormChangeHandler.getInstance().getVoidSelected(player);
    }

    private static boolean witherSelected(Player player) {
        return FormChangeHandler.getInstance().getWitherSelected(player);
    }

    private static boolean swiftSelected(Player player) {
        return FormChangeHandler.getInstance().getSwiftSelected(player);
    }

    private static boolean powerSelected(Player player) {
        return FormChangeHandler.getInstance().getPowerSelected(player);
    }

    private static boolean isNearItem(Player player) {
        return CommonEventHandler.getInstance().getIsNearItem(player);
    }

    private static boolean isGuiClosed(Player player) {
        return !playersWithOpenGui.contains(player.m_20148_());
    }

    private static void setBasicFistForm(ServerPlayer player, int slot) {
        BasicFistItem basicFistItem = BasicFistItem.getInstance();
        BasicFist2Item basicFist2Item = BasicFist2Item.getInstance();
        BasicFist3Item basicFist3Item = BasicFist3Item.getInstance();
        AbstractFormData basicFormData = BasicForm.getInstance().getFormData(player.m_20148_());
        if (basicFormData.getCurrentFormLevel() == FormLevelManager.FormLevel.LEVEL1) {
            basicFistItem.setFormMainHand((Player)player, slot);
        } else if (basicFormData.getCurrentFormLevel() == FormLevelManager.FormLevel.LEVEL2) {
            basicFist2Item.setFormMainHand((Player)player, slot);
        } else if (basicFormData.getCurrentFormLevel() == FormLevelManager.FormLevel.LEVEL3) {
            basicFist3Item.setFormMainHand((Player)player, slot);
        }
    }

    private static void setVoidFistForm(ServerPlayer player, int slot) {
        VoidFistItem voidFistItem = VoidFistItem.getInstance();
        VoidFist2Item voidFist2Item = VoidFist2Item.getInstance();
        VoidFist2Item voidFist3Item = VoidFist2Item.getInstance();
        AbstractFormData voidFormData = VoidForm.getInstance().getFormData(player.m_20148_());
        if (voidFormData.getCurrentFormLevel() == FormLevelManager.FormLevel.LEVEL1) {
            voidFistItem.setVoidFormMainHand((Player)player, slot);
        } else if (voidFormData.getCurrentFormLevel() == FormLevelManager.FormLevel.LEVEL2) {
            voidFist2Item.setVoidFormMainHand((Player)player, slot);
        } else if (voidFormData.getCurrentFormLevel() == FormLevelManager.FormLevel.LEVEL3) {
            voidFist3Item.setVoidFormMainHand((Player)player, slot);
        }
    }

    private static void setWitherFistForm(ServerPlayer player, int slot) {
        WitherFistItem witherFistItem = WitherFistItem.getInstance();
        WitherFist2Item witherFist2Item = WitherFist2Item.getInstance();
        WitherFist3Item witherFist3Item = WitherFist3Item.getInstance();
        AbstractFormData witherFormData = WitherForm.getInstance().getFormData(player.m_20148_());
        if (witherFormData.getCurrentFormLevel() == FormLevelManager.FormLevel.LEVEL1) {
            witherFistItem.setWitherFormMainHand((Player)player, slot);
        } else if (witherFormData.getCurrentFormLevel() == FormLevelManager.FormLevel.LEVEL2) {
            witherFist2Item.setWitherFormMainHand((Player)player, slot);
        } else if (witherFormData.getCurrentFormLevel() == FormLevelManager.FormLevel.LEVEL3) {
            witherFist3Item.setWitherFormMainHand((Player)player, slot);
        }
    }

    private static void setSwiftFistForm(ServerPlayer player, int slot) {
        SwiftFistItem fistItem = SwiftFistItem.getInstance();
        SwiftFist2Item fist2Item = SwiftFist2Item.getInstance();
        SwiftFist3Item fist3Item = SwiftFist3Item.getInstance();
        AbstractFormData swiftFormData = SwiftForm.getInstance().getFormData(player.m_20148_());
        if (swiftFormData.getCurrentFormLevel() == FormLevelManager.FormLevel.LEVEL1) {
            fistItem.setFormMainHand((Player)player, slot);
        } else if (swiftFormData.getCurrentFormLevel() == FormLevelManager.FormLevel.LEVEL2) {
            fist2Item.setFormMainHand((Player)player, slot);
        } else if (swiftFormData.getCurrentFormLevel() == FormLevelManager.FormLevel.LEVEL3) {
            fist3Item.setFormMainHand((Player)player, slot);
        }
    }

    private static void setPowerFistForm(ServerPlayer player, int slot) {
        PowerFistItem fistItem = PowerFistItem.getInstance();
        PowerFist2Item fist2Item = PowerFist2Item.getInstance();
        PowerFist3Item fist3Item = PowerFist3Item.getInstance();
        AbstractFormData powerFormData = PowerForm.getInstance().getFormData(player.m_20148_());
        if (powerFormData.getCurrentFormLevel() == FormLevelManager.FormLevel.LEVEL1) {
            fistItem.setFormMainHand((Player)player, slot);
        } else if (powerFormData.getCurrentFormLevel() == FormLevelManager.FormLevel.LEVEL2) {
            fist2Item.setFormMainHand((Player)player, slot);
        } else if (powerFormData.getCurrentFormLevel() == FormLevelManager.FormLevel.LEVEL3) {
            fist3Item.setFormMainHand((Player)player, slot);
        }
    }
}

