/*
 * Decompiled with CFR 0.152.
 */
package net.kenji.kenjiscombatforms.mixins;

import net.kenji.kenjiscombatforms.api.powers.VoidPowers.EnderFormAbility;
import net.kenji.kenjiscombatforms.api.powers.WitherPowers.WitherFormAbility;
import net.kenji.kenjiscombatforms.network.voidform.ClientVoidData;
import net.kenji.kenjiscombatforms.network.witherform.ClientWitherData;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.entity.player.PlayerRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={PlayerRenderer.class})
public abstract class MixinEntityRenderer<T extends Entity> {
    private static final ResourceLocation ENDER_TEXTURE = new ResourceLocation("kenjiscombatforms", "textures/player_textures/ender_player_texture.png");
    private static final ResourceLocation WITHER_TEXTURE = new ResourceLocation("kenjiscombatforms", "textures/player_textures/wither_player_texture.png");

    @Inject(method={"getTextureLocation*"}, at={@At(value="HEAD")}, cancellable=true)
    private void injectGetTextureLocation(AbstractClientPlayer player, CallbackInfoReturnable<ResourceLocation> cir) {
        boolean getIsEnderActive = EnderFormAbility.getInstance().getEnderFormActive((Player)player);
        boolean isClientEnderActive = ClientVoidData.getIsEnderActive();
        boolean getIsWitherActive = WitherFormAbility.getInstance().getWitherFormActive((Player)player);
        boolean isClientWitherActive = ClientWitherData.getIsWitherActive();
        if (getIsEnderActive || isClientEnderActive) {
            cir.setReturnValue((Object)ENDER_TEXTURE);
        }
        if (getIsWitherActive || isClientWitherActive) {
            cir.setReturnValue((Object)WITHER_TEXTURE);
        }
    }
}

