/*
 * Decompiled with CFR 0.152.
 */
package net.kenji.kenjiscombatforms.network.capability;

import net.kenji.kenjiscombatforms.api.capabilities.ExtraContainerCapability;
import net.kenji.kenjiscombatforms.api.handlers.CommonEventHandler;
import net.kenji.kenjiscombatforms.api.handlers.FormChangeHandler;
import net.kenji.kenjiscombatforms.item.custom.base_items.BaseFistClass;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;

public class SyncNBTPacket {
    private final ItemStack storedItem;
    private final int originalSlot;

    public SyncNBTPacket(ItemStack storedItem, int originalSlot) {
        this.storedItem = storedItem;
        this.originalSlot = originalSlot;
    }

    public SyncNBTPacket(FriendlyByteBuf buf) {
        this.storedItem = buf.m_130267_();
        this.originalSlot = buf.readInt();
    }

    public void encode(FriendlyByteBuf buf) {
        buf.m_130055_(this.storedItem);
        buf.writeInt(this.originalSlot);
    }

    public static void handle(SyncNBTPacket msg, NetworkEvent.Context ctx) {
        ctx.enqueueWork(() -> {
            if (ctx.getDirection().getReceptionSide().isServer()) {
                ServerPlayer player = ctx.getSender();
                if (player != null) {
                    ItemStack currentItem = player.m_150109_().m_8020_(player.m_150109_().f_35977_);
                    player.getCapability(ExtraContainerCapability.EXTRA_CONTAINER_CAP).ifPresent(container -> {
                        CommonEventHandler commonEventHandler = CommonEventHandler.getInstance();
                        if (msg.storedItem.m_41619_()) {
                            if (currentItem.m_41619_()) {
                                FormChangeHandler.getInstance().setSelectedFormChanged(player, msg.originalSlot);
                            } else if (currentItem.m_41720_() instanceof BaseFistClass) {
                                player.m_150109_().m_6836_(msg.originalSlot, ItemStack.f_41583_);
                            }
                        }
                        FormChangeHandler.getInstance().setSelectedFormChanged(player, msg.originalSlot);
                        commonEventHandler.setStoredItemNBT((Player)player, msg.storedItem);
                        commonEventHandler.setOriginalSlot((Player)player, msg.originalSlot);
                        container.setStoredItem(msg.storedItem);
                        container.setOriginalSlot(msg.originalSlot);
                    });
                }
            } else {
                ServerPlayer player = ctx.getSender();
                if (player != null) {
                    player.getCapability(ExtraContainerCapability.EXTRA_CONTAINER_CAP).ifPresent(arg_0 -> SyncNBTPacket.lambda$handle$1((Player)player, msg, arg_0));
                }
            }
        });
        ctx.setPacketHandled(true);
    }

    private static /* synthetic */ void lambda$handle$1(Player player, SyncNBTPacket msg, ExtraContainerCapability.IExtraContainer container) {
        CommonEventHandler commonEventHandler = CommonEventHandler.getInstance();
        player.m_150109_().m_6836_(msg.originalSlot, msg.storedItem);
        commonEventHandler.setStoredItemNBT(player, msg.storedItem);
        commonEventHandler.setOriginalSlot(player, msg.originalSlot);
        container.setStoredItem(msg.storedItem);
        container.setOriginalSlot(msg.originalSlot);
        player.f_36095_.m_38946_();
    }
}

