/*
 * Decompiled with CFR 0.152.
 */
package net.kenji.kenjiscombatforms.network.capability;

import net.kenji.kenjiscombatforms.api.capabilities.ExtraContainerCapability;
import net.kenji.kenjiscombatforms.api.handlers.CommonEventHandler;
import net.kenji.kenjiscombatforms.item.custom.base_items.BaseFistClass;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkEvent;

public class SyncRemovedNBTPacket {
    private final ItemStack storedItem;
    private final int originalSlot;

    public SyncRemovedNBTPacket(ItemStack storedItem, int originalSlot) {
        this.storedItem = storedItem;
        this.originalSlot = originalSlot;
    }

    public SyncRemovedNBTPacket(FriendlyByteBuf buf) {
        this.storedItem = buf.m_130267_();
        this.originalSlot = buf.readInt();
    }

    public void encode(FriendlyByteBuf buf) {
        buf.m_130055_(this.storedItem);
        buf.writeInt(this.originalSlot);
    }

    public static void handle(SyncRemovedNBTPacket msg, NetworkEvent.Context ctx) {
        ctx.enqueueWork(() -> {
            ServerPlayer player;
            if (ctx.getDirection().getReceptionSide().isServer()) {
                ServerPlayer player2 = ctx.getSender();
                if (player2 != null && msg.originalSlot != -1) {
                    player2.getCapability(ExtraContainerCapability.EXTRA_CONTAINER_CAP).ifPresent(container -> {
                        ItemStack currentItem = player2.m_150109_().m_8020_(player.m_150109_().f_35977_);
                        CommonEventHandler commonEventHandler = CommonEventHandler.getInstance();
                        if (!msg.storedItem.m_41619_()) {
                            player2.m_150109_().m_6836_(msg.originalSlot, msg.storedItem);
                        }
                        if (msg.storedItem.m_41619_()) {
                            container.setStoredItem(ItemStack.f_41583_);
                            if (player2.m_150109_().m_8020_(msg.originalSlot).m_41720_() instanceof BaseFistClass) {
                                player2.m_150109_().m_6836_(msg.originalSlot, ItemStack.f_41583_);
                            }
                        }
                        commonEventHandler.setStoredItemNBT((Player)player2, msg.storedItem);
                        commonEventHandler.setOriginalSlot((Player)player2, msg.originalSlot);
                        container.setStoredItem(msg.storedItem);
                        container.setOriginalSlot(msg.originalSlot);
                    });
                }
            } else if (ctx.getDirection().getReceptionSide().isClient() && (player = ctx.getSender()) != null && player.m_9236_().f_46443_) {
                SyncRemovedNBTPacket.clientSideSync((Player)player, msg);
            }
        });
        ctx.setPacketHandled(true);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void clientSideSync(Player player, SyncRemovedNBTPacket msg) {
        if (msg.originalSlot != -1) {
            player.getCapability(ExtraContainerCapability.EXTRA_CONTAINER_CAP).ifPresent(container -> {
                ItemStack currentItem = player.m_150109_().m_8020_(player.m_150109_().f_35977_);
                CommonEventHandler commonEventHandler = CommonEventHandler.getInstance();
                if (!msg.storedItem.m_41619_()) {
                    player.m_150109_().m_6836_(msg.originalSlot, msg.storedItem);
                }
                if (msg.storedItem.m_41619_()) {
                    container.setStoredItem(ItemStack.f_41583_);
                    if (player.m_150109_().m_8020_(msg.originalSlot).m_41720_() instanceof BaseFistClass) {
                        player.m_150109_().m_6836_(msg.originalSlot, ItemStack.f_41583_);
                    }
                }
                commonEventHandler.setStoredItemNBT(player, msg.storedItem);
                commonEventHandler.setOriginalSlot(player, msg.originalSlot);
                container.setStoredItem(msg.storedItem);
                container.setOriginalSlot(msg.originalSlot);
            });
        }
    }
}

