/*
 * Decompiled with CFR 0.152.
 */
package net.kenji.kenjiscombatforms.network.fist_forms.client_data;

import net.kenji.kenjiscombatforms.api.managers.AbilityManager;
import net.kenji.kenjiscombatforms.api.managers.FormManager;
import net.kenji.kenjiscombatforms.api.managers.client_data.ClientFistData;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkEvent;

public class SyncClientAbilityPacket {
    private final AbilityManager.AbilityOption1 currentAbility1;
    private final AbilityManager.AbilityOption2 currentAbility2;
    private final AbilityManager.AbilityOption3 currentAbility3;
    private final AbilityManager.AbilityOption1 chosenAbility1;
    private final AbilityManager.AbilityOption2 chosenAbility2;
    private final AbilityManager.AbilityOption3 chosenAbility3;
    private final FormManager.FormSelectionOption selectedForm;

    public SyncClientAbilityPacket(AbilityManager.AbilityOption1 currentAbility1, AbilityManager.AbilityOption2 currentAbility2, AbilityManager.AbilityOption3 currentAbility3, AbilityManager.AbilityOption1 chosenAbility1, AbilityManager.AbilityOption2 chosenAbility2, AbilityManager.AbilityOption3 chosenAbility3, FormManager.FormSelectionOption selectedForm) {
        this.currentAbility1 = currentAbility1;
        this.currentAbility2 = currentAbility2;
        this.currentAbility3 = currentAbility3;
        this.chosenAbility1 = chosenAbility1;
        this.chosenAbility2 = chosenAbility2;
        this.chosenAbility3 = chosenAbility3;
        this.selectedForm = selectedForm;
    }

    public SyncClientAbilityPacket(FriendlyByteBuf buf) {
        this.currentAbility1 = (AbilityManager.AbilityOption1)buf.m_130066_(AbilityManager.AbilityOption1.class);
        this.currentAbility2 = (AbilityManager.AbilityOption2)buf.m_130066_(AbilityManager.AbilityOption2.class);
        this.currentAbility3 = (AbilityManager.AbilityOption3)buf.m_130066_(AbilityManager.AbilityOption3.class);
        this.chosenAbility1 = (AbilityManager.AbilityOption1)buf.m_130066_(AbilityManager.AbilityOption1.class);
        this.chosenAbility2 = (AbilityManager.AbilityOption2)buf.m_130066_(AbilityManager.AbilityOption2.class);
        this.chosenAbility3 = (AbilityManager.AbilityOption3)buf.m_130066_(AbilityManager.AbilityOption3.class);
        this.selectedForm = (FormManager.FormSelectionOption)buf.m_130066_(FormManager.FormSelectionOption.class);
    }

    public void encode(FriendlyByteBuf buf) {
        buf.m_130068_((Enum)this.currentAbility1);
        buf.m_130068_((Enum)this.currentAbility2);
        buf.m_130068_((Enum)this.currentAbility3);
        buf.m_130068_((Enum)this.chosenAbility1);
        buf.m_130068_((Enum)this.chosenAbility2);
        buf.m_130068_((Enum)this.chosenAbility3);
        buf.m_130068_((Enum)this.selectedForm);
    }

    public static void handle(SyncClientAbilityPacket msg, NetworkEvent.Context ctx) {
        ctx.enqueueWork(() -> {
            if (ctx.getDirection().getReceptionSide().isClient()) {
                SyncClientAbilityPacket.clientSideOperations(msg);
            }
        });
        ctx.setPacketHandled(true);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void clientSideOperations(SyncClientAbilityPacket msg) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player != null) {
            ClientFistData.setSpecificFormData((Player)player);
            ClientFistData.setCurrentAbility1(msg.currentAbility1);
            ClientFistData.setCurrentAbility2(msg.currentAbility2);
            ClientFistData.setCurrentAbility3(msg.currentAbility3);
            ClientFistData.setChosenAbility1(msg.chosenAbility1);
            ClientFistData.setChosenAbility2(msg.chosenAbility2);
            ClientFistData.setChosenAbility3(msg.chosenAbility3);
            ClientFistData.setSelectedForm(msg.selectedForm);
        }
    }
}

