/*
 * Decompiled with CFR 0.152.
 */
package net.kenji.kenjiscombatforms.network.fist_forms.client_data;

import net.kenji.kenjiscombatforms.api.managers.FormLevelManager;
import net.kenji.kenjiscombatforms.api.managers.FormManager;
import net.kenji.kenjiscombatforms.api.managers.client_data.ClientFistData;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkEvent;

public class SyncClientFormsPacket {
    private final FormManager.FormSelectionOption form1;
    private final FormManager.FormSelectionOption from2;
    private final FormManager.FormSelectionOption from3;
    private final FormLevelManager.FormLevel currentFormLevel;
    private final int currentFormXp;
    private final int currentFormXpMAX;

    public SyncClientFormsPacket(FormManager.FormSelectionOption form1Option, FormManager.FormSelectionOption form2Option, FormManager.FormSelectionOption form3Option, FormLevelManager.FormLevel currentFormLevel, int currentFormXp, int currentFormXpMAX) {
        this.form1 = form1Option;
        this.from2 = form2Option;
        this.from3 = form3Option;
        this.currentFormLevel = currentFormLevel;
        this.currentFormXp = currentFormXp;
        this.currentFormXpMAX = currentFormXpMAX;
    }

    public SyncClientFormsPacket(FriendlyByteBuf buf) {
        this.form1 = (FormManager.FormSelectionOption)buf.m_130066_(FormManager.FormSelectionOption.class);
        this.from2 = (FormManager.FormSelectionOption)buf.m_130066_(FormManager.FormSelectionOption.class);
        this.from3 = (FormManager.FormSelectionOption)buf.m_130066_(FormManager.FormSelectionOption.class);
        this.currentFormLevel = (FormLevelManager.FormLevel)buf.m_130066_(FormLevelManager.FormLevel.class);
        this.currentFormXp = buf.readInt();
        this.currentFormXpMAX = buf.readInt();
    }

    public void encode(FriendlyByteBuf buf) {
        buf.m_130068_((Enum)this.form1);
        buf.m_130068_((Enum)this.from2);
        buf.m_130068_((Enum)this.from3);
        buf.m_130068_((Enum)this.currentFormLevel);
        buf.writeInt(this.currentFormXp);
        buf.writeInt(this.currentFormXpMAX);
    }

    public static void handle(SyncClientFormsPacket msg, NetworkEvent.Context ctx) {
        ctx.enqueueWork(() -> {
            if (ctx.getDirection().getReceptionSide().isClient()) {
                SyncClientFormsPacket.clientSideOperations(msg);
            }
        });
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void clientSideOperations(SyncClientFormsPacket msg) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player != null) {
            ClientFistData.setForm1Option(msg.form1);
            ClientFistData.setForm2Option(msg.from2);
            ClientFistData.setForm3Option(msg.from3);
            ClientFistData.setSpecificFormData((Player)player);
            ClientFistData.setCurrentFormLevel(msg.currentFormLevel);
            ClientFistData.setCurrentFormXp(msg.currentFormXp);
            ClientFistData.setCurrentFormXpMAX(msg.currentFormXpMAX);
        }
    }
}

