/*
 * Decompiled with CFR 0.152.
 */
package net.kenji.kenjiscombatforms.network.fist_forms.form_level;

import net.kenji.kenjiscombatforms.api.handlers.data_handle.SavedDataHandler;
import net.kenji.kenjiscombatforms.api.interfaces.form.AbstractFormData;
import net.kenji.kenjiscombatforms.api.interfaces.form.Form;
import net.kenji.kenjiscombatforms.api.managers.FormLevelManager;
import net.kenji.kenjiscombatforms.api.managers.FormManager;
import net.kenji.kenjiscombatforms.network.NetworkHandler;
import net.kenji.kenjiscombatforms.network.fist_forms.client_data.SyncClientFormsPacket;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

public class SyncServerFormLevelPacket {
    private final String currentForm;
    private final int formXp;
    private final int formXpMAX;
    private final FormLevelManager.FormLevel formLevel;

    public SyncServerFormLevelPacket(String currentForm, int formXp, int formXpMAX, FormLevelManager.FormLevel formLevel) {
        this.currentForm = currentForm;
        this.formXp = formXp;
        this.formXpMAX = formXpMAX;
        this.formLevel = formLevel;
    }

    public SyncServerFormLevelPacket(FriendlyByteBuf buf) {
        this.currentForm = buf.m_130277_();
        this.formXp = buf.readInt();
        this.formXpMAX = buf.readInt();
        this.formLevel = (FormLevelManager.FormLevel)buf.m_130066_(FormLevelManager.FormLevel.class);
    }

    public void encode(FriendlyByteBuf buf) {
        buf.m_130070_(this.currentForm);
        buf.writeInt(this.formXp);
        buf.writeInt(this.formXpMAX);
        buf.m_130068_((Enum)this.formLevel);
    }

    public static void handle(SyncServerFormLevelPacket msg, NetworkEvent.Context ctx) {
        ctx.enqueueWork(() -> {
            ServerPlayer player = ctx.getSender();
            if (player != null) {
                FormManager.PlayerFormData formData = FormManager.getInstance().getOrCreatePlayerFormData((Player)player);
                Form form = FormManager.getInstance().getForm(msg.currentForm);
                AbstractFormData currentFormData = form.getFormData(player.m_20148_());
                currentFormData.setCurrentFormXp(msg.formXp);
                currentFormData.setCurrentFormXpMAX(msg.formXpMAX);
                currentFormData.setCurrentFormLevel(msg.formLevel);
                SavedDataHandler savedData = SavedDataHandler.get(player.m_284548_());
                savedData.updatePlayerData(player.m_20148_());
                savedData.m_77762_();
                NetworkHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> player), (Object)new SyncClientFormsPacket(formData.form1, formData.form2, formData.form3, msg.formLevel, msg.formXp, msg.formXpMAX));
            }
        });
        ctx.setPacketHandled(true);
    }
}

