/*
 * Decompiled with CFR 0.152.
 */
package net.kenji.kenjiscombatforms.network.movers;

import net.kenji.kenjiscombatforms.api.powers.WitherPowers.WitherFormAbility;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkEvent;

public class WitherInputPacket {
    public final boolean jump;
    public final boolean sneak;

    public WitherInputPacket(boolean jump, boolean sneak) {
        this.jump = jump;
        this.sneak = sneak;
    }

    public void encode(FriendlyByteBuf buf) {
        buf.writeBoolean(this.jump);
        buf.writeBoolean(this.sneak);
    }

    public static WitherInputPacket decode(FriendlyByteBuf buf) {
        return new WitherInputPacket(buf.readBoolean(), buf.readBoolean());
    }

    public static boolean handle(WitherInputPacket message, NetworkEvent.Context ctx) {
        ctx.enqueueWork(() -> {
            ServerPlayer player = ctx.getSender();
            if (player != null) {
                WitherFormAbility.getInstance().upDown((Player)player, message.sneak, message.jump);
            }
        });
        ctx.setPacketHandled(true);
        return true;
    }
}

