/*
 * Decompiled with CFR 0.152.
 */
package net.kenji.kenjiscombatforms.network.particle_packets;

import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.RandomSource;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;

public class MinionSummonParticlesPacket {
    private final BlockPos blockPos;
    private final int radius;
    private final int particleCount;
    private final int lineCount;

    public MinionSummonParticlesPacket(FriendlyByteBuf buf) {
        this.blockPos = buf.m_130135_();
        this.radius = buf.readInt();
        this.particleCount = buf.readInt();
        this.lineCount = buf.readInt();
    }

    public MinionSummonParticlesPacket(BlockPos pos, int radius, int particleCount, int lineCount) {
        this.blockPos = pos;
        this.radius = radius;
        this.particleCount = particleCount;
        this.lineCount = lineCount;
    }

    public static void encode(MinionSummonParticlesPacket msg, FriendlyByteBuf buf) {
        buf.m_130064_(msg.blockPos);
        buf.writeInt(msg.radius);
        buf.writeInt(msg.particleCount);
        buf.writeInt(msg.lineCount);
    }

    public static MinionSummonParticlesPacket decode(FriendlyByteBuf buf) {
        return new MinionSummonParticlesPacket(buf.m_130135_(), buf.readInt(), buf.readInt(), buf.readInt());
    }

    public static void handle(MinionSummonParticlesPacket msg, NetworkEvent.Context ctx) {
        ctx.enqueueWork(() -> {
            if (ctx.getDirection().getReceptionSide() == LogicalSide.CLIENT) {
                MinionSummonParticlesPacket.handleOnClient(msg);
            }
        });
        ctx.setPacketHandled(true);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void handleOnClient(MinionSummonParticlesPacket msg) {
        Minecraft minecraft = Minecraft.m_91087_();
        ClientLevel level = minecraft.f_91073_;
        if (level != null) {
            MinionSummonParticlesPacket.spawnParticles(level, msg.blockPos, msg.radius, msg.particleCount, msg.lineCount);
        }
    }

    public static void spawnParticles(ClientLevel level, BlockPos riftPos, int radius, int particleCount, int lineCount) {
        RandomSource random = level.m_213780_();
        double riftX = (double)riftPos.m_123341_() + 0.5;
        double riftY = (double)riftPos.m_123342_() + 0.5;
        double riftZ = (double)riftPos.m_123343_() + 0.5;
        double flatnessFactor = 0.6;
        for (int line = 0; line < lineCount; ++line) {
            double theta = random.m_188500_() * 2.0 * Math.PI;
            double phi = 1.5707963267948966 + (random.m_188500_() - 0.5) * Math.PI * (1.0 - flatnessFactor);
            double dirX = Math.sin(phi) * Math.cos(theta);
            double dirY = Math.cos(phi) * (1.0 - flatnessFactor);
            double dirZ = Math.sin(phi) * Math.sin(theta);
            double dirLength = Math.sqrt(dirX * dirX + dirY * dirY + dirZ * dirZ);
            dirX /= dirLength;
            dirY /= dirLength;
            dirZ /= dirLength;
            for (int i = 0; i < particleCount / lineCount; ++i) {
                double distance = random.m_188500_() * (double)radius;
                double x = riftX + dirX * distance;
                double y = riftY + dirY * distance;
                double z = riftZ + dirZ * distance;
                double deltaX = riftX - x;
                double deltaY = riftY - y;
                double deltaZ = riftZ - z;
                double length = Math.sqrt(deltaX * deltaX + deltaY * deltaY + deltaZ * deltaZ);
                double speed = 0.02 + distance / (double)radius * 0.05;
                deltaX = deltaX / length * speed;
                deltaY = deltaY / length * speed;
                deltaZ = deltaZ / length * speed;
                level.m_7106_((ParticleOptions)ParticleTypes.f_123755_, x, y, z, deltaX, deltaY, deltaZ);
            }
        }
    }
}

