/*
 * Decompiled with CFR 0.152.
 */
package net.kenji.kenjiscombatforms.network.particle_packets;

import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;

public class SmokeParticlesPacket {
    private final double x;
    private final double y;
    private final double z;

    public SmokeParticlesPacket(FriendlyByteBuf buf) {
        this.x = buf.readDouble();
        this.y = buf.readDouble();
        this.z = buf.readDouble();
    }

    public SmokeParticlesPacket(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public static void encode(SmokeParticlesPacket msg, FriendlyByteBuf buf) {
        buf.writeDouble(msg.x);
        buf.writeDouble(msg.y);
        buf.writeDouble(msg.z);
    }

    public static SmokeParticlesPacket decode(FriendlyByteBuf buf) {
        return new SmokeParticlesPacket(buf.readDouble(), buf.readDouble(), buf.readDouble());
    }

    public static void handle(SmokeParticlesPacket msg, NetworkEvent.Context ctx) {
        ctx.enqueueWork(() -> {
            if (ctx.getDirection().getReceptionSide() == LogicalSide.CLIENT) {
                SmokeParticlesPacket.handleOnClient(msg);
            }
        });
        ctx.setPacketHandled(true);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void handleOnClient(SmokeParticlesPacket msg) {
        Minecraft minecraft = Minecraft.m_91087_();
        ClientLevel level = minecraft.f_91073_;
        if (level != null) {
            SmokeParticlesPacket.spawnParticles((Level)level, msg.x, msg.y, msg.z);
        }
    }

    private static void spawnParticles(Level level, double x, double y, double z) {
        Random random = new Random();
        int particleCount = 100;
        for (int i = 0; i < particleCount; ++i) {
            double offsetX = (random.nextDouble() - 0.5) * 2.0;
            double offsetY = (random.nextDouble() - 0.5) * 2.0;
            double offsetZ = (random.nextDouble() - 0.5) * 2.0;
            double velocityX = (random.nextDouble() - 0.5) * 0.5;
            double velocityY = random.nextDouble() * 0.5;
            double velocityZ = (random.nextDouble() - 0.5) * 0.5;
            level.m_7106_((ParticleOptions)ParticleTypes.f_123762_, x + offsetX, y + 1.0 + offsetY, z + offsetZ, velocityX, velocityY, velocityZ);
        }
    }
}

