/*
 * Decompiled with CFR 0.152.
 */
package net.kenji.kenjiscombatforms.network.particle_packets;

import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;

public class SoulParticlesTickPacket {
    private final double x;
    private final double y;
    private final double z;
    private final boolean isInvisible;

    public SoulParticlesTickPacket(FriendlyByteBuf buf) {
        this.x = buf.readDouble();
        this.y = buf.readDouble();
        this.z = buf.readDouble();
        this.isInvisible = buf.readBoolean();
    }

    public SoulParticlesTickPacket(double x, double y, double z, boolean isInvisible) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.isInvisible = isInvisible;
    }

    public static void encode(SoulParticlesTickPacket msg, FriendlyByteBuf buf) {
        buf.writeDouble(msg.x);
        buf.writeDouble(msg.y);
        buf.writeDouble(msg.z);
        buf.writeBoolean(msg.isInvisible);
    }

    public static SoulParticlesTickPacket decode(FriendlyByteBuf buf) {
        return new SoulParticlesTickPacket(buf.readDouble(), buf.readDouble(), buf.readDouble(), buf.readBoolean());
    }

    public static void handle(SoulParticlesTickPacket msg, NetworkEvent.Context ctx) {
        ctx.enqueueWork(() -> {
            if (ctx.getDirection().getReceptionSide() == LogicalSide.CLIENT) {
                SoulParticlesTickPacket.handleOnClient(msg);
            }
        });
        ctx.setPacketHandled(true);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void handleOnClient(SoulParticlesTickPacket msg) {
        Minecraft minecraft = Minecraft.m_91087_();
        ClientLevel level = minecraft.f_91073_;
        if (level != null && msg.isInvisible) {
            SoulParticlesTickPacket.spawnParticles((Level)level, msg.x, msg.y, msg.z);
        }
    }

    private static void spawnParticles(Level level, double x, double y, double z) {
        Random random = new Random();
        int particleCount = 4;
        for (int i = 0; i < particleCount; ++i) {
            double offsetX = (random.nextDouble() - 0.5) * 2.0;
            double offsetY = (random.nextDouble() - 0.5) * 2.0;
            double offsetZ = (random.nextDouble() - 0.5) * 2.0;
            double velocityX = 0.05;
            double velocityY = 0.0;
            double velocityZ = 0.05;
            level.m_7106_((ParticleOptions)ParticleTypes.f_123745_, x + offsetX, y + offsetY, z + offsetZ, velocityX, velocityY, velocityZ);
        }
    }
}

