/*
 * Decompiled with CFR 0.152.
 */
package net.kenji.kenjiscombatforms.network.slots;

import net.kenji.kenjiscombatforms.api.capabilities.ExtraContainerCapability;
import net.kenji.kenjiscombatforms.api.handlers.CommonEventHandler;
import net.kenji.kenjiscombatforms.api.handlers.FormChangeHandler;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;

public class RemoveItemPacket {
    private int originalSlot;
    private ItemStack storedItem;

    public RemoveItemPacket(int originalSlot, ItemStack storedItem) {
        this.originalSlot = originalSlot;
        this.storedItem = storedItem;
    }

    public RemoveItemPacket(FriendlyByteBuf buf) {
        this.originalSlot = buf.readInt();
        this.storedItem = buf.m_130267_();
    }

    public void encode(FriendlyByteBuf buf) {
        buf.writeInt(this.originalSlot);
        buf.m_130055_(this.storedItem);
    }

    public RemoveItemPacket decode(FriendlyByteBuf buf) {
        return new RemoveItemPacket(this.originalSlot, this.storedItem);
    }

    public static void handle(RemoveItemPacket msg, NetworkEvent.Context ctx) {
        ctx.enqueueWork(() -> {
            ServerPlayer player = ctx.getSender();
            if (player != null) {
                CompoundTag nbt = player.getPersistentData();
                CommonEventHandler commonEventHandler = CommonEventHandler.getInstance();
                ItemStack getStoredItem = commonEventHandler.getStoredItem((Player)player);
                player.getCapability(ExtraContainerCapability.EXTRA_CONTAINER_CAP).ifPresent(container -> {
                    if (ctx.getDirection().getReceptionSide().isClient()) {
                        if (!msg.storedItem.m_41619_()) {
                            player.m_150109_().m_6836_(msg.originalSlot, getStoredItem);
                            container.setStoredItem(ItemStack.f_41583_);
                        } else {
                            player.m_150109_().m_6836_(msg.originalSlot, ItemStack.f_41583_);
                        }
                    }
                    if (ctx.getDirection().getReceptionSide().isServer()) {
                        FormChangeHandler formChangeHandler = FormChangeHandler.getInstance();
                        int selectedSlot = player.m_150109_().f_35977_;
                        ItemStack currentItem = player.m_150109_().m_8020_(selectedSlot);
                        formChangeHandler.removeCurrentFormItem((Player)player, selectedSlot);
                        player.m_150109_().m_6836_(msg.originalSlot, getStoredItem);
                        container.setStoredItem(ItemStack.f_41583_);
                        player.m_150109_().m_6596_();
                        msg.originalSlot = -1;
                        nbt.m_128473_("storedItem");
                        nbt.m_128473_("originalSlot");
                    }
                });
            }
        });
        ctx.setPacketHandled(true);
    }
}

